# Changelog

### controller-v1.11.0

Images:

* registry.k8s.io/ingress-nginx/controller:v1.11.0@sha256:a886e56d532d1388c77c8340261149d974370edca1093af4c97a96fb1467cb39
* registry.k8s.io/ingress-nginx/controller-chroot:v1.11.0@sha256:f16dfed1c94d216b65e5dcb7508ab46148641a99649c5a700749db6f01a7039e

### All changes:

* update test runner to latest build (#11558)
* add k8s 1.30 to ci build (#11554)
* update test runner go base to 3.20 (#11552)
* tag new test runner image with new nginx base 0.0.8 (#11551)
* bump NGINX_BASE to v0.0.8 (#11544)
* add ssl patches to nginx-1.25 image for coroutines to work in lua client hello and cert ssl blocks (#11535)
* trigger build for NGINX-1.25 v0.0.8 (#11539)
* bump alpine version to 3.20 to custom-error-pages (#11538)
* fix: Ensure changes in MatchCN annotation are detected (#11529)
* Docs: Add information about HTTP/3 support. (#11513)
* Docs: Specify `ingressClass` for multi-controller setup. (#11493)
* Docs: Improve default certificate usage. (#11504)
* Upgrade OWASP_MODSECURITY_CRS_VERSION 3.3.5 to 4.4.0 and update docs (#11511)
* docs: Update Ingress-NGINX v1.10.1 compatibility with Kubernetes v1.30 (#11495)
* Update getting-started.md with new prerequisites (#11486)
* [feature] bump nginx to 1.25.5 and add http3 module (#11470)
* Fix boolean configuration (#11483)
* Chores: Align security contacts & chart maintainers to actual owners. (#11465)
* CI: Bump forgotten Ginkgo versions. (#11467)
* Tests: Replace deprecated `grpc.Dial` by `grpc.NewClient`. (#11462)
* Owners: Promote Gacko to admin. (#11463)
* Chart: Make pod affinity templatable. (#11453)
* fixed fastcgi userguide (#11454)
* Remove unnecessary space character (#11434)
* upgrade to alpine 3.20 (#11428)
* fix for docs issue 11432 (#11433)
* Update index.md (#11437)
* update golang to 1.22.4 (#11427)
* Chart: Fix `IngressClass` annotations. (#11416)
* Chart: Make admission webhook patch job RBAC configurable. (#11376)
* Merge pull request #11277 from strongjz/chart-1.10.1 (#11415)
* Chart: Remove `controller.enableWorkerSerialReloads`. (#11400)
* Adapt dashboards for Grafana 11 compatibility (#11399)
* Rename variable to fix typo (#11395)
* Fix helm install on cloud provider admonition block (#11394)
* edited helm-install tips (#11393)
* added info for aws helm install (#11390)
* added multiplecontrollers-howto to faq (#11389)
* removed tlsv1 & tlsv1.1 (#11343)
* feat: Add grpc timeouts annotations (#11258)
* sfix position of options (#11379)
* add workflow to helm release and update ct for branch (#11378)
* Accept user defined annotations in IngressClass (#11362)
* Docs: Remove opentracing and zipkin from docs (#11361)
* Allow configuring nginx worker reload behaviour, to prevent multiple concurrent worker reloads which can lead to high resource usage and OOMKill (#10884)
* chore(deps): group update k8s.io packages to v0.30.0 (#11344)
* Fix function name in comment (#11296)
* fix path in file changed detected message (#11271)
* chore: fix function names in comment (#11280)
* fix: update kube version requirement to 1.21 (#11275)
* release helm chart from release branch (#11276)
* update k8s version to latest kind release (#11240)
* feat: add annotation to allow to add custom response headers (#9742)
* remove _ssl_expire_time_seconds metric by identifier (#9706)
* update post submit helm ci and clean up (#11220)
* Chart: Add unit tests for default backend & topology spread constraints. (#11218)
* sort default backend hpa metrics (#11215)
* updated certgen image shatag (#11214)
* feature(default_backend): topologySpreadConstraints on default backend (#11197)
* bumped certgeimage tag (#11212)
* changed testrunner image sha (#11207)
* updated baseimage & deleted a useless file (#11208)
* Chart: Make `controller.config` templatable. (#11181)
* chunking related faq update (#11196)
* bump ginkgo to 2-17-1 in testrunner (#11202)
* Owners: Promote Gacko to `ingress-nginx-maintainers` & `ingress-nginx-reviewers`. (#11165)
* Fix-semver (#11193)
* refactor helm ci tests part I (#11178)
* fixes brotli build issue (#10484)
* bump ginkgo to v2.17.1 (#11177)
* Proposal: e2e tests for regex patterns (#11174)
* Controller: Make Leader Election TTL configurable. (#11142)
* Chores: Remove recently added whitespaces. (#11156)
* Add GRPC Buffer Size to the Configmap (#11155)
* fix geoip2 configuration docs (#11150)
* feature(geoip2_autoreload): Enable GeoIP2 auto_reload config  (#11079)
* Chart: Add IngressClass aliases. (#11109)
* Fix typos in OTel doc (#11081)
* Chart: Render `controller.ingressClassResource.parameters` natively. (#11108)
* Fix admission controller logging of `admissionTime` and `testedConfigurationSize` (#11089)
* Chart: Align HPA & KEDA conditions. (#11110)
* Chart: Add Gacko to maintainers. Again. (#11107)
* Chart: Improve IngressClass documentation. (#11104)
* Chart: Deploy `PodDisruptionBudget` with KEDA. (#11032)
* Undo #11062 since it breaks the nginx config (#11082)
* [mTLS] Fix acme verification when mTLS and Client CN verification is enabled (#11062)
* golangci-lint update, ci cleanup, group dependabot updates (#11071)
* bump golang (#11070)
* feature(leader_election): flag to disable leader election feature on controller (#11064)
* docs: update the 404 link to FAQ (#11069)
* Update README.md (#11065)
* quotes around numbers fort ports definitions (#11052)

### Dependency updates:

* Bump the all group with 2 updates (#11523)
* Bump k8s.io/klog/v2 from 2.130.0 to 2.130.1 in the all group (#11499)
* Bump aquasecurity/trivy-action from 0.22.0 to 0.23.0 in the all group (#11497)
* Bump k8s.io/klog/v2 from 2.120.1 to 2.130.0 (#11475)
* Bump the all group with 3 updates (#11474)
* Bump the all group with 2 updates (#11476)
* Bump golang.org/x/crypto from 0.23.0 to 0.24.0 (#11442)
* Bump the all group with 3 updates (#11443)
* Bump sigs.k8s.io/controller-runtime in the all group (#11440)
* Bump goreleaser/goreleaser-action from 5.1.0 to 6.0.0 (#11444)
* Bump github.com/prometheus/common from 0.53.0 to 0.54.0 (#11441)
* Bump the all group with 2 updates (#11419)
* Bump github.com/onsi/ginkgo/v2 from 2.17.2 to 2.19.0 (#11418)
* Bump google.golang.org/grpc from 1.63.2 to 1.64.0 (#11417)
* Bump the all group across 1 directory with 3 updates (#11384)
* Bump the all group across 1 directory with 6 updates (#11383)
* Bump golang.org/x/crypto from 0.22.0 to 0.23.0 (#11357)
* Bump golangci/golangci-lint-action from 5.3.0 to 6.0.1 (#11355)
* Bump the all group with 3 updates (#11348)
* Bump Kubernetes version on images (#11346)
* Bump sigs.k8s.io/controller-runtime from 0.17.3 to 0.18.1 (#11345)
* Bump golangci/golangci-lint-action from 4.0.0 to 5.0.0 (#11328)
* Bump the all group with 4 updates (#11327)
* Bump k8s.io/component-base from 0.29.3 to 0.30.0 (#11291)
* Bump github.com/prometheus/common from 0.52.3 to 0.53.0 (#11290)
* Bump golang.org/x/net from 0.22.0 to 0.23.0 (#11282)
* Bump golang.org/x/net in /images/kube-webhook-certgen/rootfs (#11283)
* Bump the all group with 2 updates (#11261)
* Bump azure/setup-helm from 3.5 to 4 (#11263)
* Bump actions/add-to-project from 1.0.0 to 1.0.1 in the all group (#11262)
* Bump google.golang.org/grpc from 1.63.0 to 1.63.2 (#11237)
* Bump google.golang.org/grpc from 1.62.1 to 1.63.0 (#11228)
* Bump github.com/prometheus/common from 0.51.1 to 0.52.2 (#11227)
* Bump golang.org/x/crypto from 0.21.0 to 0.22.0 (#11229)
* Bump github.com/prometheus/client_model in the all group (#11226)
* Bump the all group with 3 updates (#11225)
* Bump the all group with 2 updates (#11183)
* Bump actions/add-to-project from 0.6.1 to 1.0.0 (#11184)
* Bump the all group with 3 updates (#11157)
* Bump github.com/prometheus/common from 0.50.0 to 0.51.1 (#11159)
* Bump the all group with 4 updates (#11133)
* Bump the all group with 1 update (#11134)
* Bump google.golang.org/protobuf in /images/custom-error-pages/rootfs (#11119)
* Bump google.golang.org/protobuf from 1.32.0 to 1.33.0 in /magefiles (#11121)
* Bump google.golang.org/protobuf in /images/kube-webhook-certgen/rootfs (#11120)
* Bump github.com/onsi/ginkgo/v2 from 2.15.0 to 2.16.0 (#11076)
* Bump the all group with 1 update (#11073)
* Bump the all group with 1 update (#11072)
* Bump github.com/prometheus/common from 0.49.0 to 0.50.0 (#11075)
* Bump actions/download-artifact from 4.1.2 to 4.1.4 (#11059)
* Bump github.com/stretchr/testify from 1.8.4 to 1.9.0 (#11055)
* Bump docker/setup-buildx-action from 3.0.0 to 3.1.0 (#11057)
* Bump github.com/prometheus/common from 0.48.0 to 0.49.0 (#11056)
* Bump github/codeql-action from 3.24.5 to 3.24.6 (#11060)
* Bump aquasecurity/trivy-action from 0.17.0 to 0.18.0 (#11058)
* Bump dorny/paths-filter from 3.0.1 to 3.0.2 (#11061)

**Full Changelog**: https://github.com/kubernetes/ingress-nginx/compare/controller-v1.10.2...controller-v1.11.0
