/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.map;

import java.io.IOException;
import org.geotools.api.data.FeatureListener;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.style.Style;
import org.geotools.data.DataUtilities;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.StyleLayer;
import org.geotools.referencing.CRS;

public class FeatureLayer
extends StyleLayer {
    protected FeatureSource<? extends FeatureType, ? extends Feature> featureSource;
    protected Query query;
    protected FeatureListener sourceListener;

    public FeatureLayer(FeatureSource featureSource, Style style) {
        super(style);
        this.featureSource = featureSource;
    }

    public FeatureLayer(FeatureSource featureSource, Style style, String title) {
        super(style, title);
        this.featureSource = featureSource;
    }

    public FeatureLayer(FeatureCollection collection, Style style) {
        super(style);
        this.featureSource = DataUtilities.source(collection);
        this.style = style;
    }

    public FeatureLayer(FeatureCollection collection, Style style, String title) {
        super(style, title);
        this.featureSource = DataUtilities.source(collection);
    }

    @Override
    protected synchronized void connectDataListener(boolean listen) {
        if (this.sourceListener == null) {
            this.sourceListener = featureEvent -> this.fireMapLayerListenerLayerChanged(3);
        }
        if (listen) {
            this.featureSource.addFeatureListener(this.sourceListener);
        } else {
            this.featureSource.removeFeatureListener(this.sourceListener);
        }
    }

    @Override
    public void dispose() {
        this.preDispose();
        if (this.featureSource != null) {
            if (this.sourceListener != null) {
                this.featureSource.removeFeatureListener(this.sourceListener);
            }
            this.featureSource = null;
        }
        this.style = null;
        this.query = null;
        super.dispose();
    }

    @Override
    public FeatureSource<?, ?> getFeatureSource() {
        return this.featureSource;
    }

    public SimpleFeatureSource getSimpleFeatureSource() {
        FeatureSource<? extends FeatureType, ? extends Feature> featureSource = this.featureSource;
        if (featureSource instanceof SimpleFeatureSource) {
            SimpleFeatureSource source = (SimpleFeatureSource)featureSource;
            return source;
        }
        return null;
    }

    @Override
    public Query getQuery() {
        if (this.query == null) {
            return Query.ALL;
        }
        return this.query;
    }

    public void setQuery(Query query) {
        this.query = query;
        this.fireMapLayerListenerLayerChanged(5);
    }

    @Override
    public ReferencedEnvelope getBounds() {
        try {
            ReferencedEnvelope bounds = this.query != null ? this.featureSource.getBounds(this.query) : this.featureSource.getBounds();
            if (bounds != null) {
                FeatureType schema = this.featureSource.getSchema();
                CoordinateReferenceSystem schemaCrs = schema.getCoordinateReferenceSystem();
                CoordinateReferenceSystem boundsCrs = bounds.getCoordinateReferenceSystem();
                if (boundsCrs == null && schemaCrs != null) {
                    LOGGER.warning("Bounds crs not defined; assuming bounds from schema are correct for " + String.valueOf(this.featureSource));
                    bounds = new ReferencedEnvelope(bounds.getMinX(), bounds.getMaxX(), bounds.getMinY(), bounds.getMaxY(), schemaCrs);
                }
                if (boundsCrs != null && schemaCrs != null && !CRS.equalsIgnoreMetadata(boundsCrs, schemaCrs)) {
                    LOGGER.warning("Bounds crs and schema crs are not consistent; forcing the use of the schema crs so they are consistent");
                    bounds = new ReferencedEnvelope(bounds.getMinX(), bounds.getMaxX(), bounds.getMinY(), bounds.getMaxY(), schemaCrs);
                }
                return bounds;
            }
        }
        catch (IOException bounds) {
            // empty catch block
        }
        CoordinateReferenceSystem crs = this.featureSource.getSchema().getCoordinateReferenceSystem();
        if (crs != null) {
            Bounds envelope = CRS.getEnvelope(crs);
            if (envelope != null) {
                return new ReferencedEnvelope(envelope);
            }
            return new ReferencedEnvelope(crs);
        }
        return null;
    }
}

