/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.label;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.geotools.api.style.TextSymbolizer;
import org.geotools.geometry.jts.LineStringCursor;
import org.geotools.geometry.jts.LiteShape;
import org.geotools.geometry.jts.LiteShape2;
import org.geotools.geometry.jts.TransformedShape;
import org.geotools.renderer.label.LabelCacheImpl;
import org.geotools.renderer.label.LabelCacheItem;
import org.geotools.renderer.label.LabelSplitter;
import org.geotools.renderer.label.LineInfo;
import org.geotools.renderer.label.TransformedIcon;
import org.geotools.renderer.lite.StyledShapePainter;
import org.geotools.renderer.style.GraphicStyle2D;
import org.geotools.renderer.style.IconStyle2D;
import org.geotools.renderer.style.MarkStyle2D;
import org.geotools.renderer.style.Style2D;
import org.geotools.renderer.style.TextStyle2D;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;

public class LabelPainter {
    static final double EPS = 1.0E-6;
    StyledShapePainter shapePainter = new StyledShapePainter();
    LabelCacheItem labelItem;
    List<LineInfo> lines;
    Graphics2D graphics;
    LabelCacheImpl.LabelRenderingMode labelRenderingMode;
    GeometryFactory gf = new GeometryFactory();
    Rectangle2D labelBounds;
    LabelSplitter splitter = new LabelSplitter();

    public LabelPainter(Graphics2D graphics, LabelCacheImpl.LabelRenderingMode labelRenderingMode) {
        this.graphics = graphics;
        this.labelRenderingMode = labelRenderingMode;
    }

    public void setLabel(LabelCacheItem labelItem) {
        this.labelItem = labelItem;
        TextStyle2D textStyle = labelItem.getTextStyle();
        textStyle.setLabel(labelItem.getLabel());
        this.labelBounds = null;
        this.lines = null;
        this.lines = this.splitter.layout(labelItem, this.graphics);
        double maxWidth = 0.0;
        for (LineInfo line : this.lines) {
            maxWidth = Math.max(line.getWidth(), maxWidth);
        }
        double boundsY = 0.0;
        double labelY = 0.0;
        LineInfo previous = null;
        for (LineInfo info : this.lines) {
            Rectangle2D currBounds = info.getBounds();
            double minX = (maxWidth - currBounds.getWidth()) * textStyle.getAnchorX() - currBounds.getMinX();
            info.setMinX(minX);
            double descentLeading = previous == null ? info.getDescentLeading() : previous.getDescentLeading();
            double lineOffset = currBounds.getHeight() + descentLeading;
            if (this.labelBounds == null) {
                this.labelBounds = currBounds;
                boundsY = currBounds.getMinY() + lineOffset;
            } else {
                Rectangle2D.Double translated = new Rectangle2D.Double(minX, boundsY, currBounds.getWidth(), currBounds.getHeight());
                boundsY += lineOffset;
                labelY += lineOffset;
                this.labelBounds = this.labelBounds.createUnion(translated);
            }
            info.setY(labelY);
            previous = info;
        }
        this.normalizeBounds(this.labelBounds);
    }

    void normalizeBounds(Rectangle2D bounds) {
        if (bounds != null && bounds.isEmpty()) {
            bounds.setRect(bounds.getCenterX() - 1.0, bounds.getCenterY() - 1.0, 2.0, 2.0);
        }
    }

    public LabelCacheItem getLabel() {
        return this.labelItem;
    }

    public double getLineHeight() {
        return this.lines.get(0).getLineHeight();
    }

    public double getLineHeightForAnchorY(double anchorY) {
        if (this.lines == null) {
            return 0.0;
        }
        if (this.lines.isEmpty()) {
            return 0.0;
        }
        anchorY = anchorY < 0.0 ? 0.0 : anchorY;
        double d = anchorY = anchorY > 1.0 ? 1.0 : anchorY;
        if (anchorY == 0.0) {
            return this.lines.get(this.getLineCount() - 1).getLineHeight();
        }
        if (anchorY == 1.0) {
            return this.lines.get(0).getLineHeight();
        }
        return this.lines.stream().mapToDouble(l -> l.getLineHeight()).average().orElse(0.0);
    }

    public double getAscent() {
        return this.lines.get(0).getAscent();
    }

    public int getStraightLabelWidth() {
        return (int)Math.round(this.getLabelBounds().getWidth());
    }

    public int getLineCount() {
        return this.lines.size();
    }

    public Rectangle2D getFullLabelBounds() {
        Rectangle2D bounds = (Rectangle2D)this.getLabelBounds().clone();
        int haloRadius = Math.round(this.labelItem.getTextStyle().getHaloFill() != null ? this.labelItem.getTextStyle().getHaloRadius() : 0.0f);
        bounds.add(bounds.getMinX() - (double)haloRadius, bounds.getMinY() - (double)haloRadius);
        bounds.add(bounds.getMaxX() + (double)haloRadius, bounds.getMaxY() + (double)haloRadius);
        if (this.labelItem.getTextStyle().getGraphic() != null) {
            Rectangle2D shieldBounds;
            Rectangle area = this.labelItem.getTextStyle().getGraphicDimensions();
            int[] margin = this.labelItem.getGraphicMargin();
            LabelCacheItem.GraphicResize mode = this.labelItem.getGraphicsResize();
            if (mode == LabelCacheItem.GraphicResize.STRETCH) {
                shieldBounds = this.applyMargins(margin, bounds);
            } else if (mode == LabelCacheItem.GraphicResize.PROPORTIONAL) {
                double factor = 1.0;
                factor = bounds.getWidth() > bounds.getHeight() ? bounds.getWidth() / ((RectangularShape)area).getWidth() : bounds.getHeight() / ((RectangularShape)area).getHeight();
                double width = ((RectangularShape)area).getWidth() * factor;
                double height = ((RectangularShape)area).getHeight() * factor;
                shieldBounds = new Rectangle2D.Double(-width / 2.0 + bounds.getMinX() + bounds.getWidth() / 2.0, -height / 2.0 + bounds.getMinY() + bounds.getHeight() / 2.0, width, height);
                shieldBounds = this.applyMargins(margin, shieldBounds);
            } else {
                shieldBounds = new Rectangle2D.Double(-((RectangularShape)area).getWidth() / 2.0 + bounds.getMinX() + bounds.getWidth() / 2.0, -((RectangularShape)area).getHeight() / 2.0 + bounds.getMinY() + bounds.getHeight() / 2.0, ((RectangularShape)area).getWidth(), ((RectangularShape)area).getHeight());
            }
            bounds = bounds.createUnion(shieldBounds);
        }
        this.normalizeBounds(bounds);
        return bounds;
    }

    Rectangle2D applyMargins(int[] margin, Rectangle2D bounds) {
        if (bounds != null && margin != null) {
            double xmin = bounds.getMinX() - (double)margin[3];
            double ymin = bounds.getMinY() - (double)margin[0];
            double width = bounds.getWidth() + (double)margin[1] + (double)margin[3];
            double height = bounds.getHeight() + (double)margin[0] + (double)margin[2];
            return new Rectangle2D.Double(xmin, ymin, width, height);
        }
        return bounds;
    }

    public Rectangle2D getLabelBounds() {
        return this.labelBounds;
    }

    public void paintStraightLabel(AffineTransform transform) throws Exception {
        this.paintStraightLabel(transform, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintStraightLabel(AffineTransform transform, Coordinate labelPoint) throws Exception {
        AffineTransform oldTransform = this.graphics.getTransform();
        try {
            Style2D graphic = this.labelItem.getTextStyle().getGraphic();
            if (graphic != null) {
                if (labelPoint != null && this.labelItem.getGraphicPlacement() == TextSymbolizer.GraphicPlacement.INDEPENDENT) {
                    center = labelPoint;
                    LiteShape2 tempShape = new LiteShape2((Geometry)this.gf.createPoint(center), null, null, false, false);
                    if ((graphic = this.resizeGraphic(graphic)) != null) {
                        this.shapePainter.paint(this.graphics, tempShape, graphic, graphic.getMaxScale());
                    }
                } else {
                    double offsetY = 0.0;
                    double offsetX = 0.0;
                    int[] margin = this.labelItem.getGraphicMargin();
                    if (margin != null) {
                        offsetX = margin[1] - margin[3];
                        offsetY = margin[2] - margin[0];
                    }
                    LineInfo lastLine = this.lines.get(this.lines.size() - 1);
                    center = new Coordinate(this.labelBounds.getMinX() + this.labelBounds.getWidth() / 2.0 + offsetX, this.labelBounds.getMinY() + lastLine.getBounds().getHeight() - 1.0 * this.labelBounds.getHeight() / 2.0 + offsetY);
                    LiteShape2 tempShape = new LiteShape2((Geometry)this.gf.createPoint(center), null, null, false, false);
                    if ((graphic = this.resizeGraphic(graphic)) != null) {
                        AffineTransform graphicTx = new AffineTransform(transform);
                        graphicTx.translate(lastLine.getComponents().get(0).getX(), lastLine.getY());
                        this.graphics.setTransform(graphicTx);
                        this.shapePainter.paint(this.graphics, tempShape, graphic, graphic.getMaxScale());
                    }
                }
            }
            AffineTransform newTransform = new AffineTransform(oldTransform);
            newTransform.concatenate(transform);
            this.graphics.setTransform(newTransform);
            if (this.labelItem.getTextStyle().getFont().getSize() == 0) {
                return;
            }
            if (this.lines.size() == 1 && this.lines.get(0).getComponents().size() == 1) {
                LineInfo.LineComponent component = this.lines.get(0).getComponents().get(0);
                this.drawGlyphVector(component);
            } else {
                AffineTransform lineTx = new AffineTransform();
                for (LineInfo line : this.lines) {
                    for (LineInfo.LineComponent component : line.getComponents()) {
                        lineTx.setTransform(newTransform);
                        lineTx.translate(component.getX(), line.getY());
                        this.graphics.setTransform(lineTx);
                        this.drawGlyphVector(component);
                    }
                }
            }
        }
        finally {
            this.graphics.setTransform(oldTransform);
        }
    }

    Style2D resizeGraphic(Style2D graphic) {
        LabelCacheItem.GraphicResize mode = this.labelItem.graphicsResize;
        if (mode == LabelCacheItem.GraphicResize.NONE || mode == null) {
            return graphic;
        }
        double width = this.labelBounds.getWidth();
        double height = this.labelBounds.getHeight();
        int[] margin = this.labelItem.graphicMargin;
        if (margin != null) {
            width += (double)(margin[1] + margin[3]);
            height += (double)(margin[0] + margin[2]);
        }
        if (width <= 0.0 || height <= 0.0) {
            return null;
        }
        width = Math.max(Math.round(width), 1L);
        height = Math.max(Math.round(height), 1L);
        if (graphic instanceof MarkStyle2D) {
            MarkStyle2D mark = (MarkStyle2D)graphic;
            Shape original = mark.getShape();
            Rectangle2D bounds = original.getBounds2D();
            MarkStyle2D resized = (MarkStyle2D)mark.clone();
            if (mode == LabelCacheItem.GraphicResize.PROPORTIONAL) {
                if (width > height) {
                    resized.setSize(Math.round(bounds.getHeight() * width / bounds.getWidth()));
                } else {
                    resized.setSize(height);
                }
            } else {
                TransformedShape tss = new TransformedShape();
                tss.shape = original;
                tss.setTransform(AffineTransform.getScaleInstance(width / bounds.getWidth(), height / bounds.getHeight()));
                resized.setShape(tss);
                resized.setSize(height);
            }
            return resized;
        }
        if (graphic instanceof IconStyle2D) {
            AffineTransform at;
            IconStyle2D iconStyle = (IconStyle2D)graphic;
            IconStyle2D resized = (IconStyle2D)iconStyle.clone();
            Icon icon = iconStyle.getIcon();
            if (mode == LabelCacheItem.GraphicResize.PROPORTIONAL) {
                double factor = width > height ? width / (double)icon.getIconWidth() : height / (double)icon.getIconHeight();
                at = AffineTransform.getScaleInstance(factor, factor);
            } else {
                at = AffineTransform.getScaleInstance(width / (double)icon.getIconWidth(), height / (double)icon.getIconHeight());
            }
            resized.setIcon(new TransformedIcon(icon, at));
            return resized;
        }
        if (graphic instanceof GraphicStyle2D) {
            AffineTransform at;
            GraphicStyle2D gstyle = (GraphicStyle2D)graphic;
            GraphicStyle2D resized = (GraphicStyle2D)graphic.clone();
            BufferedImage image = gstyle.getImage();
            if (mode == LabelCacheItem.GraphicResize.PROPORTIONAL) {
                double factor = width > height ? width / (double)image.getWidth() : height / (double)image.getHeight();
                at = AffineTransform.getScaleInstance(factor, factor);
            } else {
                at = AffineTransform.getScaleInstance(width / (double)image.getWidth(), height / (double)image.getHeight());
            }
            AffineTransformOp ato = new AffineTransformOp(at, 2);
            image = ato.filter(image, null);
            resized.setImage(image);
            return resized;
        }
        return graphic;
    }

    private void drawGlyphVector(LineInfo.LineComponent component) {
        LineMetrics metrics = this.computeLineMetricsIfNeeded(component);
        GlyphVector gv = component.getGlyphVector();
        Shape outline = gv.getOutline();
        if (this.labelItem.getTextStyle().getHaloFill() != null) {
            this.configureHalo();
            this.graphics.draw(outline);
            this.drawStraightLabelUnderlineIfNeeded(outline, metrics, true);
            this.drawStraightLabelStrikethroughIfNeeded(outline, metrics, true);
        }
        this.configureLabelStyle();
        this.drawStraightLabelUnderlineIfNeeded(outline, metrics, false);
        this.drawStraightLabelStrikethroughIfNeeded(outline, metrics, false);
        if (this.labelRenderingMode == LabelCacheImpl.LabelRenderingMode.STRING) {
            this.graphics.drawGlyphVector(gv, 0.0f, 0.0f);
        } else if (this.labelRenderingMode == LabelCacheImpl.LabelRenderingMode.OUTLINE) {
            this.graphics.fill(outline);
        } else {
            AffineTransform tx = this.graphics.getTransform();
            if (Math.abs(tx.getShearX()) >= 1.0E-6 || Math.abs(tx.getShearY()) > 1.0E-6) {
                this.graphics.fill(outline);
            } else {
                this.graphics.drawGlyphVector(gv, 0.0f, 0.0f);
            }
        }
    }

    private LineMetrics computeLineMetricsIfNeeded(LineInfo.LineComponent component) {
        if (this.labelItem.isTextUnderlined() || this.labelItem.isTextStrikethrough()) {
            return component.computeLineMetrics(this.graphics.getFontRenderContext());
        }
        return null;
    }

    private void drawStraightLabelUnderlineIfNeeded(Shape outline, LineMetrics metrics, boolean drawingHalo) {
        if (!this.labelItem.isTextUnderlined()) {
            return;
        }
        float thickness = metrics.getUnderlineThickness();
        float offset = metrics.getUnderlineOffset() * 2.0f;
        this.drawStraightLabelLine(outline, drawingHalo, thickness, offset);
    }

    private void drawStraightLabelStrikethroughIfNeeded(Shape outline, LineMetrics metrics, boolean drawingHalo) {
        if (!this.labelItem.isTextStrikethrough()) {
            return;
        }
        float thickness = metrics.getStrikethroughThickness();
        float offset = metrics.getStrikethroughOffset();
        this.drawStraightLabelLine(outline, drawingHalo, thickness, offset);
    }

    private void drawStraightLabelLine(Shape outline, boolean drawingHalo, float thickness, float offset) {
        Rectangle bounds = outline.getBounds2D().getBounds();
        double minX = bounds.getMinX();
        double maxX = bounds.getMaxX();
        if (Math.abs(maxX - minX) < 1.0E-7) {
            return;
        }
        if (drawingHalo) {
            this.graphics.draw(new Line2D.Double(minX, offset, maxX, offset));
        } else {
            Stroke currentStroke = this.graphics.getStroke();
            this.graphics.setStroke(new BasicStroke(thickness));
            this.graphics.draw(new Line2D.Double(minX, offset, maxX, offset));
            this.graphics.setStroke(currentStroke);
        }
    }

    private void configureHalo() {
        this.graphics.setPaint(this.labelItem.getTextStyle().getHaloFill());
        this.graphics.setComposite(this.labelItem.getTextStyle().getHaloComposite());
        float haloRadius = this.labelItem.getTextStyle().getHaloFill() != null ? this.labelItem.getTextStyle().getHaloRadius() : 0.0f;
        this.graphics.setStroke(new BasicStroke(2.0f * haloRadius, 1, 1));
    }

    private void configureLabelStyle() {
        Paint fill = this.labelItem.getTextStyle().getFill();
        Composite comp = this.labelItem.getTextStyle().getComposite();
        if (fill == null) {
            fill = Color.BLACK;
            comp = AlphaComposite.getInstance(3, 1.0f);
        }
        this.graphics.setPaint(fill);
        this.graphics.setComposite(comp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintCurvedLabel(LineStringCursor cursor) {
        if (this.labelItem.getTextStyle().getFont().getSize() == 0) {
            return;
        }
        AffineTransform oldTransform = this.graphics.getTransform();
        LineInfo line = this.lines.get(0);
        if (!this.isLabelUpwards(cursor) && this.labelItem.isForceLeftToRightEnabled()) {
            LineStringCursor reverse = cursor.reverse();
            reverse.moveTo(cursor.getLineStringLength() - cursor.getCurrentOrdinate());
            cursor = reverse;
        }
        double anchorY = this.getLinePlacementYAnchor();
        double mid = cursor.getCurrentOrdinate();
        Coordinate c = new Coordinate();
        c = cursor.getCurrentPosition(c);
        this.graphics.setPaint(Color.BLACK);
        double startOrdinate = mid - (double)(this.getStraightLabelWidth() / 2);
        if (startOrdinate < 0.0) {
            startOrdinate = 0.0;
        }
        cursor.moveTo(startOrdinate);
        ArrayList<Shape[]> allOutlines = new ArrayList<Shape[]>();
        ArrayList<AffineTransform[]> allTransforms = new ArrayList<AffineTransform[]>();
        try {
            for (LineInfo.LineComponent component : line.getComponents()) {
                GlyphVector glyphVector = component.getGlyphVector();
                int numGlyphs = glyphVector.getNumGlyphs();
                float nextAdvance = glyphVector.getGlyphMetrics(0).getAdvance() * 0.5f;
                double start = cursor.getCurrentOrdinate();
                Shape[] outlines = new Shape[numGlyphs];
                AffineTransform[] transforms = new AffineTransform[numGlyphs];
                Font font = component.getGlyphVector().getFont();
                Number tracking = (Number)font.getAttributes().get(TextAttribute.TRACKING);
                for (int i = 0; i < numGlyphs; ++i) {
                    outlines[i] = glyphVector.getGlyphOutline(i);
                    Point2D p = glyphVector.getGlyphPosition(i);
                    float advance = nextAdvance;
                    if (tracking != null) {
                        advance += font.getSize2D() * tracking.floatValue();
                    }
                    nextAdvance = i < numGlyphs - 1 ? glyphVector.getGlyphMetrics(i + 1).getAdvance() * 0.5f : 0.0f;
                    c = cursor.getCurrentPosition(c);
                    AffineTransform t = new AffineTransform(this.graphics.getTransform());
                    t.translate(c.x, c.y);
                    t.rotate(cursor.getCurrentAngle());
                    t.translate(-p.getX() - (double)advance, -p.getY() + this.getLineHeight() * anchorY);
                    transforms[i] = t;
                    cursor.moveTo(cursor.getCurrentOrdinate() + (double)advance + (double)nextAdvance);
                }
                allOutlines.add(outlines);
                allTransforms.add(transforms);
                cursor.moveTo(start + glyphVector.getGlyphPosition(numGlyphs).getX());
            }
            LineInfo.LineComponent component = line.getComponents().get(0);
            LineMetrics metrics = this.computeLineMetricsIfNeeded(component);
            if (this.labelItem.getTextStyle().getHaloFill() != null) {
                this.configureHalo();
                if (this.labelItem.isTextUnderlined()) {
                    this.drawCurvedUnderline(line, cursor, startOrdinate, true, metrics);
                }
                if (this.labelItem.isTextStrikethrough()) {
                    this.drawCurvedStrikethrough(line, cursor, startOrdinate, true, metrics);
                }
                this.drawOrFillOutlines(allOutlines, allTransforms, false);
            }
            this.graphics.setTransform(oldTransform);
            this.configureLabelStyle();
            if (this.labelItem.isTextUnderlined()) {
                this.drawCurvedUnderline(line, cursor, startOrdinate, false, metrics);
            }
            if (this.labelItem.isTextStrikethrough()) {
                this.drawCurvedStrikethrough(line, cursor, startOrdinate, false, metrics);
            }
            this.drawOrFillOutlines(allOutlines, allTransforms, true);
        }
        finally {
            this.graphics.setTransform(oldTransform);
        }
    }

    private void drawCurvedUnderline(LineInfo line, LineStringCursor cursor, double startOrdinate, boolean drawingHalo, LineMetrics metrics) {
        float lineOffset = metrics.getUnderlineOffset() * 2.0f;
        float lineThickness = metrics.getUnderlineThickness();
        this.drawCurvedLine(line, cursor, startOrdinate, drawingHalo, lineOffset, lineThickness);
    }

    private void drawCurvedStrikethrough(LineInfo line, LineStringCursor cursor, double startOrdinate, boolean drawingHalo, LineMetrics metrics) {
        float lineOffset = metrics.getStrikethroughOffset();
        float lineThickness = metrics.getStrikethroughThickness();
        this.drawCurvedLine(line, cursor, startOrdinate, drawingHalo, lineOffset, lineThickness);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawCurvedLine(LineInfo line, LineStringCursor cursor, double startOrdinate, boolean drawingHalo, float lineOffset, float lineThickness) {
        double endOrdinate = cursor.getCurrentOrdinate();
        GlyphVector glyphVector = line.getComponents().get(0).getGlyphVector();
        double advance = glyphVector.getGlyphMetrics(0).getAdvance() * 0.5f;
        LineString labelLineString = cursor.getSubLineString(startOrdinate - advance, endOrdinate - advance);
        LiteShape underlineLineString = this.computeCurvedLine(labelLineString, lineOffset);
        if (drawingHalo) {
            this.graphics.draw(underlineLineString);
        } else {
            Stroke oldStroke = this.graphics.getStroke();
            try {
                this.graphics.setStroke(new BasicStroke(lineThickness));
                this.graphics.draw(underlineLineString);
            }
            finally {
                this.graphics.setStroke(oldStroke);
            }
        }
    }

    private void drawOrFillOutlines(List<Shape[]> allOutlines, List<AffineTransform[]> allTransforms, boolean fill) {
        for (int i = 0; i < allOutlines.size(); ++i) {
            Shape[] outlines = allOutlines.get(i);
            AffineTransform[] transforms = allTransforms.get(i);
            int numGlyphs = outlines.length;
            for (int j = 0; j < numGlyphs; ++j) {
                this.graphics.setTransform(transforms[j]);
                if (fill) {
                    this.graphics.fill(outlines[j]);
                    continue;
                }
                this.graphics.draw(outlines[j]);
            }
        }
    }

    private LiteShape computeCurvedLine(LineString labelLineString, float lineOffset) {
        Coordinate[] coordinates = labelLineString.getCoordinates();
        Coordinate[] parallelCoordinates = new Coordinate[coordinates.length];
        double anchorOffset = this.getLinePlacementYAnchor() * this.getLineHeight();
        for (int i = 0; i < coordinates.length - 1; ++i) {
            Coordinate coordinateA = coordinates[i];
            Coordinate coordinateB = coordinates[i + 1];
            double dx = coordinateB.x - coordinateA.x;
            double dy = coordinateB.y - coordinateA.y;
            double length = Math.sqrt(Math.pow(dx, 2.0) + Math.pow(dy, 2.0));
            double offset = -(anchorOffset + (double)lineOffset);
            double x1 = coordinateA.x + offset * (coordinateB.y - coordinateA.y) / length;
            double x2 = coordinateB.x + offset * (coordinateB.y - coordinateA.y) / length;
            double y1 = coordinateA.y + offset * (coordinateA.x - coordinateB.x) / length;
            double y2 = coordinateB.y + offset * (coordinateA.x - coordinateB.x) / length;
            parallelCoordinates[i] = new Coordinate(x1, y1);
            parallelCoordinates[i + 1] = new Coordinate(x2, y2);
        }
        LineString lineString = labelLineString.getFactory().createLineString(parallelCoordinates);
        return new LiteShape((Geometry)lineString, null, true);
    }

    public double getLinePlacementYAnchor() {
        LabelCacheItem item = this.getLabel();
        TextStyle2D textStyle = item.getTextStyle();
        LineMetrics lm = textStyle.getFont().getLineMetrics(item.getLabel(), this.graphics.getFontRenderContext());
        if (lm.getHeight() > 0.0f) {
            return (Math.abs(lm.getStrikethroughOffset()) + lm.getDescent() + lm.getLeading()) / lm.getHeight();
        }
        return 0.0;
    }

    boolean isLabelUpwards(LineStringCursor cursor) {
        double labelAngle = cursor.getCurrentAngle() + 1.5707963267948966;
        return (labelAngle %= Math.PI * 2) >= 0.0 && labelAngle < Math.PI;
    }
}

