/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.style.ColorMapEntry;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.geotools.renderer.style.ExpressionExtractor;
import org.geotools.styling.visitor.DuplicatingStyleVisitor;

class ColorMapEntryResolver
extends DuplicatingStyleVisitor {
    SimplifyingFilterVisitor simplifier = new SimplifyingFilterVisitor();

    ColorMapEntryResolver() {
    }

    protected Expression copyCqlExpression(Expression expression) {
        String value;
        if (expression == null) {
            return null;
        }
        if (expression instanceof Literal && (value = (String)expression.evaluate(null, String.class)) != null && value.startsWith("${")) {
            expression = ExpressionExtractor.extractCqlExpressions(value);
        }
        Expression simplified = (Expression)expression.accept((ExpressionVisitor)this.simplifier, (Object)this.ff);
        return simplified;
    }

    @Override
    public void visit(ColorMapEntry colorMapEntry) {
        ColorMapEntry copy = this.sf.createColorMapEntry();
        copy.setColor(this.copyCqlExpression(colorMapEntry.getColor()));
        copy.setLabel(colorMapEntry.getLabel());
        copy.setOpacity(this.copyCqlExpression(colorMapEntry.getOpacity()));
        copy.setQuantity(this.copyCqlExpression(colorMapEntry.getQuantity()));
        if (this.STRICT && !copy.equals(colorMapEntry)) {
            throw new IllegalStateException("Was unable to duplicate provided ColorMapEntry:" + String.valueOf(colorMapEntry));
        }
        this.pages.push(copy);
    }
}

