/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.commons.lang3.tuple.Pair;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.filter.And;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.Not;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.PropertyIsBetween;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.PropertyIsGreaterThan;
import org.geotools.api.filter.PropertyIsGreaterThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLessThan;
import org.geotools.api.filter.PropertyIsLessThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.PropertyIsNil;
import org.geotools.api.filter.PropertyIsNotEqualTo;
import org.geotools.api.filter.PropertyIsNull;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.Beyond;
import org.geotools.api.filter.spatial.Contains;
import org.geotools.api.filter.spatial.Crosses;
import org.geotools.api.filter.spatial.DWithin;
import org.geotools.api.filter.spatial.Disjoint;
import org.geotools.api.filter.spatial.Equals;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.filter.spatial.Overlaps;
import org.geotools.api.filter.spatial.Touches;
import org.geotools.api.filter.spatial.Within;
import org.geotools.filter.function.InFunction;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.geotools.renderer.lite.FilterMemoizer;
import org.geotools.util.Converters;
import org.xml.sax.helpers.NamespaceSupport;

class MemoryFilterOptimizer
extends DuplicatingFilterVisitor {
    static final Object NULL_PLACEHOLDER = new Object();
    private final Set<Object> memoizeCandidates;
    Map<Expression, Expression> expressionReplacements = new HashMap<Expression, Expression>();
    Map<Filter, Filter> filterReplacements = new HashMap<Filter, Filter>();
    SimpleFeatureType simpleFeatureType;

    public MemoryFilterOptimizer(FeatureType schema, Set<Object> memoizeCandidates) {
        if (schema instanceof SimpleFeatureType) {
            SimpleFeatureType type;
            this.simpleFeatureType = type = (SimpleFeatureType)schema;
        }
        this.memoizeCandidates = memoizeCandidates;
    }

    @Override
    public Object visit(PropertyIsEqualTo filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit((PropertyIsEqualTo)x$0, x$1));
    }

    @Override
    public Object visit(PropertyIsNotEqualTo filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit((PropertyIsNotEqualTo)x$0, x$1));
    }

    @Override
    public Object visit(And filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit((And)x$0, x$1));
    }

    @Override
    public Object visit(Id filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit((Id)x$0, x$1));
    }

    @Override
    public Object visit(Not filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit((Not)x$0, x$1));
    }

    @Override
    public Object visit(Or filter, Object extraData) {
        return this.memoize(filter, extraData, this::inFilterOptimizer);
    }

    private Object inFilterOptimizer(Or filter, Object extraData) {
        InFunction inFilter = this.replaceWithInFilter(filter);
        if (inFilter == null) {
            return super.visit(filter, extraData);
        }
        return this.ff.equals((Expression)inFilter, (Expression)this.ff.literal(true));
    }

    private InFunction replaceWithInFilter(Or filter) {
        List children = filter.getChildren();
        Expression expression = null;
        ArrayList<Literal> literals = new ArrayList<Literal>(children.size());
        for (Filter childFilter : children) {
            if (!(childFilter instanceof PropertyIsEqualTo)) {
                return null;
            }
            PropertyIsEqualTo eqto = (PropertyIsEqualTo)childFilter;
            Pair<Expression, Literal> equalsParameters = this.getEqualsParameters(eqto);
            if (equalsParameters == null) {
                return null;
            }
            if (expression == null) {
                expression = (Expression)equalsParameters.getLeft();
            } else if (!Objects.equals(expression, equalsParameters.getLeft())) {
                return null;
            }
            literals.add((Literal)equalsParameters.getRight());
        }
        ArrayList<Expression> inParameters = new ArrayList<Expression>(literals.size() + 1);
        inParameters.add(expression);
        inParameters.addAll(literals);
        InFunction inFunction = new InFunction();
        inFunction.setParameters(inParameters);
        return inFunction;
    }

    private Pair<Expression, Literal> getEqualsParameters(PropertyIsEqualTo equals) {
        Literal literal = null;
        Expression expression = null;
        if (equals.getExpression1() instanceof Literal) {
            literal = (Literal)equals.getExpression1();
            expression = equals.getExpression2();
        } else if (equals.getExpression2() instanceof Literal) {
            literal = (Literal)equals.getExpression2();
            expression = equals.getExpression1();
        }
        if (expression != null && literal != null) {
            return Pair.of((Object)expression, (Object)literal);
        }
        return null;
    }

    @Override
    public Object visit(PropertyIsBetween filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit((PropertyIsBetween)x$0, x$1));
    }

    @Override
    public Object visit(PropertyIsGreaterThan filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit((PropertyIsGreaterThan)x$0, x$1));
    }

    @Override
    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit((PropertyIsGreaterThanOrEqualTo)x$0, x$1));
    }

    @Override
    public Object visit(PropertyIsLessThan filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit((PropertyIsLessThan)x$0, x$1));
    }

    @Override
    public Object visit(PropertyIsLessThanOrEqualTo filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit((PropertyIsLessThanOrEqualTo)x$0, x$1));
    }

    @Override
    public Object visit(PropertyIsLike filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit((PropertyIsLike)x$0, x$1));
    }

    @Override
    public Object visit(PropertyIsNull filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit((PropertyIsNull)x$0, x$1));
    }

    @Override
    public Object visit(PropertyIsNil filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit((PropertyIsNil)x$0, x$1));
    }

    @Override
    public Object visit(BBOX filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit((BBOX)x$0, x$1));
    }

    @Override
    public Object visit(Beyond filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit((Beyond)x$0, x$1));
    }

    @Override
    public Object visit(Contains filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit((Contains)x$0, x$1));
    }

    @Override
    public Object visit(Crosses filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit((Crosses)x$0, x$1));
    }

    @Override
    public Object visit(Disjoint filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit((Disjoint)x$0, x$1));
    }

    @Override
    public Object visit(DWithin filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit((DWithin)x$0, x$1));
    }

    @Override
    public Object visit(Equals filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit((Equals)x$0, x$1));
    }

    @Override
    public Object visit(Intersects filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit((Intersects)x$0, x$1));
    }

    @Override
    public Object visit(Overlaps filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit((Overlaps)x$0, x$1));
    }

    @Override
    public Object visit(Touches filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit((Touches)x$0, x$1));
    }

    @Override
    public Object visit(Within filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit((Within)x$0, x$1));
    }

    public <T extends Filter> T memoize(T filter, Object extraData, BiFunction<T, Object, Object> duplicator) {
        if (!this.memoizeCandidates.contains(filter)) {
            Filter result = (Filter)duplicator.apply(filter, extraData);
            return (T)result;
        }
        Filter replacement = this.filterReplacements.get(filter);
        if (replacement == null) {
            Filter duplicated = (Filter)duplicator.apply(filter, extraData);
            replacement = FilterMemoizer.memoize(duplicated);
            this.filterReplacements.put(filter, replacement);
        }
        return (T)replacement;
    }

    @Override
    public Object visit(PropertyName expression, Object extraData) {
        Object replacement = this.expressionReplacements.get(expression);
        if (replacement == null) {
            replacement = this.simpleFeatureType != null && this.simpleFeatureType.indexOf(expression.getPropertyName()) >= 0 ? new IndexPropertyName(this.simpleFeatureType, expression) : (this.memoizeCandidates.contains(expression) ? new MemoizedPropertyName(expression) : expression);
            this.expressionReplacements.put((Expression)expression, (Expression)replacement);
        }
        return replacement;
    }

    static class IndexPropertyName
    implements PropertyName {
        private final AttributeDescriptor descriptor;
        private SimpleFeatureType schema;
        PropertyName delegate;
        int index;

        public IndexPropertyName(SimpleFeatureType schema, PropertyName delegate) {
            this.delegate = delegate;
            this.schema = schema;
            this.index = schema.indexOf(delegate.getPropertyName());
            this.descriptor = schema.getDescriptor(this.index);
        }

        public String getPropertyName() {
            return this.delegate.getPropertyName();
        }

        public NamespaceSupport getNamespaceContext() {
            return this.delegate.getNamespaceContext();
        }

        public Object evaluate(Object object) {
            return this.evaluate(object, null);
        }

        public <T> T evaluate(Object object, Class<T> context) {
            SimpleFeature sf;
            SimpleFeatureType other;
            if (object instanceof SimpleFeature && ((other = (sf = (SimpleFeature)object).getFeatureType()) == this.schema || other.getDescriptor(this.index).equals(this.descriptor))) {
                if (other != this.schema) {
                    this.schema = other;
                }
                try {
                    Object value = sf.getAttribute(this.index);
                    if (context == null || context.isInstance(value)) {
                        Object result = value;
                        return (T)result;
                    }
                    return (T)Converters.convert((Object)value, context);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new RuntimeException("Could not locate attribute at index " + this.index + " on feature " + String.valueOf(object), e);
                }
            }
            return (T)this.delegate.evaluate(object, context);
        }

        public Object accept(ExpressionVisitor visitor, Object extraData) {
            return this.delegate.accept(visitor, extraData);
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    static class MemoizedPropertyName
    implements PropertyName {
        PropertyName delegate;
        Object lastFeature = NULL_PLACEHOLDER;
        Object lastResult;
        Class lastContext;

        public MemoizedPropertyName(PropertyName delegate) {
            this.delegate = delegate;
        }

        public String getPropertyName() {
            return this.delegate.getPropertyName();
        }

        public NamespaceSupport getNamespaceContext() {
            return this.delegate.getNamespaceContext();
        }

        public Object evaluate(Object object) {
            if (object != this.lastFeature || this.lastContext != null) {
                this.lastResult = this.delegate.evaluate(object);
                this.lastFeature = object;
                this.lastContext = null;
            }
            return this.lastResult;
        }

        public <T> T evaluate(Object object, Class<T> context) {
            if (object != this.lastFeature || !Objects.equals(this.lastContext, context)) {
                this.lastResult = this.delegate.evaluate(object, context);
                this.lastContext = context;
            }
            return (T)this.lastResult;
        }

        public Object accept(ExpressionVisitor visitor, Object extraData) {
            return this.delegate.accept(visitor, extraData);
        }
    }
}

