/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.Rule;
import org.geotools.api.style.StyleVisitor;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.geotools.styling.FeatureTypeStyleImpl;
import org.geotools.styling.visitor.DuplicatingStyleVisitor;

class SimplifyingStyleVisitor
extends DuplicatingStyleVisitor {
    SimplifyingStyleVisitor() {
        super(CommonFactoryFinder.getStyleFactory(null), CommonFactoryFinder.getFilterFactory(null), new SimplifyingFilterVisitor());
    }

    SimplifyingStyleVisitor(FeatureType schema) {
        super(CommonFactoryFinder.getStyleFactory(null), CommonFactoryFinder.getFilterFactory(null), SimplifyingStyleVisitor.getFilterSimplifier(schema));
    }

    private static SimplifyingFilterVisitor getFilterSimplifier(FeatureType schema) {
        SimplifyingFilterVisitor filterSimplifier = new SimplifyingFilterVisitor();
        filterSimplifier.setFeatureType(schema);
        return filterSimplifier;
    }

    @Override
    public void visit(FeatureTypeStyle fts) {
        FeatureTypeStyleImpl copy = new FeatureTypeStyleImpl(fts);
        List rulesCopy = fts.rules().stream().filter(Objects::nonNull).map(r -> {
            r.accept((StyleVisitor)this);
            return !this.pages.isEmpty() ? (Rule)this.pages.pop() : null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        copy.rules().clear();
        copy.rules().addAll(rulesCopy);
        if (fts.getTransformation() != null) {
            copy.setTransformation(fts.getTransformation());
        }
        if (fts.getOnlineResource() != null) {
            copy.setOnlineResource(fts.getOnlineResource());
        }
        copy.getOptions().clear();
        copy.getOptions().putAll(fts.getOptions());
        if (this.STRICT && !((Object)copy).equals(fts)) {
            throw new IllegalStateException("Was unable to duplicate provided FeatureTypeStyle:" + String.valueOf(fts));
        }
        this.pages.push(copy);
    }
}

