/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import java.awt.Color;
import java.text.MessageFormat;
import org.eclipse.imagen.media.classifier.ConstantColorMapElement;
import org.eclipse.imagen.media.classifier.LinearColorMapElement;
import org.eclipse.imagen.media.piecewise.DefaultPiecewiseTransform1DElement;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.geometry.Position;
import org.geotools.renderer.i18n.ErrorKeys;

class ColorMapUtilities {
    static final int[] DEFAULT_ARGB = new int[]{-16777216, -1};

    ColorMapUtilities() {
    }

    static void ensureNonNull(String name, Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException(MessageFormat.format(ErrorKeys.NULL_ARGUMENT_$1, name));
        }
    }

    static int compare(double v1, double v2) {
        if (Double.isNaN(v1) && Double.isNaN(v2)) {
            long bits2;
            long bits1 = Double.doubleToRawLongBits(v1);
            if (bits1 < (bits2 = Double.doubleToRawLongBits(v2))) {
                return -1;
            }
            if (bits1 > bits2) {
                return 1;
            }
        }
        return Double.compare(v1, v2);
    }

    static void checkDimension(Position point) {
        int dim = point.getDimension();
        if (dim != 1) {
            throw new MismatchedDimensionException(MessageFormat.format(ErrorKeys.MISMATCHED_DIMENSION_$2, 1, dim));
        }
    }

    static DefaultPiecewiseTransform1DElement[] checkPreservingElements(LinearColorMapElement[] preservingElements) {
        if (preservingElements != null) {
            double outval = Double.NaN;
            Color color = null;
            for (int i = 0; i < preservingElements.length; ++i) {
                if (!(preservingElements[i] instanceof ConstantColorMapElement)) {
                    throw new IllegalArgumentException(MessageFormat.format(ErrorKeys.ILLEGAL_ARGUMENT_$1, preservingElements));
                }
                ConstantColorMapElement nc = (ConstantColorMapElement)preservingElements[i];
                if (nc.getColors().length != 1) {
                    Color[] arg0 = nc.getColors();
                    throw new IllegalArgumentException(MessageFormat.format(ErrorKeys.ILLEGAL_ARGUMENT_$1, new Object[]{arg0}));
                }
                if (i == 0) {
                    outval = nc.getOutputMaximum();
                    color = nc.getColors()[0];
                    continue;
                }
                if (ColorMapUtilities.compare(outval, nc.getOutputMaximum()) != 0) {
                    Color[] arg0 = nc.getColors();
                    throw new IllegalArgumentException(MessageFormat.format(ErrorKeys.ILLEGAL_ARGUMENT_$1, new Object[]{arg0}));
                }
                if (color.equals(nc.getColors()[0])) continue;
                Color[] arg0 = nc.getColors();
                throw new IllegalArgumentException(MessageFormat.format(ErrorKeys.ILLEGAL_ARGUMENT_$1, new Object[]{arg0}));
            }
        }
        return preservingElements;
    }
}

