/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.imagen.ROI;
import org.eclipse.imagen.media.range.Range;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.style.ChannelSelection;
import org.geotools.api.style.ColorMap;
import org.geotools.api.style.ContrastEnhancement;
import org.geotools.api.style.RasterSymbolizer;
import org.geotools.api.style.ShadedRelief;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.util.InternationalString;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.TypeMap;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.image.ImageWorker;
import org.geotools.renderer.i18n.Vocabulary;
import org.geotools.renderer.lite.gridcoverage2d.ChannelSelectionNode;
import org.geotools.renderer.lite.gridcoverage2d.ColorMapNode;
import org.geotools.renderer.lite.gridcoverage2d.ColorMapUtilities;
import org.geotools.renderer.lite.gridcoverage2d.ContrastEnhancementNode;
import org.geotools.renderer.lite.gridcoverage2d.CoverageProcessingNode;
import org.geotools.renderer.lite.gridcoverage2d.RootNode;
import org.geotools.renderer.lite.gridcoverage2d.ShadedReliefNode;
import org.geotools.renderer.lite.gridcoverage2d.StyleVisitorCoverageProcessingNodeAdapter;
import org.geotools.renderer.lite.gridcoverage2d.SubchainStyleVisitorCoverageProcessingAdapter;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.factory.Hints;

public class RasterSymbolizerHelper
extends SubchainStyleVisitorCoverageProcessingAdapter
implements StyleVisitor {
    private float opacity = 1.0f;

    public GridCoverage2D execute() {
        GridSampleDimension[] sd;
        GridCoverage2D output = (GridCoverage2D)super.execute();
        RenderedImage outputImage = output.getRenderedImage();
        Range nodata = CoverageUtilities.getNoDataProperty((GridCoverage2D)output) != null ? CoverageUtilities.getNoDataProperty((GridCoverage2D)output).getAsRange() : null;
        ROI roiProp = CoverageUtilities.getROIProperty((GridCoverage2D)output);
        SampleModel outputImageSampleModel = outputImage.getSampleModel();
        int numBands = outputImageSampleModel.getNumBands();
        int dataType = outputImageSampleModel.getDataType();
        if (numBands > 4) {
            int visibleBand = CoverageUtilities.getVisibleBand((Object)outputImage);
            outputImage = new ImageWorker(outputImage).setRenderingHints((RenderingHints)this.getHints()).retainBands(new int[]{visibleBand}).getRenderedImage();
            sd = new GridSampleDimension[]{output.getSampleDimension(visibleBand)};
        } else {
            sd = output.getSampleDimensions();
        }
        switch (dataType) {
            case 1: {
                if (outputImage.getColorModel() instanceof IndexColorModel) break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                ImageWorker w = new ImageWorker(outputImage);
                outputImage = w.setROI(roiProp).setNoData(nodata).setRenderingHints((RenderingHints)this.getHints()).rescaleToBytes().getRenderedImage();
                roiProp = w.getROI();
                nodata = w.getNoData();
            }
        }
        HashMap properties = output.getProperties();
        if (properties == null) {
            properties = new HashMap();
        }
        CoverageUtilities.setNoDataProperty((Map)properties, (Object)nodata);
        CoverageUtilities.setROIProperty(properties, (ROI)roiProp);
        if (this.opacity < 1.0f) {
            ImageWorker ow = new ImageWorker(outputImage);
            ow.setROI(roiProp);
            ow.setNoData(nodata);
            RenderedImage finalImage = ow.applyOpacity(this.opacity).getRenderedImage();
            numBands = finalImage.getSampleModel().getNumBands();
            sd = new GridSampleDimension[numBands];
            for (int i = 0; i < numBands; ++i) {
                sd[i] = new GridSampleDimension((CharSequence)TypeMap.getColorInterpretation((ColorModel)finalImage.getColorModel(), (int)i).name());
            }
            CoverageUtilities.setNoDataProperty(properties, (Object)ow.getNoData());
            CoverageUtilities.setROIProperty(properties, (ROI)ow.getROI());
            return this.getCoverageFactory().create((CharSequence)output.getName(), finalImage, output.getGridGeometry(), sd, new GridCoverage[]{output}, properties);
        }
        return this.getCoverageFactory().create((CharSequence)output.getName(), outputImage, output.getGridGeometry(), sd, new GridCoverage[]{output}, properties);
    }

    public RasterSymbolizerHelper(GridCoverage2D sourceCoverage, Hints hints) {
        super(1, hints, (InternationalString)SimpleInternationalString.wrap((CharSequence)Vocabulary.format(8)), (InternationalString)SimpleInternationalString.wrap((CharSequence)"Simple Coverage Processing Node for RasterSymbolizerHelper"));
        this.addSource(new RootNode(sourceCoverage, hints));
    }

    @Override
    public void visit(RasterSymbolizer rs) {
        Number number;
        boolean applyContrastEnhancement;
        ColorMapUtilities.ensureNonNull("RasterSymbolizer", rs);
        CoverageProcessingNode prevNode = this.getSource(0);
        ChannelSelectionNode csNode = new ChannelSelectionNode();
        StyleVisitorCoverageProcessingNodeAdapter currNode = csNode;
        currNode.addSource(prevNode);
        prevNode = currNode;
        ChannelSelection cs = rs.getChannelSelection();
        csNode.visit(cs);
        ColorMapNode cmNode = new ColorMapNode(this.getHints());
        currNode = cmNode;
        currNode.addSource(prevNode);
        prevNode.addSink(currNode);
        prevNode = currNode;
        ColorMap cm = rs.getColorMap();
        cmNode.visit(cm);
        ContrastEnhancementNode ceNode = new ContrastEnhancementNode(this.getHints());
        currNode = ceNode;
        currNode.addSource(prevNode);
        prevNode.addSink(currNode);
        prevNode = currNode;
        ContrastEnhancement ce = rs.getContrastEnhancement();
        ceNode.visit(ce);
        ShadedReliefNode srNode = new ShadedReliefNode(this.getHints());
        ShadedRelief sr = rs.getShadedRelief();
        srNode.visit(sr);
        currNode = srNode;
        boolean applyShadedRelief = !Double.isNaN(srNode.getReliefFactor());
        boolean bl = applyContrastEnhancement = ceNode.getType() != null;
        if (applyShadedRelief && applyContrastEnhancement) {
            throw new IllegalArgumentException("ContrastEnhancement and ShadedRelief can't be applied at the same time. ");
        }
        if (applyShadedRelief) {
            currNode.addSource(cmNode);
            prevNode.addSink(currNode);
            this.setSink(currNode);
        } else {
            this.setSink(prevNode);
        }
        Expression op = rs.getOpacity();
        if (op != null && (number = (Number)op.evaluate(null, Float.class)) != null) {
            this.opacity = number.floatValue();
        }
    }
}

