/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import java.awt.Color;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import org.eclipse.imagen.media.classifier.LinearColorMap;
import org.eclipse.imagen.media.classifier.LinearColorMapElement;
import org.eclipse.imagen.media.piecewise.PiecewiseUtilities;
import org.eclipse.imagen.media.range.Range;
import org.eclipse.imagen.media.range.RangeDouble;
import org.eclipse.imagen.media.range.RangeFactory;
import org.eclipse.imagen.media.range.RangeInt;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.style.ColorMapEntry;
import org.geotools.metadata.i18n.Vocabulary;
import org.geotools.renderer.i18n.ErrorKeys;
import org.geotools.renderer.lite.gridcoverage2d.ColorMapUtilities;
import org.geotools.renderer.style.ExpressionExtractor;
import org.geotools.util.SuppressFBWarnings;

public class SLDColorMapBuilder {
    public static final Color defaultColorForValuesToPreserve = new Color(0, 0, 0, 0);
    public static final Color defaultGapsColor = new Color(0, 0, 0, 0);
    private final List<LinearColorMapElement> colormapElements = new ArrayList<LinearColorMapElement>();
    private int linearColorMapType = -1;
    private Color gapsColor;
    private Color preservedValuesColor;
    private final List<Double> preservedValues = new ArrayList<Double>();
    private int colorsPerColorMapElement;
    private Color lastColorValue;
    private String name;
    private boolean extendedColors = false;
    private int numberColorMapEntries = -1;
    private int numberOfColorMapElements = -1;
    private LinearColorMap colorMap;

    public SLDColorMapBuilder() {
        this.name = "sld-colormap";
    }

    public SLDColorMapBuilder(String name) {
        ColorMapUtilities.ensureNonNull("name", name);
        this.name = name;
    }

    public void setGapsColor(Color defaultColor) {
        this.checkIfColorMapCreated();
        this.gapsColor = defaultColor;
    }

    private void checkIfColorMapCreated() throws IllegalStateException {
        if (this.colorMap != null) {
            throw new IllegalStateException(ErrorKeys.ILLEGAL_STATE);
        }
    }

    public SLDColorMapBuilder setLinearColorMapType(int colorMapType) {
        this.checkIfColorMapCreated();
        if (LinearColorMap.LinearColorMapType.validateColorMapTye((int)this.linearColorMapType)) {
            throw new IllegalStateException(ErrorKeys.ILLEGAL_STATE);
        }
        if (!LinearColorMap.LinearColorMapType.validateColorMapTye((int)colorMapType)) {
            throw new IllegalArgumentException(MessageFormat.format(ErrorKeys.ILLEGAL_ARGUMENT_$2, "colorMapType", Integer.toString(colorMapType)));
        }
        this.linearColorMapType = colorMapType;
        return this;
    }

    public int getLinearColorMapType() {
        return this.linearColorMapType;
    }

    public SLDColorMapBuilder addColorMapEntry(ColorMapEntry colorMapEntry) {
        ColorMapUtilities.ensureNonNull("colorMapEntry", colorMapEntry);
        this.checkIfColorMapCreated();
        ColorMapUtilities.ensureNonNull("colorMapEntry", colorMapEntry);
        if (this.numberColorMapEntries == -1 || this.linearColorMapType == -1 || this.numberColorMapEntries < this.colormapElements.size() + 1) {
            throw new IllegalStateException(ErrorKeys.ILLEGAL_STATE);
        }
        this.init();
        String label = colorMapEntry.getLabel();
        label = label == null ? "ColorMapEntry" + this.colormapElements.size() : label;
        double q = SLDColorMapBuilder.getQuantity(colorMapEntry);
        Color newColorValue = SLDColorMapBuilder.getColor(colorMapEntry);
        ColorMapUtilities.ensureNonNull("newColorValue", newColorValue);
        double opacityValue = SLDColorMapBuilder.getOpacity(colorMapEntry);
        newColorValue = new Color(newColorValue.getRed(), newColorValue.getGreen(), newColorValue.getBlue(), (int)(opacityValue * 255.0 + 0.5));
        boolean firstEntry = this.colormapElements.isEmpty();
        if (firstEntry) {
            switch (this.linearColorMapType) {
                case 1: {
                    this.colormapElements.add(LinearColorMapElement.create((CharSequence)label, (Color)newColorValue, (Range)RangeFactory.create((double)Double.NEGATIVE_INFINITY, (boolean)false, (double)q, (boolean)false), (int)0));
                    break;
                }
                case 3: {
                    this.colormapElements.add(LinearColorMapElement.create((CharSequence)label, (Color)newColorValue, (double)q, (int)0));
                    break;
                }
                case 2: {
                    this.colormapElements.add(LinearColorMapElement.create((CharSequence)label, (Color)newColorValue, (Range)RangeFactory.create((double)Double.NEGATIVE_INFINITY, (boolean)false, (double)q, (boolean)false), (int)0));
                    break;
                }
                default: {
                    String arg1 = Double.toString(opacityValue);
                    throw new IllegalArgumentException(MessageFormat.format(ErrorKeys.ILLEGAL_ARGUMENT_$2, "ColorMapTransform.type", arg1, this.linearColorMapType));
                }
            }
        } else {
            int newColorMapElementIndex = this.colormapElements.size();
            LinearColorMapElement previous = this.colormapElements.get(newColorMapElementIndex - 1);
            double previousMax = previous.getRange().getMax().doubleValue();
            Color[] previousColors = previous.getColors();
            if (PiecewiseUtilities.compare((double)previousMax, (double)q) != 0) {
                RangeDouble valueRange = RangeFactory.create((double)previousMax, (boolean)true, (double)q, (boolean)false);
                switch (this.linearColorMapType) {
                    case 1: {
                        Color[] colors = new Color[]{this.lastColorValue, newColorValue};
                        int previousMaximum = previous.getOutputRange().getMax().intValue();
                        boolean minIncluded = previousColors[previousColors.length - 1].equals(colors[0]);
                        RangeInt sampleRange = RangeFactory.create((int)previousMaximum, (boolean)minIncluded, (int)(this.colorsPerColorMapElement + previousMaximum), (boolean)false);
                        this.colormapElements.add(LinearColorMapElement.create((CharSequence)label, (Color[])colors, (Range)valueRange, (Range)sampleRange));
                        break;
                    }
                    case 3: {
                        this.colormapElements.add(LinearColorMapElement.create((CharSequence)label, (Color)newColorValue, (double)q, (int)newColorMapElementIndex));
                        break;
                    }
                    case 2: {
                        this.colormapElements.add(LinearColorMapElement.create((CharSequence)label, (Color)newColorValue, (Range)valueRange, (int)newColorMapElementIndex));
                        break;
                    }
                    default: {
                        String arg1 = Double.toString(opacityValue);
                        throw new IllegalArgumentException(MessageFormat.format(ErrorKeys.ILLEGAL_ARGUMENT_$2, "ColorMapTransform.type", arg1, this.linearColorMapType));
                    }
                }
            }
        }
        this.lastColorValue = newColorValue;
        return this;
    }

    private void init() {
        if (this.numberOfColorMapElements != -1) {
            return;
        }
        if (this.numberColorMapEntries == 1 && this.linearColorMapType != 3) {
            throw new IllegalArgumentException(MessageFormat.format(ErrorKeys.ILLEGAL_ARGUMENT_$2, "colormap entries", "1"));
        }
        this.numberOfColorMapElements = this.numberColorMapEntries;
        if (this.linearColorMapType == 1) {
            double colorsToDistribute;
            double d = colorsToDistribute = !this.extendedColors && this.numberColorMapEntries < 256 ? 256.0 : 65536.0;
            if (this.gapsColor != null) {
                colorsToDistribute -= 1.0;
            }
            if (this.preservedValuesColor != null) {
                colorsToDistribute -= 1.0;
            }
            this.colorsPerColorMapElement = (int)(colorsToDistribute / (double)(this.numberOfColorMapElements - 1));
            ++this.numberOfColorMapElements;
        } else {
            this.colorsPerColorMapElement = 1;
        }
    }

    public double[] getValuesToPreserve() {
        if (this.preservedValues.isEmpty()) {
            return new double[0];
        }
        double[] retVal = new double[this.preservedValues.size()];
        int i = 0;
        for (Double value : this.preservedValues) {
            retVal[i++] = value;
        }
        return retVal;
    }

    public SLDColorMapBuilder addValueToPreserve(double value) {
        this.checkIfColorMapCreated();
        assert (this.preservedValues != null);
        this.preservedValues.add(value);
        return this;
    }

    public SLDColorMapBuilder setColorForValuesToPreserve(Color color) {
        ColorMapUtilities.ensureNonNull("color", color);
        this.checkIfColorMapCreated();
        this.preservedValuesColor = color;
        return this;
    }

    public Color getColorForValuesToPreserve() {
        return this.preservedValuesColor;
    }

    @SuppressFBWarnings(value={"NP_NULL_PARAM_DEREF"})
    private static Color getColor(ColorMapEntry entry) throws NumberFormatException {
        ColorMapUtilities.ensureNonNull("ColorMapEntry", entry);
        Expression color = entry.getColor();
        ColorMapUtilities.ensureNonNull("color", color);
        String colorString = (String)color.evaluate(null, String.class);
        if (colorString != null && colorString.startsWith("${")) {
            color = ExpressionExtractor.extractCqlExpressions(colorString);
            colorString = (String)color.evaluate(null, String.class);
        }
        ColorMapUtilities.ensureNonNull("colorString", colorString);
        return Color.decode(colorString);
    }

    private static double getOpacity(ColorMapEntry entry) throws IllegalArgumentException, MissingResourceException {
        ColorMapUtilities.ensureNonNull("ColorMapEntry", entry);
        ColorMapUtilities.ensureNonNull("entry", entry);
        Expression opacity = entry.getOpacity();
        Double opacityValue = null;
        if (opacity == null) {
            return 1.0;
        }
        opacityValue = (Double)opacity.evaluate(null, Double.class);
        if (opacityValue == null && opacity instanceof Literal) {
            String opacityExp = (String)opacity.evaluate(null, String.class);
            opacity = ExpressionExtractor.extractCqlExpressions(opacityExp);
            opacityValue = (Double)opacity.evaluate(null, Double.class);
        }
        if (opacityValue == null) {
            throw new IllegalArgumentException("Opacity value null or could not be converted to a double" + String.valueOf(opacity));
        }
        if (opacityValue - 1.0 > 0.0 || opacityValue < 0.0) {
            throw new IllegalArgumentException(MessageFormat.format(ErrorKeys.ILLEGAL_ARGUMENT_$2, "Opacity", opacityValue));
        }
        return opacityValue;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH"})
    private static double getQuantity(ColorMapEntry entry) {
        ColorMapUtilities.ensureNonNull("ColorMapEntry", entry);
        Expression quantity = entry.getQuantity();
        ColorMapUtilities.ensureNonNull("quantity", quantity);
        Double quantityString = (Double)quantity.evaluate(null, Double.class);
        if (quantityString == null && quantity instanceof Literal) {
            String quantityExp = (String)quantity.evaluate(null, String.class);
            quantity = ExpressionExtractor.extractCqlExpressions(quantityExp);
            quantityString = (Double)quantity.evaluate(null, Double.class);
        }
        ColorMapUtilities.ensureNonNull("quantityString", quantityString);
        double q = quantityString;
        return q;
    }

    public boolean getExtendedColors() {
        return this.extendedColors;
    }

    public SLDColorMapBuilder setExtendedColors(boolean extendedColors) {
        if (this.numberColorMapEntries != -1) {
            throw new IllegalStateException(ErrorKeys.ILLEGAL_STATE);
        }
        this.checkIfColorMapCreated();
        this.extendedColors = extendedColors;
        return this;
    }

    public int getNumberColorMapEntries() {
        return this.numberColorMapEntries;
    }

    public SLDColorMapBuilder setNumberColorMapEntries(int numberColorMapEntries) {
        this.checkIfColorMapCreated();
        if (this.numberColorMapEntries != -1) {
            throw new IllegalStateException(ErrorKeys.ILLEGAL_STATE);
        }
        if (numberColorMapEntries <= 0 || numberColorMapEntries > (this.extendedColors ? 65536 : 256)) {
            throw new IllegalArgumentException(MessageFormat.format(ErrorKeys.ILLEGAL_ARGUMENT_$2, "numberColorMapEntries", Integer.toString(numberColorMapEntries)));
        }
        this.numberColorMapEntries = numberColorMapEntries;
        return this;
    }

    public int getNumberOfColorMapElements() {
        return this.numberOfColorMapElements;
    }

    public LinearColorMap buildLinearColorMap() {
        if (this.numberColorMapEntries == -1) {
            throw new IllegalStateException(ErrorKeys.ILLEGAL_STATE);
        }
        if (this.colorMap != null) {
            return this.colorMap;
        }
        LinearColorMapElement last = this.colormapElements.get(this.colormapElements.size() - 1);
        if (this.linearColorMapType == 1) {
            LinearColorMapElement previous = last;
            last = LinearColorMapElement.create((CharSequence)("ColorMapEntry" + this.colormapElements.size()), (Color)this.lastColorValue, (Range)RangeFactory.create((double)previous.getRange().getMax().doubleValue(), (boolean)true, (double)Double.POSITIVE_INFINITY, (boolean)false), (int)previous.getOutputRange().getMax().intValue());
            this.colormapElements.add(last);
        }
        LinearColorMapElement[] preservedValuesElement = new LinearColorMapElement[this.preservedValues.size()];
        int value = (int)last.getOutputMaximum() + 1;
        for (int i = 0; i < preservedValuesElement.length; ++i) {
            preservedValuesElement[i] = LinearColorMapElement.create((CharSequence)(Vocabulary.format((int)147) + Integer.toString(i + 1)), (Color)this.preservedValuesColor, (Range)RangeFactory.create((double)this.preservedValues.get(i), (double)this.preservedValues.get(i)), (int)value);
        }
        this.colorMap = new LinearColorMap((CharSequence)this.name, this.colormapElements.toArray(new LinearColorMapElement[this.colormapElements.size()]), preservedValuesElement, this.gapsColor);
        return this.colorMap;
    }
}

