/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.bandmerge;

import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import java.util.List;
import org.eclipse.imagen.ImageN;
import org.eclipse.imagen.OperationDescriptorImpl;
import org.eclipse.imagen.ParameterBlockImageN;
import org.eclipse.imagen.ROI;
import org.eclipse.imagen.RenderableOp;
import org.eclipse.imagen.RenderedOp;
import org.eclipse.imagen.media.range.Range;

public class BandMergeDescriptor
extends OperationDescriptorImpl {
    private static final String[][] resources = new String[][]{{"GlobalName", "BandMerge"}, {"LocalName", "BandMerge"}, {"Vendor", "org.eclipse.imagen.media"}, {"Description", "Operation used for merging multiple images into a single multibanded image"}, {"DocURL", "Not Defined"}, {"Version", "1.0"}, {"arg0Desc", "NoData values"}, {"arg1Desc", "Destination No Data value"}, {"arg2Desc", "Transformations List"}, {"arg3Desc", "ROI object to use"}, {"arg4Desc", "Boolean indicating if the last band is an alpha band"}};
    private static final String[] paramNames = new String[]{"noData", "destinationNoData", "transformations", "roi", "setAlpha"};
    private static final Class[] paramClasses = new Class[]{Range[].class, Double.class, List.class, ROI.class, Boolean.class};
    private static final Object[] paramDefaults = new Object[]{null, 0.0, null, null, false};

    public BandMergeDescriptor() {
        super(resources, paramClasses, paramNames, paramDefaults);
    }

    public boolean isRenderableSupported() {
        return true;
    }

    public static RenderedOp create(Range[] noData, double destinationNoData, boolean setAlpha, RenderingHints hints, RenderedImage ... sources) {
        return BandMergeDescriptor.create(noData, destinationNoData, setAlpha, hints, null, sources);
    }

    public static RenderedOp create(Range[] noData, double destinationNoData, boolean setAlpha, RenderingHints hints, List<AffineTransform> transform, RenderedImage ... sources) {
        return BandMergeDescriptor.create(noData, destinationNoData, setAlpha, hints, transform, null, sources);
    }

    public static RenderedOp create(Range[] noData, double destinationNoData, boolean setAlpha, RenderingHints hints, List<AffineTransform> transform, ROI roi, RenderedImage ... sources) {
        ParameterBlockImageN pb = new ParameterBlockImageN("BandMerge", "rendered");
        int numSources = sources.length;
        if (numSources <= 0) {
            throw new IllegalArgumentException("No resources are present");
        }
        for (int index = 0; index < numSources; ++index) {
            RenderedImage source = sources[index];
            if (source == null) {
                throw new IllegalArgumentException("This resource is null");
            }
            pb.setSource((Object)source, index);
        }
        if (transform != null && !transform.isEmpty() && transform.get(0) instanceof AffineTransform) {
            pb.setParameter("transformations", transform);
        }
        pb.setParameter("noData", (Object)noData);
        pb.setParameter("destinationNoData", destinationNoData);
        pb.setParameter("roi", (Object)roi);
        pb.setParameter("setAlpha", setAlpha);
        return ImageN.create((String)"BandMerge", (ParameterBlock)pb, (RenderingHints)hints);
    }

    public static RenderableOp createRenderable(Range[] noData, double destinationNoData, RenderingHints hints, RenderableImage ... sources) {
        return BandMergeDescriptor.createRenderable(noData, destinationNoData, hints, null, sources);
    }

    public static RenderableOp createRenderable(Range[] noData, double destinationNoData, RenderingHints hints, List<AffineTransform> transform, RenderableImage ... sources) {
        return BandMergeDescriptor.createRenderable(noData, destinationNoData, hints, transform, null, sources);
    }

    public static RenderableOp createRenderable(Range[] noData, double destinationNoData, RenderingHints hints, List<AffineTransform> transform, ROI roi, RenderableImage ... sources) {
        ParameterBlockImageN pb = new ParameterBlockImageN("BandMerge", "renderable");
        int numSources = sources.length;
        if (numSources <= 0) {
            throw new IllegalArgumentException("No resources are present");
        }
        for (int index = 0; index < numSources; ++index) {
            RenderableImage source = sources[index];
            if (source == null) {
                throw new IllegalArgumentException("This resource is null");
            }
            pb.setSource((Object)source, index);
        }
        if (transform != null && !transform.isEmpty() && transform.get(0) instanceof AffineTransform) {
            pb.setParameter("transformations", transform);
        }
        pb.setParameter("noData", (Object)noData);
        pb.setParameter("destinationNoData", destinationNoData);
        pb.setParameter("roi", (Object)roi);
        return ImageN.createRenderable((String)"BandMerge", (ParameterBlock)pb, (RenderingHints)hints);
    }
}

