/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.bandmerge;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.imagen.GeometricOpImage;
import org.eclipse.imagen.ImageLayout;
import org.eclipse.imagen.PixelAccessor;
import org.eclipse.imagen.PlanarImage;
import org.eclipse.imagen.ROI;
import org.eclipse.imagen.ROIShape;
import org.eclipse.imagen.RasterFactory;
import org.eclipse.imagen.UnpackedImageData;
import org.eclipse.imagen.iterator.RandomIter;
import org.eclipse.imagen.iterator.RandomIterFactory;
import org.eclipse.imagen.media.range.Range;
import org.eclipse.imagen.media.util.ImageUtil;
import org.eclipse.imagen.media.util.JDKWorkarounds;
import org.eclipse.imagen.media.utilities.ImageUtilities;

public class ExtendedBandMergeOpImage
extends GeometricOpImage {
    public static final int TILE_EXTENDER = 1;
    ColorModel[] colorModels;
    private final Range[] noData;
    private final boolean hasNoData;
    private final boolean hasROI;
    private byte destNoDataByte;
    private short destNoDataShort;
    private int destNoDataInt;
    private float destNoDataFloat;
    private double destNoDataDouble;
    private List<AffineTransform> transforms;
    private List<Transform> transformObj;
    protected boolean caseA;
    protected boolean caseB;
    protected boolean caseC;
    private ROI roi;

    public ExtendedBandMergeOpImage(List sources, List<AffineTransform> transforms, Map config, Range[] noData, ROI roi, double destinationNoData, boolean setAlpha, ImageLayout layout) {
        super(ExtendedBandMergeOpImage.vectorize(sources), ExtendedBandMergeOpImage.layoutHelper(sources, layout, setAlpha), config, false, null, null, new double[]{destinationNoData});
        if (transforms != null) {
            if (transforms.size() != sources.size()) {
                throw new IllegalArgumentException("Wrong Transformations number");
            }
        } else {
            throw new IllegalArgumentException("No Transformation has been set");
        }
        this.transforms = transforms;
        this.transformObj = this.optimize(transforms);
        int numSrcs = sources.size();
        this.colorModels = new ColorModel[numSrcs];
        for (int i = 0; i < numSrcs; ++i) {
            this.colorModels[i] = ((RenderedImage)sources.get(i)).getColorModel();
        }
        int dataType = this.getSampleModel().getDataType();
        if (noData != null) {
            int nullRanges = 0;
            for (int i = 0; i < noData.length; ++i) {
                nullRanges += noData[i] == null ? 1 : 0;
            }
            if (nullRanges != noData.length) {
                if (noData.length != numSrcs || nullRanges > 0) {
                    Range firstNoData = noData[0];
                    this.noData = new Range[numSrcs];
                    for (int i = 0; i < numSrcs; ++i) {
                        this.noData[i] = firstNoData;
                    }
                } else {
                    this.noData = noData;
                }
                this.hasNoData = true;
            } else {
                this.noData = null;
                this.hasNoData = false;
            }
        } else {
            this.noData = null;
            this.hasNoData = false;
        }
        this.roi = roi;
        this.hasROI = roi != null;
        this.caseA = !this.hasROI && !this.hasNoData;
        this.caseB = this.hasROI && !this.hasNoData;
        this.caseC = !this.hasROI && this.hasNoData;
        switch (dataType) {
            case 0: {
                this.destNoDataByte = ImageUtil.clampRoundByte((double)destinationNoData);
                break;
            }
            case 1: {
                this.destNoDataShort = ImageUtil.clampRoundUShort((double)destinationNoData);
                break;
            }
            case 2: {
                this.destNoDataShort = ImageUtil.clampRoundShort((double)destinationNoData);
                break;
            }
            case 3: {
                this.destNoDataInt = ImageUtil.clampRoundInt((double)destinationNoData);
                break;
            }
            case 4: {
                this.destNoDataFloat = ImageUtil.clampFloat((double)destinationNoData);
                break;
            }
            case 5: {
                this.destNoDataDouble = destinationNoData;
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong image data type");
            }
        }
    }

    private List<Transform> optimize(List<AffineTransform> transforms) {
        ArrayList<Transform> result = new ArrayList<Transform>();
        for (AffineTransform tr : transforms) {
            result.add(Transform.getTransform(tr));
        }
        return result;
    }

    private static int totalNumBands(List sources) {
        int total = 0;
        for (int i = 0; i < sources.size(); ++i) {
            RenderedImage image = (RenderedImage)sources.get(i);
            if (image.getColorModel() instanceof IndexColorModel) {
                total += image.getColorModel().getNumComponents();
                continue;
            }
            total += image.getSampleModel().getNumBands();
        }
        return total;
    }

    private static ImageLayout layoutHelper(List sources, ImageLayout il, boolean setAlpha) {
        ColorModel cm;
        SampleModel sm;
        boolean newLayout = il == null;
        ImageLayout layout = newLayout ? new ImageLayout() : (ImageLayout)il.clone();
        int numSources = sources.size();
        int destNumBands = ExtendedBandMergeOpImage.totalNumBands(sources);
        int destDataType = 0;
        RenderedImage srci = (RenderedImage)sources.get(0);
        boolean intersect = true;
        Rectangle destBounds = null;
        if (layout.isValid(1) && layout.isValid(2) && layout.isValid(4) && layout.isValid(8)) {
            destBounds = new Rectangle(layout.getMinX(null), layout.getMinY(null), layout.getWidth(null), layout.getHeight(null));
            intersect = false;
            if (destBounds.isEmpty()) {
                destBounds = null;
                intersect = true;
            }
        }
        if (intersect) {
            destBounds = new Rectangle(srci.getMinX(), srci.getMinY(), srci.getWidth(), srci.getHeight());
        }
        for (int i = 0; i < numSources; ++i) {
            int typei;
            srci = (RenderedImage)sources.get(i);
            if (intersect) {
                destBounds = destBounds.intersection(new Rectangle(srci.getMinX(), srci.getMinY(), srci.getWidth(), srci.getHeight()));
            }
            destDataType = (typei = srci.getSampleModel().getTransferType()) > destDataType ? typei : destDataType;
        }
        if (intersect) {
            layout.setMinX(destBounds.x);
            layout.setMinY(destBounds.y);
            layout.setWidth(destBounds.width);
            layout.setHeight(destBounds.height);
        }
        if ((sm = layout.getSampleModel((RenderedImage)sources.get(0))).getNumBands() < destNumBands) {
            int[] destOffsets = new int[destNumBands];
            for (int i = 0; i < destNumBands; ++i) {
                destOffsets[i] = i;
            }
            int destTileWidth = sm.getWidth();
            int destTileHeight = sm.getHeight();
            if (layout.isValid(64)) {
                destTileWidth = layout.getTileWidth((RenderedImage)sources.get(0));
            }
            if (layout.isValid(128)) {
                destTileHeight = layout.getTileHeight((RenderedImage)sources.get(0));
            }
            sm = RasterFactory.createComponentSampleModel((SampleModel)sm, (int)destDataType, (int)destTileWidth, (int)destTileHeight, (int)destNumBands);
            layout.setSampleModel(sm);
        }
        if ((cm = layout.getColorModel(null)) != null && !JDKWorkarounds.areCompatibleDataModels((SampleModel)sm, (ColorModel)cm)) {
            layout.unsetValid(512);
        }
        if ((cm == null || !cm.hasAlpha()) && sm instanceof ComponentSampleModel) {
            cm = ImageUtilities.getColorModel((SampleModel)sm, (boolean)setAlpha);
            layout.setColorModel(cm);
        }
        return layout;
    }

    protected void computeRect(PlanarImage[] sources, WritableRaster dest, Rectangle destRect) {
        block10: {
            block9: {
                int destType = dest.getTransferType();
                ROI roiTile = null;
                if (this.hasROI) {
                    Rectangle rect = new Rectangle(destRect);
                    rect.grow(1, 1);
                    roiTile = this.roi.intersect((ROI)new ROIShape((Shape)rect));
                }
                if (this.hasROI && roiTile.getBounds().isEmpty()) break block9;
                switch (destType) {
                    case 0: {
                        this.byteLoop(sources, dest, destRect, roiTile);
                        break block10;
                    }
                    case 2: {
                        this.ushortLoop(sources, dest, destRect, roiTile);
                    }
                    case 1: {
                        this.shortLoop(sources, dest, destRect, roiTile);
                        break block10;
                    }
                    case 3: {
                        this.intLoop(sources, dest, destRect, roiTile);
                        break block10;
                    }
                    case 4: {
                        this.floatLoop(sources, dest, destRect, roiTile);
                        break block10;
                    }
                    case 5: {
                        this.doubleLoop(sources, dest, destRect, roiTile);
                        break block10;
                    }
                    default: {
                        throw new RuntimeException("Wrong image data type");
                    }
                }
            }
            ImageUtil.fillBackground((WritableRaster)dest, (Rectangle)destRect, (double[])this.backgroundValues);
        }
    }

    private void byteLoop(PlanarImage[] sources, WritableRaster dest, Rectangle destRect, ROI roiTile) {
        int nSrcs = sources.length;
        int[] snbands = new int[nSrcs];
        for (int i = 0; i < nSrcs; ++i) {
            snbands[i] = this.colorModels[i] instanceof IndexColorModel ? this.colorModels[i].getNumComponents() : sources[i].getNumBands();
        }
        int dnbands = dest.getNumBands();
        int destType = dest.getTransferType();
        PixelAccessor d = new PixelAccessor(dest.getSampleModel(), null);
        UnpackedImageData dimd = d.getPixels((Raster)dest, destRect, destType, true);
        byte[][] dstdata = (byte[][])dimd.data;
        int dstPixelStride = dimd.pixelStride;
        int dstLineStride = dimd.lineStride;
        Point2D.Double ptSrc = new Point2D.Double(0.0, 0.0);
        Point2D.Double ptDst = new Point2D.Double(0.0, 0.0);
        int minX = destRect.x;
        int minY = destRect.y;
        int db = 0;
        if (this.caseA) {
            for (int sindex = 0; sindex < nSrcs; ++sindex) {
                RandomIter iter = RandomIterFactory.create((RenderedImage)sources[sindex], (Rectangle)sources[sindex].getBounds());
                AffineTransform trans = this.transforms.get(sindex);
                Transform transObj = this.transformObj.get(sindex);
                int srcMinX = sources[sindex].getMinX();
                int srcMinY = sources[sindex].getMinY();
                int srcMaxX = sources[sindex].getMaxX();
                int srcMaxY = sources[sindex].getMaxY();
                int dstLineOffset = 0;
                int dstPixelOffset = 0;
                for (int y = 0; y < destRect.height; ++y) {
                    dstPixelOffset = dstLineOffset;
                    for (int x = 0; x < destRect.width; ++x) {
                        int sb;
                        ((Point2D)ptDst).setLocation(x + minX, y + minY);
                        transObj.transform(trans, ptDst, ptSrc);
                        int srcX = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getX());
                        int srcY = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getY());
                        if (srcX < srcMinX || srcX >= srcMaxX || srcY < srcMinY || srcY >= srcMaxY) {
                            for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.destNoDataByte;
                            }
                        } else {
                            for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = (byte)(iter.getSample(srcX, srcY, sb) & 0xFF);
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstLineOffset += dstLineStride;
                }
                db += snbands[sindex];
            }
        } else if (this.caseB) {
            for (int sindex = 0; sindex < nSrcs; ++sindex) {
                RandomIter iter = RandomIterFactory.create((RenderedImage)sources[sindex], (Rectangle)sources[sindex].getBounds());
                AffineTransform trans = this.transforms.get(sindex);
                Transform transObj = this.transformObj.get(sindex);
                int srcMinX = sources[sindex].getMinX();
                int srcMinY = sources[sindex].getMinY();
                int srcMaxX = sources[sindex].getMaxX();
                int srcMaxY = sources[sindex].getMaxY();
                int dstLineOffset = 0;
                int dstPixelOffset = 0;
                for (int y = 0; y < destRect.height; ++y) {
                    dstPixelOffset = dstLineOffset;
                    for (int x = 0; x < destRect.width; ++x) {
                        int dstX = x + minX;
                        int dstY = y + minY;
                        if (roiTile.contains(dstX, dstY)) {
                            int sb;
                            ((Point2D)ptDst).setLocation(dstX, dstY);
                            transObj.transform(trans, ptDst, ptSrc);
                            int srcX = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getX());
                            int srcY = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getY());
                            if (srcX < srcMinX || srcX >= srcMaxX || srcY < srcMinY || srcY >= srcMaxY) {
                                for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                    dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.destNoDataByte;
                                }
                            } else {
                                for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                    dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = (byte)(iter.getSample(srcX, srcY, sb) & 0xFF);
                                }
                            }
                        } else {
                            for (int sb = 0; sb < snbands[sindex]; ++sb) {
                                dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.destNoDataByte;
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstLineOffset += dstLineStride;
                }
                db += snbands[sindex];
            }
        } else if (this.caseC) {
            for (int sindex = 0; sindex < nSrcs; ++sindex) {
                RandomIter iter = RandomIterFactory.create((RenderedImage)sources[sindex], (Rectangle)sources[sindex].getBounds());
                AffineTransform trans = this.transforms.get(sindex);
                Transform transObj = this.transformObj.get(sindex);
                int srcMinX = sources[sindex].getMinX();
                int srcMinY = sources[sindex].getMinY();
                int srcMaxX = sources[sindex].getMaxX();
                int srcMaxY = sources[sindex].getMaxY();
                int dstLineOffset = 0;
                int dstPixelOffset = 0;
                for (int y = 0; y < destRect.height; ++y) {
                    dstPixelOffset = dstLineOffset;
                    for (int x = 0; x < destRect.width; ++x) {
                        int sb;
                        ((Point2D)ptDst).setLocation(x + minX, y + minY);
                        transObj.transform(trans, ptDst, ptSrc);
                        int srcX = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getX());
                        int srcY = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getY());
                        if (srcX < srcMinX || srcX >= srcMaxX || srcY < srcMinY || srcY >= srcMaxY) {
                            for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.destNoDataByte;
                            }
                        } else {
                            for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                byte pixelValue = (byte)(iter.getSample(srcX, srcY, sb) & 0xFF);
                                dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.noData[sindex].contains(pixelValue) ? this.destNoDataByte : pixelValue;
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstLineOffset += dstLineStride;
                }
                db += snbands[sindex];
            }
        } else {
            for (int sindex = 0; sindex < nSrcs; ++sindex) {
                RandomIter iter = RandomIterFactory.create((RenderedImage)sources[sindex], (Rectangle)sources[sindex].getBounds());
                AffineTransform trans = this.transforms.get(sindex);
                Transform transObj = this.transformObj.get(sindex);
                int srcMinX = sources[sindex].getMinX();
                int srcMinY = sources[sindex].getMinY();
                int srcMaxX = sources[sindex].getMaxX();
                int srcMaxY = sources[sindex].getMaxY();
                int dstLineOffset = 0;
                int dstPixelOffset = 0;
                for (int y = 0; y < destRect.height; ++y) {
                    dstPixelOffset = dstLineOffset;
                    for (int x = 0; x < destRect.width; ++x) {
                        int dstX = x + minX;
                        int dstY = y + minY;
                        if (roiTile.contains(dstX, dstY)) {
                            int sb;
                            ((Point2D)ptDst).setLocation(dstX, dstY);
                            transObj.transform(trans, ptDst, ptSrc);
                            int srcX = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getX());
                            int srcY = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getY());
                            if (srcX < srcMinX || srcX >= srcMaxX || srcY < srcMinY || srcY >= srcMaxY) {
                                for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                    dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.destNoDataByte;
                                }
                            } else {
                                for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                    byte pixelValue = (byte)(iter.getSample(srcX, srcY, sb) & 0xFF);
                                    dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.noData[sindex].contains(pixelValue) ? this.destNoDataByte : pixelValue;
                                }
                            }
                        } else {
                            for (int sb = 0; sb < snbands[sindex]; ++sb) {
                                dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.destNoDataByte;
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstLineOffset += dstLineStride;
                }
                db += snbands[sindex];
            }
        }
        d.setPixels(dimd);
    }

    private void ushortLoop(PlanarImage[] sources, WritableRaster dest, Rectangle destRect, ROI roiTile) {
        int nSrcs = sources.length;
        int[] snbands = new int[nSrcs];
        for (int i = 0; i < nSrcs; ++i) {
            snbands[i] = this.colorModels[i] instanceof IndexColorModel ? this.colorModels[i].getNumComponents() : sources[i].getNumBands();
        }
        int dnbands = dest.getNumBands();
        int destType = dest.getTransferType();
        PixelAccessor d = new PixelAccessor(dest.getSampleModel(), null);
        UnpackedImageData dimd = d.getPixels((Raster)dest, destRect, destType, true);
        short[][] dstdata = (short[][])dimd.data;
        int dstPixelStride = dimd.pixelStride;
        int dstLineStride = dimd.lineStride;
        Point2D.Double ptSrc = new Point2D.Double(0.0, 0.0);
        Point2D.Double ptDst = new Point2D.Double(0.0, 0.0);
        int minX = destRect.x;
        int minY = destRect.y;
        int db = 0;
        if (this.caseA) {
            for (int sindex = 0; sindex < nSrcs; ++sindex) {
                RandomIter iter = RandomIterFactory.create((RenderedImage)sources[sindex], (Rectangle)sources[sindex].getBounds());
                AffineTransform trans = this.transforms.get(sindex);
                Transform transObj = this.transformObj.get(sindex);
                int srcMinX = sources[sindex].getMinX();
                int srcMinY = sources[sindex].getMinY();
                int srcMaxX = sources[sindex].getMaxX();
                int srcMaxY = sources[sindex].getMaxY();
                int dstLineOffset = 0;
                int dstPixelOffset = 0;
                for (int y = 0; y < destRect.height; ++y) {
                    dstPixelOffset = dstLineOffset;
                    for (int x = 0; x < destRect.width; ++x) {
                        int sb;
                        ((Point2D)ptDst).setLocation(x + minX, y + minY);
                        transObj.transform(trans, ptDst, ptSrc);
                        int srcX = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getX());
                        int srcY = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getY());
                        if (srcX < srcMinX || srcX >= srcMaxX || srcY < srcMinY || srcY >= srcMaxY) {
                            for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.destNoDataShort;
                            }
                        } else {
                            for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = (short)iter.getSample(srcX, srcY, sb);
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstLineOffset += dstLineStride;
                }
                db += snbands[sindex];
            }
        } else if (this.caseB) {
            for (int sindex = 0; sindex < nSrcs; ++sindex) {
                RandomIter iter = RandomIterFactory.create((RenderedImage)sources[sindex], (Rectangle)sources[sindex].getBounds());
                AffineTransform trans = this.transforms.get(sindex);
                Transform transObj = this.transformObj.get(sindex);
                int srcMinX = sources[sindex].getMinX();
                int srcMinY = sources[sindex].getMinY();
                int srcMaxX = sources[sindex].getMaxX();
                int srcMaxY = sources[sindex].getMaxY();
                int dstLineOffset = 0;
                int dstPixelOffset = 0;
                for (int y = 0; y < destRect.height; ++y) {
                    dstPixelOffset = dstLineOffset;
                    for (int x = 0; x < destRect.width; ++x) {
                        int dstX = x + minX;
                        int dstY = y + minY;
                        if (roiTile.contains(dstX, dstY)) {
                            int sb;
                            ((Point2D)ptDst).setLocation(dstX, dstY);
                            transObj.transform(trans, ptDst, ptSrc);
                            int srcX = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getX());
                            int srcY = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getY());
                            if (srcX < srcMinX || srcX >= srcMaxX || srcY < srcMinY || srcY >= srcMaxY) {
                                for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                    dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.destNoDataShort;
                                }
                            } else {
                                for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                    dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = (short)iter.getSample(srcX, srcY, sb);
                                }
                            }
                        } else {
                            for (int sb = 0; sb < snbands[sindex]; ++sb) {
                                dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.destNoDataShort;
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstLineOffset += dstLineStride;
                }
                db += snbands[sindex];
            }
        } else if (this.caseC) {
            for (int sindex = 0; sindex < nSrcs; ++sindex) {
                RandomIter iter = RandomIterFactory.create((RenderedImage)sources[sindex], (Rectangle)sources[sindex].getBounds());
                AffineTransform trans = this.transforms.get(sindex);
                Transform transObj = this.transformObj.get(sindex);
                int srcMinX = sources[sindex].getMinX();
                int srcMinY = sources[sindex].getMinY();
                int srcMaxX = sources[sindex].getMaxX();
                int srcMaxY = sources[sindex].getMaxY();
                int dstLineOffset = 0;
                int dstPixelOffset = 0;
                for (int y = 0; y < destRect.height; ++y) {
                    dstPixelOffset = dstLineOffset;
                    for (int x = 0; x < destRect.width; ++x) {
                        int sb;
                        ((Point2D)ptDst).setLocation(x + minX, y + minY);
                        transObj.transform(trans, ptDst, ptSrc);
                        int srcX = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getX());
                        int srcY = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getY());
                        if (srcX < srcMinX || srcX >= srcMaxX || srcY < srcMinY || srcY >= srcMaxY) {
                            for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.destNoDataShort;
                            }
                        } else {
                            for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                short pixelValue = (short)iter.getSample(srcX, srcY, sb);
                                dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.noData[sindex].contains(pixelValue) ? this.destNoDataShort : pixelValue;
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstLineOffset += dstLineStride;
                }
                db += snbands[sindex];
            }
        } else {
            for (int sindex = 0; sindex < nSrcs; ++sindex) {
                RandomIter iter = RandomIterFactory.create((RenderedImage)sources[sindex], (Rectangle)sources[sindex].getBounds());
                AffineTransform trans = this.transforms.get(sindex);
                Transform transObj = this.transformObj.get(sindex);
                int srcMinX = sources[sindex].getMinX();
                int srcMinY = sources[sindex].getMinY();
                int srcMaxX = sources[sindex].getMaxX();
                int srcMaxY = sources[sindex].getMaxY();
                int dstLineOffset = 0;
                int dstPixelOffset = 0;
                for (int y = 0; y < destRect.height; ++y) {
                    dstPixelOffset = dstLineOffset;
                    for (int x = 0; x < destRect.width; ++x) {
                        int dstX = x + minX;
                        int dstY = y + minY;
                        if (roiTile.contains(dstX, dstY)) {
                            int sb;
                            ((Point2D)ptDst).setLocation(dstX, dstY);
                            transObj.transform(trans, ptDst, ptSrc);
                            int srcX = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getX());
                            int srcY = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getY());
                            if (srcX < srcMinX || srcX >= srcMaxX || srcY < srcMinY || srcY >= srcMaxY) {
                                for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                    dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.destNoDataShort;
                                }
                            } else {
                                for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                    short pixelValue = (short)iter.getSample(srcX, srcY, sb);
                                    dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.noData[sindex].contains(pixelValue) ? this.destNoDataShort : pixelValue;
                                }
                            }
                        } else {
                            for (int sb = 0; sb < snbands[sindex]; ++sb) {
                                dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.destNoDataShort;
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstLineOffset += dstLineStride;
                }
                db += snbands[sindex];
            }
        }
        d.setPixels(dimd);
    }

    private void shortLoop(PlanarImage[] sources, WritableRaster dest, Rectangle destRect, ROI roiTile) {
        int nSrcs = sources.length;
        int[] snbands = new int[nSrcs];
        for (int i = 0; i < nSrcs; ++i) {
            snbands[i] = this.colorModels[i] instanceof IndexColorModel ? this.colorModels[i].getNumComponents() : sources[i].getNumBands();
        }
        int dnbands = dest.getNumBands();
        int destType = dest.getTransferType();
        PixelAccessor d = new PixelAccessor(dest.getSampleModel(), null);
        UnpackedImageData dimd = d.getPixels((Raster)dest, destRect, destType, true);
        short[][] dstdata = (short[][])dimd.data;
        int dstPixelStride = dimd.pixelStride;
        int dstLineStride = dimd.lineStride;
        Point2D.Double ptSrc = new Point2D.Double(0.0, 0.0);
        Point2D.Double ptDst = new Point2D.Double(0.0, 0.0);
        int minX = destRect.x;
        int minY = destRect.y;
        int db = 0;
        if (this.caseA) {
            for (int sindex = 0; sindex < nSrcs; ++sindex) {
                RandomIter iter = RandomIterFactory.create((RenderedImage)sources[sindex], (Rectangle)sources[sindex].getBounds());
                AffineTransform trans = this.transforms.get(sindex);
                Transform transObj = this.transformObj.get(sindex);
                int srcMinX = sources[sindex].getMinX();
                int srcMinY = sources[sindex].getMinY();
                int srcMaxX = sources[sindex].getMaxX();
                int srcMaxY = sources[sindex].getMaxY();
                int dstLineOffset = 0;
                int dstPixelOffset = 0;
                for (int y = 0; y < destRect.height; ++y) {
                    dstPixelOffset = dstLineOffset;
                    for (int x = 0; x < destRect.width; ++x) {
                        int sb;
                        ((Point2D)ptDst).setLocation(x + minX, y + minY);
                        transObj.transform(trans, ptDst, ptSrc);
                        int srcX = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getX());
                        int srcY = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getY());
                        if (srcX < srcMinX || srcX >= srcMaxX || srcY < srcMinY || srcY >= srcMaxY) {
                            for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.destNoDataShort;
                            }
                        } else {
                            for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = (short)iter.getSample(srcX, srcY, sb);
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstLineOffset += dstLineStride;
                }
                db += snbands[sindex];
            }
        } else if (this.caseB) {
            for (int sindex = 0; sindex < nSrcs; ++sindex) {
                RandomIter iter = RandomIterFactory.create((RenderedImage)sources[sindex], (Rectangle)sources[sindex].getBounds());
                AffineTransform trans = this.transforms.get(sindex);
                Transform transObj = this.transformObj.get(sindex);
                int srcMinX = sources[sindex].getMinX();
                int srcMinY = sources[sindex].getMinY();
                int srcMaxX = sources[sindex].getMaxX();
                int srcMaxY = sources[sindex].getMaxY();
                int dstLineOffset = 0;
                int dstPixelOffset = 0;
                for (int y = 0; y < destRect.height; ++y) {
                    dstPixelOffset = dstLineOffset;
                    for (int x = 0; x < destRect.width; ++x) {
                        int dstX = x + minX;
                        int dstY = y + minY;
                        if (roiTile.contains(dstX, dstY)) {
                            int sb;
                            ((Point2D)ptDst).setLocation(dstX, dstY);
                            transObj.transform(trans, ptDst, ptSrc);
                            int srcX = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getX());
                            int srcY = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getY());
                            if (srcX < srcMinX || srcX >= srcMaxX || srcY < srcMinY || srcY >= srcMaxY) {
                                for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                    dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.destNoDataShort;
                                }
                            } else {
                                for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                    dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = (short)iter.getSample(srcX, srcY, sb);
                                }
                            }
                        } else {
                            for (int sb = 0; sb < snbands[sindex]; ++sb) {
                                dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.destNoDataShort;
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstLineOffset += dstLineStride;
                }
                db += snbands[sindex];
            }
        } else if (this.caseC) {
            for (int sindex = 0; sindex < nSrcs; ++sindex) {
                RandomIter iter = RandomIterFactory.create((RenderedImage)sources[sindex], (Rectangle)sources[sindex].getBounds());
                AffineTransform trans = this.transforms.get(sindex);
                Transform transObj = this.transformObj.get(sindex);
                int srcMinX = sources[sindex].getMinX();
                int srcMinY = sources[sindex].getMinY();
                int srcMaxX = sources[sindex].getMaxX();
                int srcMaxY = sources[sindex].getMaxY();
                int dstLineOffset = 0;
                int dstPixelOffset = 0;
                for (int y = 0; y < destRect.height; ++y) {
                    dstPixelOffset = dstLineOffset;
                    for (int x = 0; x < destRect.width; ++x) {
                        int sb;
                        ((Point2D)ptDst).setLocation(x + minX, y + minY);
                        transObj.transform(trans, ptDst, ptSrc);
                        int srcX = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getX());
                        int srcY = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getY());
                        if (srcX < srcMinX || srcX >= srcMaxX || srcY < srcMinY || srcY >= srcMaxY) {
                            for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.destNoDataShort;
                            }
                        } else {
                            for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                short pixelValue = (short)iter.getSample(srcX, srcY, sb);
                                dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.noData[sindex].contains(pixelValue) ? this.destNoDataShort : pixelValue;
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstLineOffset += dstLineStride;
                }
                db += snbands[sindex];
            }
        } else {
            for (int sindex = 0; sindex < nSrcs; ++sindex) {
                RandomIter iter = RandomIterFactory.create((RenderedImage)sources[sindex], (Rectangle)sources[sindex].getBounds());
                AffineTransform trans = this.transforms.get(sindex);
                Transform transObj = this.transformObj.get(sindex);
                int srcMinX = sources[sindex].getMinX();
                int srcMinY = sources[sindex].getMinY();
                int srcMaxX = sources[sindex].getMaxX();
                int srcMaxY = sources[sindex].getMaxY();
                int dstLineOffset = 0;
                int dstPixelOffset = 0;
                for (int y = 0; y < destRect.height; ++y) {
                    dstPixelOffset = dstLineOffset;
                    for (int x = 0; x < destRect.width; ++x) {
                        int dstX = x + minX;
                        int dstY = y + minY;
                        if (roiTile.contains(dstX, dstY)) {
                            int sb;
                            ((Point2D)ptDst).setLocation(dstX, dstY);
                            transObj.transform(trans, ptDst, ptSrc);
                            int srcX = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getX());
                            int srcY = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getY());
                            if (srcX < srcMinX || srcX >= srcMaxX || srcY < srcMinY || srcY >= srcMaxY) {
                                for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                    dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.destNoDataShort;
                                }
                            } else {
                                for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                    short pixelValue = (short)iter.getSample(srcX, srcY, sb);
                                    dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.noData[sindex].contains(pixelValue) ? this.destNoDataShort : pixelValue;
                                }
                            }
                        } else {
                            for (int sb = 0; sb < snbands[sindex]; ++sb) {
                                dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.destNoDataShort;
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstLineOffset += dstLineStride;
                }
                db += snbands[sindex];
            }
        }
        d.setPixels(dimd);
    }

    private void intLoop(PlanarImage[] sources, WritableRaster dest, Rectangle destRect, ROI roiTile) {
        int nSrcs = sources.length;
        int[] snbands = new int[nSrcs];
        for (int i = 0; i < nSrcs; ++i) {
            snbands[i] = this.colorModels[i] instanceof IndexColorModel ? this.colorModels[i].getNumComponents() : sources[i].getNumBands();
        }
        int dnbands = dest.getNumBands();
        int destType = dest.getTransferType();
        PixelAccessor d = new PixelAccessor(dest.getSampleModel(), null);
        UnpackedImageData dimd = d.getPixels((Raster)dest, destRect, destType, true);
        int[][] dstdata = (int[][])dimd.data;
        int dstPixelStride = dimd.pixelStride;
        int dstLineStride = dimd.lineStride;
        Point2D.Double ptSrc = new Point2D.Double(0.0, 0.0);
        Point2D.Double ptDst = new Point2D.Double(0.0, 0.0);
        int minX = destRect.x;
        int minY = destRect.y;
        int db = 0;
        if (this.caseA) {
            for (int sindex = 0; sindex < nSrcs; ++sindex) {
                RandomIter iter = RandomIterFactory.create((RenderedImage)sources[sindex], (Rectangle)sources[sindex].getBounds());
                AffineTransform trans = this.transforms.get(sindex);
                Transform transObj = this.transformObj.get(sindex);
                int srcMinX = sources[sindex].getMinX();
                int srcMinY = sources[sindex].getMinY();
                int srcMaxX = sources[sindex].getMaxX();
                int srcMaxY = sources[sindex].getMaxY();
                int dstLineOffset = 0;
                int dstPixelOffset = 0;
                for (int y = 0; y < destRect.height; ++y) {
                    dstPixelOffset = dstLineOffset;
                    for (int x = 0; x < destRect.width; ++x) {
                        int sb;
                        ((Point2D)ptDst).setLocation(x + minX, y + minY);
                        transObj.transform(trans, ptDst, ptSrc);
                        int srcX = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getX());
                        int srcY = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getY());
                        if (srcX < srcMinX || srcX >= srcMaxX || srcY < srcMinY || srcY >= srcMaxY) {
                            for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.destNoDataInt;
                            }
                        } else {
                            for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = iter.getSample(srcX, srcY, sb);
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstLineOffset += dstLineStride;
                }
                db += snbands[sindex];
            }
        } else if (this.caseB) {
            for (int sindex = 0; sindex < nSrcs; ++sindex) {
                RandomIter iter = RandomIterFactory.create((RenderedImage)sources[sindex], (Rectangle)sources[sindex].getBounds());
                AffineTransform trans = this.transforms.get(sindex);
                Transform transObj = this.transformObj.get(sindex);
                int srcMinX = sources[sindex].getMinX();
                int srcMinY = sources[sindex].getMinY();
                int srcMaxX = sources[sindex].getMaxX();
                int srcMaxY = sources[sindex].getMaxY();
                int dstLineOffset = 0;
                int dstPixelOffset = 0;
                for (int y = 0; y < destRect.height; ++y) {
                    dstPixelOffset = dstLineOffset;
                    for (int x = 0; x < destRect.width; ++x) {
                        int dstX = x + minX;
                        int dstY = y + minY;
                        if (roiTile.contains(dstX, dstY)) {
                            int sb;
                            ((Point2D)ptDst).setLocation(dstX, dstY);
                            transObj.transform(trans, ptDst, ptSrc);
                            int srcX = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getX());
                            int srcY = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getY());
                            if (srcX < srcMinX || srcX >= srcMaxX || srcY < srcMinY || srcY >= srcMaxY) {
                                for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                    dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.destNoDataInt;
                                }
                            } else {
                                for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                    dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = iter.getSample(srcX, srcY, sb);
                                }
                            }
                        } else {
                            for (int sb = 0; sb < snbands[sindex]; ++sb) {
                                dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.destNoDataInt;
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstLineOffset += dstLineStride;
                }
                db += snbands[sindex];
            }
        } else if (this.caseC) {
            for (int sindex = 0; sindex < nSrcs; ++sindex) {
                RandomIter iter = RandomIterFactory.create((RenderedImage)sources[sindex], (Rectangle)sources[sindex].getBounds());
                AffineTransform trans = this.transforms.get(sindex);
                Transform transObj = this.transformObj.get(sindex);
                int srcMinX = sources[sindex].getMinX();
                int srcMinY = sources[sindex].getMinY();
                int srcMaxX = sources[sindex].getMaxX();
                int srcMaxY = sources[sindex].getMaxY();
                int dstLineOffset = 0;
                int dstPixelOffset = 0;
                for (int y = 0; y < destRect.height; ++y) {
                    dstPixelOffset = dstLineOffset;
                    for (int x = 0; x < destRect.width; ++x) {
                        int sb;
                        ((Point2D)ptDst).setLocation(x + minX, y + minY);
                        transObj.transform(trans, ptDst, ptSrc);
                        int srcX = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getX());
                        int srcY = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getY());
                        if (srcX < srcMinX || srcX >= srcMaxX || srcY < srcMinY || srcY >= srcMaxY) {
                            for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.destNoDataInt;
                            }
                        } else {
                            for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                int pixelValue = iter.getSample(srcX, srcY, sb);
                                dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.noData[sindex].contains(pixelValue) ? this.destNoDataInt : pixelValue;
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstLineOffset += dstLineStride;
                }
                db += snbands[sindex];
            }
        } else {
            for (int sindex = 0; sindex < nSrcs; ++sindex) {
                RandomIter iter = RandomIterFactory.create((RenderedImage)sources[sindex], (Rectangle)sources[sindex].getBounds());
                AffineTransform trans = this.transforms.get(sindex);
                Transform transObj = this.transformObj.get(sindex);
                int srcMinX = sources[sindex].getMinX();
                int srcMinY = sources[sindex].getMinY();
                int srcMaxX = sources[sindex].getMaxX();
                int srcMaxY = sources[sindex].getMaxY();
                int dstLineOffset = 0;
                int dstPixelOffset = 0;
                for (int y = 0; y < destRect.height; ++y) {
                    dstPixelOffset = dstLineOffset;
                    for (int x = 0; x < destRect.width; ++x) {
                        int dstX = x + minX;
                        int dstY = y + minY;
                        if (roiTile.contains(dstX, dstY)) {
                            int sb;
                            ((Point2D)ptDst).setLocation(dstX, dstY);
                            transObj.transform(trans, ptDst, ptSrc);
                            int srcX = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getX());
                            int srcY = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getY());
                            if (srcX < srcMinX || srcX >= srcMaxX || srcY < srcMinY || srcY >= srcMaxY) {
                                for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                    dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.destNoDataInt;
                                }
                            } else {
                                for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                    int pixelValue = iter.getSample(srcX, srcY, sb);
                                    dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.noData[sindex].contains(pixelValue) ? this.destNoDataInt : pixelValue;
                                }
                            }
                        } else {
                            for (int sb = 0; sb < snbands[sindex]; ++sb) {
                                dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.destNoDataInt;
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstLineOffset += dstLineStride;
                }
                db += snbands[sindex];
            }
        }
        d.setPixels(dimd);
    }

    private void floatLoop(PlanarImage[] sources, WritableRaster dest, Rectangle destRect, ROI roiTile) {
        int nSrcs = sources.length;
        int[] snbands = new int[nSrcs];
        for (int i = 0; i < nSrcs; ++i) {
            snbands[i] = this.colorModels[i] instanceof IndexColorModel ? this.colorModels[i].getNumComponents() : sources[i].getNumBands();
        }
        int dnbands = dest.getNumBands();
        int destType = dest.getTransferType();
        PixelAccessor d = new PixelAccessor(dest.getSampleModel(), null);
        UnpackedImageData dimd = d.getPixels((Raster)dest, destRect, destType, true);
        float[][] dstdata = (float[][])dimd.data;
        int dstPixelStride = dimd.pixelStride;
        int dstLineStride = dimd.lineStride;
        Point2D.Double ptSrc = new Point2D.Double(0.0, 0.0);
        Point2D.Double ptDst = new Point2D.Double(0.0, 0.0);
        int minX = destRect.x;
        int minY = destRect.y;
        int db = 0;
        if (this.caseA) {
            for (int sindex = 0; sindex < nSrcs; ++sindex) {
                RandomIter iter = RandomIterFactory.create((RenderedImage)sources[sindex], (Rectangle)sources[sindex].getBounds());
                AffineTransform trans = this.transforms.get(sindex);
                Transform transObj = this.transformObj.get(sindex);
                int srcMinX = sources[sindex].getMinX();
                int srcMinY = sources[sindex].getMinY();
                int srcMaxX = sources[sindex].getMaxX();
                int srcMaxY = sources[sindex].getMaxY();
                int dstLineOffset = 0;
                int dstPixelOffset = 0;
                for (int y = 0; y < destRect.height; ++y) {
                    dstPixelOffset = dstLineOffset;
                    for (int x = 0; x < destRect.width; ++x) {
                        int sb;
                        ((Point2D)ptDst).setLocation(x + minX, y + minY);
                        transObj.transform(trans, ptDst, ptSrc);
                        int srcX = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getX());
                        int srcY = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getY());
                        if (srcX < srcMinX || srcX >= srcMaxX || srcY < srcMinY || srcY >= srcMaxY) {
                            for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.destNoDataFloat;
                            }
                        } else {
                            for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = iter.getSampleFloat(srcX, srcY, sb);
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstLineOffset += dstLineStride;
                }
                db += snbands[sindex];
            }
        } else if (this.caseB) {
            for (int sindex = 0; sindex < nSrcs; ++sindex) {
                RandomIter iter = RandomIterFactory.create((RenderedImage)sources[sindex], (Rectangle)sources[sindex].getBounds());
                AffineTransform trans = this.transforms.get(sindex);
                Transform transObj = this.transformObj.get(sindex);
                int srcMinX = sources[sindex].getMinX();
                int srcMinY = sources[sindex].getMinY();
                int srcMaxX = sources[sindex].getMaxX();
                int srcMaxY = sources[sindex].getMaxY();
                int dstLineOffset = 0;
                int dstPixelOffset = 0;
                for (int y = 0; y < destRect.height; ++y) {
                    dstPixelOffset = dstLineOffset;
                    for (int x = 0; x < destRect.width; ++x) {
                        int dstX = x + minX;
                        int dstY = y + minY;
                        if (roiTile.contains(dstX, dstY)) {
                            int sb;
                            ((Point2D)ptDst).setLocation(dstX, dstY);
                            transObj.transform(trans, ptDst, ptSrc);
                            int srcX = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getX());
                            int srcY = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getY());
                            if (srcX < srcMinX || srcX >= srcMaxX || srcY < srcMinY || srcY >= srcMaxY) {
                                for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                    dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.destNoDataFloat;
                                }
                            } else {
                                for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                    dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = iter.getSampleFloat(srcX, srcY, sb);
                                }
                            }
                        } else {
                            for (int sb = 0; sb < snbands[sindex]; ++sb) {
                                dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.destNoDataFloat;
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstLineOffset += dstLineStride;
                }
                db += snbands[sindex];
            }
        } else if (this.caseC) {
            for (int sindex = 0; sindex < nSrcs; ++sindex) {
                RandomIter iter = RandomIterFactory.create((RenderedImage)sources[sindex], (Rectangle)sources[sindex].getBounds());
                AffineTransform trans = this.transforms.get(sindex);
                Transform transObj = this.transformObj.get(sindex);
                int srcMinX = sources[sindex].getMinX();
                int srcMinY = sources[sindex].getMinY();
                int srcMaxX = sources[sindex].getMaxX();
                int srcMaxY = sources[sindex].getMaxY();
                int dstLineOffset = 0;
                int dstPixelOffset = 0;
                for (int y = 0; y < destRect.height; ++y) {
                    dstPixelOffset = dstLineOffset;
                    for (int x = 0; x < destRect.width; ++x) {
                        int sb;
                        ((Point2D)ptDst).setLocation(x + minX, y + minY);
                        transObj.transform(trans, ptDst, ptSrc);
                        int srcX = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getX());
                        int srcY = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getY());
                        if (srcX < srcMinX || srcX >= srcMaxX || srcY < srcMinY || srcY >= srcMaxY) {
                            for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.destNoDataFloat;
                            }
                        } else {
                            for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                float pixelValue = iter.getSampleFloat(srcX, srcY, sb);
                                dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.noData[sindex].contains(pixelValue) ? this.destNoDataFloat : pixelValue;
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstLineOffset += dstLineStride;
                }
                db += snbands[sindex];
            }
        } else {
            for (int sindex = 0; sindex < nSrcs; ++sindex) {
                RandomIter iter = RandomIterFactory.create((RenderedImage)sources[sindex], (Rectangle)sources[sindex].getBounds());
                AffineTransform trans = this.transforms.get(sindex);
                Transform transObj = this.transformObj.get(sindex);
                int srcMinX = sources[sindex].getMinX();
                int srcMinY = sources[sindex].getMinY();
                int srcMaxX = sources[sindex].getMaxX();
                int srcMaxY = sources[sindex].getMaxY();
                int dstLineOffset = 0;
                int dstPixelOffset = 0;
                for (int y = 0; y < destRect.height; ++y) {
                    dstPixelOffset = dstLineOffset;
                    for (int x = 0; x < destRect.width; ++x) {
                        int dstX = x + minX;
                        int dstY = y + minY;
                        if (roiTile.contains(dstX, dstY)) {
                            int sb;
                            ((Point2D)ptDst).setLocation(dstX, dstY);
                            transObj.transform(trans, ptDst, ptSrc);
                            int srcX = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getX());
                            int srcY = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getY());
                            if (srcX < srcMinX || srcX >= srcMaxX || srcY < srcMinY || srcY >= srcMaxY) {
                                for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                    dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.destNoDataFloat;
                                }
                            } else {
                                for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                    float pixelValue = iter.getSampleFloat(srcX, srcY, sb);
                                    dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.noData[sindex].contains(pixelValue) ? this.destNoDataFloat : pixelValue;
                                }
                            }
                        } else {
                            for (int sb = 0; sb < snbands[sindex]; ++sb) {
                                dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.destNoDataFloat;
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstLineOffset += dstLineStride;
                }
                db += snbands[sindex];
            }
        }
        d.setPixels(dimd);
    }

    private void doubleLoop(PlanarImage[] sources, WritableRaster dest, Rectangle destRect, ROI roiTile) {
        int nSrcs = sources.length;
        int[] snbands = new int[nSrcs];
        for (int i = 0; i < nSrcs; ++i) {
            snbands[i] = this.colorModels[i] instanceof IndexColorModel ? this.colorModels[i].getNumComponents() : sources[i].getNumBands();
        }
        int dnbands = dest.getNumBands();
        int destType = dest.getTransferType();
        PixelAccessor d = new PixelAccessor(dest.getSampleModel(), null);
        UnpackedImageData dimd = d.getPixels((Raster)dest, destRect, destType, true);
        double[][] dstdata = (double[][])dimd.data;
        int dstPixelStride = dimd.pixelStride;
        int dstLineStride = dimd.lineStride;
        Point2D.Double ptSrc = new Point2D.Double(0.0, 0.0);
        Point2D.Double ptDst = new Point2D.Double(0.0, 0.0);
        int minX = destRect.x;
        int minY = destRect.y;
        int db = 0;
        if (this.caseA) {
            for (int sindex = 0; sindex < nSrcs; ++sindex) {
                RandomIter iter = RandomIterFactory.create((RenderedImage)sources[sindex], (Rectangle)sources[sindex].getBounds());
                AffineTransform trans = this.transforms.get(sindex);
                Transform transObj = this.transformObj.get(sindex);
                int srcMinX = sources[sindex].getMinX();
                int srcMinY = sources[sindex].getMinY();
                int srcMaxX = sources[sindex].getMaxX();
                int srcMaxY = sources[sindex].getMaxY();
                int dstLineOffset = 0;
                int dstPixelOffset = 0;
                for (int y = 0; y < destRect.height; ++y) {
                    dstPixelOffset = dstLineOffset;
                    for (int x = 0; x < destRect.width; ++x) {
                        int sb;
                        ((Point2D)ptDst).setLocation(x + minX, y + minY);
                        transObj.transform(trans, ptDst, ptSrc);
                        int srcX = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getX());
                        int srcY = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getY());
                        if (srcX < srcMinX || srcX >= srcMaxX || srcY < srcMinY || srcY >= srcMaxY) {
                            for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.destNoDataDouble;
                            }
                        } else {
                            for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = iter.getSampleDouble(srcX, srcY, sb);
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstLineOffset += dstLineStride;
                }
                db += snbands[sindex];
            }
        } else if (this.caseB) {
            for (int sindex = 0; sindex < nSrcs; ++sindex) {
                RandomIter iter = RandomIterFactory.create((RenderedImage)sources[sindex], (Rectangle)sources[sindex].getBounds());
                AffineTransform trans = this.transforms.get(sindex);
                Transform transObj = this.transformObj.get(sindex);
                int srcMinX = sources[sindex].getMinX();
                int srcMinY = sources[sindex].getMinY();
                int srcMaxX = sources[sindex].getMaxX();
                int srcMaxY = sources[sindex].getMaxY();
                int dstLineOffset = 0;
                int dstPixelOffset = 0;
                for (int y = 0; y < destRect.height; ++y) {
                    dstPixelOffset = dstLineOffset;
                    for (int x = 0; x < destRect.width; ++x) {
                        int dstX = x + minX;
                        int dstY = y + minY;
                        if (roiTile.contains(dstX, dstY)) {
                            int sb;
                            ((Point2D)ptDst).setLocation(dstX, dstY);
                            transObj.transform(trans, ptDst, ptSrc);
                            int srcX = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getX());
                            int srcY = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getY());
                            if (srcX < srcMinX || srcX >= srcMaxX || srcY < srcMinY || srcY >= srcMaxY) {
                                for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                    dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.destNoDataDouble;
                                }
                            } else {
                                for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                    dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = iter.getSampleDouble(srcX, srcY, sb);
                                }
                            }
                        } else {
                            for (int sb = 0; sb < snbands[sindex]; ++sb) {
                                dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.destNoDataDouble;
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstLineOffset += dstLineStride;
                }
                db += snbands[sindex];
            }
        } else if (this.caseC) {
            for (int sindex = 0; sindex < nSrcs; ++sindex) {
                RandomIter iter = RandomIterFactory.create((RenderedImage)sources[sindex], (Rectangle)sources[sindex].getBounds());
                AffineTransform trans = this.transforms.get(sindex);
                Transform transObj = this.transformObj.get(sindex);
                int srcMinX = sources[sindex].getMinX();
                int srcMinY = sources[sindex].getMinY();
                int srcMaxX = sources[sindex].getMaxX();
                int srcMaxY = sources[sindex].getMaxY();
                int dstLineOffset = 0;
                int dstPixelOffset = 0;
                for (int y = 0; y < destRect.height; ++y) {
                    dstPixelOffset = dstLineOffset;
                    for (int x = 0; x < destRect.width; ++x) {
                        int sb;
                        ((Point2D)ptDst).setLocation(x + minX, y + minY);
                        transObj.transform(trans, ptDst, ptSrc);
                        int srcX = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getX());
                        int srcY = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getY());
                        if (srcX < srcMinX || srcX >= srcMaxX || srcY < srcMinY || srcY >= srcMaxY) {
                            for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.destNoDataDouble;
                            }
                        } else {
                            for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                double pixelValue = iter.getSampleDouble(srcX, srcY, sb);
                                dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.noData[sindex].contains(pixelValue) ? this.destNoDataDouble : pixelValue;
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstLineOffset += dstLineStride;
                }
                db += snbands[sindex];
            }
        } else {
            for (int sindex = 0; sindex < nSrcs; ++sindex) {
                RandomIter iter = RandomIterFactory.create((RenderedImage)sources[sindex], (Rectangle)sources[sindex].getBounds());
                AffineTransform trans = this.transforms.get(sindex);
                Transform transObj = this.transformObj.get(sindex);
                int srcMinX = sources[sindex].getMinX();
                int srcMinY = sources[sindex].getMinY();
                int srcMaxX = sources[sindex].getMaxX();
                int srcMaxY = sources[sindex].getMaxY();
                int dstLineOffset = 0;
                int dstPixelOffset = 0;
                for (int y = 0; y < destRect.height; ++y) {
                    dstPixelOffset = dstLineOffset;
                    for (int x = 0; x < destRect.width; ++x) {
                        int dstX = x + minX;
                        int dstY = y + minY;
                        if (roiTile.contains(dstX, dstY)) {
                            int sb;
                            ((Point2D)ptDst).setLocation(dstX, dstY);
                            transObj.transform(trans, ptDst, ptSrc);
                            int srcX = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getX());
                            int srcY = ExtendedBandMergeOpImage.round(((Point2D)ptSrc).getY());
                            if (srcX < srcMinX || srcX >= srcMaxX || srcY < srcMinY || srcY >= srcMaxY) {
                                for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                    dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.destNoDataDouble;
                                }
                            } else {
                                for (sb = 0; sb < snbands[sindex] && db < dnbands; ++sb) {
                                    double pixelValue = iter.getSampleDouble(srcX, srcY, sb);
                                    dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.noData[sindex].contains(pixelValue) ? this.destNoDataDouble : pixelValue;
                                }
                            }
                        } else {
                            for (int sb = 0; sb < snbands[sindex]; ++sb) {
                                dstdata[db + sb][dstPixelOffset + dimd.getOffset((int)(db + sb))] = this.destNoDataDouble;
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstLineOffset += dstLineStride;
                }
                db += snbands[sindex];
            }
        }
        d.setPixels(dimd);
    }

    private static Vector vectorize(List sources) {
        if (sources instanceof Vector) {
            return (Vector)sources;
        }
        Vector vector = new Vector(sources.size());
        for (Object element : sources) {
            vector.add(element);
        }
        return vector;
    }

    private static int round(double f) {
        return f >= 0.0 ? (int)(f + 0.5) : (int)(f - 0.5);
    }

    protected Rectangle backwardMapRect(Rectangle arg0, int arg1) {
        return arg0;
    }

    protected Rectangle forwardMapRect(Rectangle arg0, int arg1) {
        return arg0;
    }

    public static enum Transform {
        AFFINE{

            @Override
            public void transform(AffineTransform tr, Point2D src, Point2D dst) {
                tr.transform(src, dst);
            }
        }
        ,
        IDENTITY{

            @Override
            public void transform(AffineTransform tr, Point2D src, Point2D dst) {
                dst.setLocation(src);
            }
        }
        ,
        TRANSLATION{

            @Override
            public void transform(AffineTransform tr, Point2D src, Point2D dst) {
                dst.setLocation(src.getX() + tr.getTranslateX(), src.getY() + tr.getTranslateY());
            }
        };


        public abstract void transform(AffineTransform var1, Point2D var2, Point2D var3);

        public static Transform getTransform(AffineTransform tr) {
            if (tr.isIdentity() || Math.abs(tr.getScaleX() - 1.0) == 0.0 && Math.abs(tr.getScaleY() - 1.0) == 0.0 && Math.abs(tr.getShearX()) == 0.0 && Math.abs(tr.getShearY()) == 0.0 && Math.abs(tr.getTranslateX()) <= 0.001 && Math.abs(tr.getTranslateY()) <= 0.001) {
                return IDENTITY;
            }
            if (Math.abs(tr.getScaleX() - 1.0) == 0.0 && Math.abs(tr.getScaleY() - 1.0) == 0.0 && Math.abs(tr.getShearX()) == 0.0 && Math.abs(tr.getShearY()) == 0.0) {
                return TRANSLATION;
            }
            return AFFINE;
        }
    }
}

