/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.function;

import java.util.List;
import java.util.Map;
import org.geotools.api.coverage.grid.GridCoverageReader;
import org.geotools.api.coverage.grid.GridGeometry;
import org.geotools.api.data.Parameter;
import org.geotools.api.data.Query;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.filter.function.RenderingTransformation;
import org.geotools.process.ProcessException;
import org.geotools.process.RenderingProcess;
import org.geotools.process.function.ProcessFunction;

class RenderingProcessFunction
extends ProcessFunction
implements RenderingTransformation {
    public RenderingProcessFunction(Name processName, List<Expression> inputExpressions, Map<String, Parameter<?>> parameters, RenderingProcess process, Literal fallbackValue) {
        super(processName, inputExpressions, parameters, process, fallbackValue);
    }

    @Override
    public Query invertQuery(Query targetQuery, GridGeometry gridGeometry) {
        RenderingProcess process = (RenderingProcess)this.process;
        Map<String, Object> inputs = this.evaluateInputs(null);
        try {
            return process.invertQuery(inputs, targetQuery, gridGeometry);
        }
        catch (ProcessException e) {
            throw new RuntimeException("Failed to invert the query, error is: " + e.getMessage(), e);
        }
    }

    @Override
    public GridGeometry invertGridGeometry(Query targetQuery, GridGeometry targetGridGeometry) {
        RenderingProcess process = (RenderingProcess)this.process;
        Map<String, Object> inputs = this.evaluateInputs(null);
        try {
            return process.invertGridGeometry(inputs, targetQuery, targetGridGeometry);
        }
        catch (ProcessException e) {
            throw new RuntimeException("Failed to invert the grid geometry, error is: " + e.getMessage(), e);
        }
    }

    @Override
    public GeneralParameterValue[] customizeReadParams(GridCoverageReader reader, GeneralParameterValue ... params) {
        RenderingProcess process = (RenderingProcess)this.process;
        Map<String, Object> inputs = this.evaluateInputs(null);
        try {
            return process.customizeReadParams(inputs, reader, params);
        }
        catch (ProcessException e) {
            throw new RuntimeException("Failed to customize the reader parameters, error is: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean clipOnRenderingArea() {
        RenderingProcess process = (RenderingProcess)this.process;
        Map<String, Object> inputs = this.evaluateInputs(null);
        try {
            return process.clipOnRenderingArea(inputs);
        }
        catch (ProcessException e) {
            throw new RuntimeException("Failed to customize the reader parameters, error is: " + e.getMessage(), e);
        }
    }
}

