/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service.wmts;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geotools.util.logging.Logging;
import org.geowebcache.config.legends.LegendInfo;
import org.geowebcache.config.legends.LegendInfoBuilder;
import org.geowebcache.config.meta.ServiceContact;
import org.geowebcache.config.meta.ServiceInformation;
import org.geowebcache.config.meta.ServiceProvider;
import org.geowebcache.conveyor.Conveyor;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.grid.Grid;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.SRS;
import org.geowebcache.io.XMLBuilder;
import org.geowebcache.layer.TileJSONProvider;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.layer.meta.LayerMetaInformation;
import org.geowebcache.layer.meta.MetadataURL;
import org.geowebcache.mime.ApplicationMime;
import org.geowebcache.service.wmts.WMTSExtension;
import org.geowebcache.service.wmts.WMTSUtils;
import org.geowebcache.stats.RuntimeStats;
import org.geowebcache.util.ServletUtils;
import org.geowebcache.util.URLMangler;

public class WMTSGetCapabilities {
    private static Logger log = Logging.getLogger((String)WMTSGetCapabilities.class.getName());
    private TileLayerDispatcher tld;
    private GridSetBroker gsb;
    private String baseUrl;
    private String restBaseUrl;
    private final Collection<WMTSExtension> extensions;

    protected WMTSGetCapabilities(TileLayerDispatcher tld, GridSetBroker gsb, HttpServletRequest servReq, String baseUrl, String contextPath, URLMangler urlMangler) {
        this(tld, gsb, servReq, baseUrl, contextPath, urlMangler, Collections.emptyList());
    }

    protected WMTSGetCapabilities(TileLayerDispatcher tld, GridSetBroker gsb, HttpServletRequest servReq, String baseUrl, String contextPath, URLMangler urlMangler, Collection<WMTSExtension> extensions) {
        this.tld = tld;
        this.gsb = gsb;
        String forcedBaseUrl = ServletUtils.stringFromMap((Map)servReq.getParameterMap(), (String)servReq.getCharacterEncoding(), (String)"base_url");
        this.baseUrl = forcedBaseUrl != null ? forcedBaseUrl : urlMangler.buildURL(baseUrl, contextPath, "/service/wmts");
        this.restBaseUrl = urlMangler.buildURL(baseUrl, contextPath, "/service/wmts/rest");
        this.extensions = extensions;
    }

    protected void writeResponse(HttpServletResponse response, RuntimeStats stats) {
        Charset encoding = StandardCharsets.UTF_8;
        byte[] data = this.generateGetCapabilities(encoding).getBytes(encoding);
        response.setStatus(200);
        response.setContentType("text/xml");
        response.setCharacterEncoding(encoding.name());
        response.setContentLength(data.length);
        response.setHeader("content-disposition", "inline;filename=wmts-getcapabilities.xml");
        stats.log(data.length, Conveyor.CacheResult.OTHER);
        try (ServletOutputStream os = response.getOutputStream();){
            os.write(data);
            os.flush();
        }
        catch (IOException ioe) {
            log.fine("Caught IOException" + ioe.getMessage());
        }
    }

    private String generateGetCapabilities(Charset encoding) {
        StringBuilder str = new StringBuilder();
        XMLBuilder xml = new XMLBuilder((Appendable)str);
        try {
            xml.header("1.0", encoding);
            xml.indentElement("Capabilities");
            xml.attribute("xmlns", "http://www.opengis.net/wmts/1.0");
            xml.attribute("xmlns:ows", "http://www.opengis.net/ows/1.1");
            xml.attribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
            xml.attribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            xml.attribute("xmlns:gml", "http://www.opengis.net/gml");
            for (WMTSExtension wMTSExtension : this.extensions) {
                wMTSExtension.registerNamespaces(xml);
            }
            StringBuilder schemasLocations = new StringBuilder("http://www.opengis.net/wmts/1.0 ");
            schemasLocations.append("http://schemas.opengis.net/wmts/1.0/wmtsGetCapabilities_response.xsd ");
            for (WMTSExtension extension : this.extensions) {
                for (String schemaLocation : extension.getSchemaLocations()) {
                    schemasLocations.append(schemaLocation).append(" ");
                }
            }
            schemasLocations.delete(schemasLocations.length() - 1, schemasLocations.length());
            xml.attribute("xsi:schemaLocation", schemasLocations.toString());
            xml.attribute("version", "1.0.0");
            ServiceInformation serviceInformation = this.getServiceInformation();
            this.serviceIdentification(xml, serviceInformation);
            this.serviceProvider(xml, serviceInformation);
            this.operationsMetadata(xml);
            this.contents(xml);
            xml.indentElement("ServiceMetadataURL").attribute("xlink:href", WMTSUtils.getKvpServiceMetadataURL(this.baseUrl)).endElement();
            xml.indentElement("ServiceMetadataURL").attribute("xlink:href", this.restBaseUrl + "/WMTSCapabilities.xml").endElement();
            xml.endElement("Capabilities");
            return str.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private ServiceInformation getServiceInformation() {
        ServiceInformation servInfo = this.tld.getServiceInformation();
        for (WMTSExtension extension : this.extensions) {
            ServiceInformation serviceInformation = extension.getServiceInformation();
            if (serviceInformation == null) continue;
            if (servInfo == null) {
                servInfo = new ServiceInformation();
            }
            this.mergeServiceInformation(servInfo, serviceInformation);
        }
        return servInfo;
    }

    private void mergeServiceInformation(ServiceInformation serviceA, ServiceInformation serviceB) {
        if (serviceB.getTitle() != null) {
            serviceA.setTitle(serviceB.getTitle());
        }
        if (serviceB.getDescription() != null) {
            serviceA.setDescription(serviceB.getDescription());
        }
        if (serviceB.getKeywords() != null) {
            serviceA.getKeywords().addAll(serviceB.getKeywords());
        }
        if (serviceB.getServiceProvider() != null) {
            serviceA.setServiceProvider(serviceB.getServiceProvider());
        }
        if (serviceB.getFees() != null) {
            serviceA.setFees(serviceB.getFees());
        }
        if (serviceB.getAccessConstraints() != null) {
            serviceA.setAccessConstraints(serviceB.getAccessConstraints());
        }
        if (serviceB.getProviderName() != null) {
            serviceA.setProviderName(serviceB.getProviderName());
        }
        if (serviceB.getProviderSite() != null) {
            serviceA.setProviderSite(serviceB.getProviderSite());
        }
        if (serviceB.getServiceProvider() != null) {
            if (serviceA.getServiceProvider() != null) {
                this.mergeProviderInformation(serviceA.getServiceProvider(), serviceB.getServiceProvider());
            } else {
                serviceA.setServiceProvider(serviceB.getServiceProvider());
            }
        }
    }

    private void mergeProviderInformation(ServiceProvider providerA, ServiceProvider providerB) {
        if (providerB.getProviderName() != null) {
            providerA.setProviderName(providerB.getProviderName());
        }
        if (providerB.getProviderSite() != null) {
            providerA.setProviderSite(providerB.getProviderSite());
        }
        if (providerB.getServiceContact() != null) {
            if (providerA.getServiceContact() != null) {
                this.mergeContactInformation(providerA.getServiceContact(), providerB.getServiceContact());
            } else {
                providerA.setServiceContact(providerB.getServiceContact());
            }
        }
    }

    private void mergeContactInformation(ServiceContact contactA, ServiceContact contactB) {
        if (contactB.getIndividualName() != null) {
            contactA.setIndividualName(contactB.getIndividualName());
        }
        if (contactB.getPositionName() != null) {
            contactA.setPositionName(contactB.getPositionName());
        }
        if (contactB.getAddressType() != null) {
            contactA.setAddressType(contactB.getAddressType());
        }
        if (contactB.getAddressStreet() != null) {
            contactA.setAddressStreet(contactB.getAddressStreet());
        }
        if (contactB.getAddressCity() != null) {
            contactA.setAddressCity(contactB.getAddressCity());
        }
        if (contactB.getAddressAdministrativeArea() != null) {
            contactA.setAddressAdministrativeArea(contactB.getAddressAdministrativeArea());
        }
        if (contactB.getAddressPostalCode() != null) {
            contactA.setAddressPostalCode(contactB.getAddressPostalCode());
        }
        if (contactB.getAddressCountry() != null) {
            contactA.setAddressCountry(contactB.getAddressCountry());
        }
        if (contactB.getPhoneNumber() != null) {
            contactA.setPhoneNumber(contactB.getPhoneNumber());
        }
        if (contactB.getFaxNumber() != null) {
            contactA.setFaxNumber(contactB.getFaxNumber());
        }
        if (contactB.getAddressEmail() != null) {
            contactA.setAddressEmail(contactB.getAddressEmail());
        }
    }

    private void serviceIdentification(XMLBuilder xml, ServiceInformation servInfo) throws IOException {
        xml.indentElement("ows:ServiceIdentification");
        if (servInfo != null) {
            this.appendTag(xml, "ows:Title", servInfo.getTitle(), "Web Map Tile Service - GeoWebCache");
            this.appendTag(xml, "ows:Abstract", servInfo.getDescription(), null);
            if (servInfo != null && servInfo.getKeywords() != null && !servInfo.getKeywords().isEmpty()) {
                xml.indentElement("ows:Keywords");
                Iterator keywordIter = servInfo.getKeywords().iterator();
                while (keywordIter.hasNext()) {
                    this.appendTag(xml, "ows:Keyword", (String)keywordIter.next(), null);
                }
                xml.endElement();
            }
        } else {
            xml.simpleElement("ows:Title", "Web Map Tile Service - GeoWebCache", true);
        }
        xml.simpleElement("ows:ServiceType", "OGC WMTS", true);
        xml.simpleElement("ows:ServiceTypeVersion", "1.0.0", true);
        if (servInfo != null) {
            this.appendTag(xml, "ows:Fees", servInfo.getFees(), null);
            this.appendTag(xml, "ows:AccessConstraints", servInfo.getAccessConstraints(), null);
        }
        xml.endElement("ows:ServiceIdentification");
    }

    private void serviceProvider(XMLBuilder xml, ServiceInformation servInfo) throws IOException {
        ServiceProvider servProv = null;
        if (servInfo != null) {
            servProv = servInfo.getServiceProvider();
        }
        xml.indentElement("ows:ServiceProvider");
        if (servProv != null) {
            ServiceContact servCont;
            this.appendTag(xml, "ows:ProviderName", servProv.getProviderName(), null);
            if (servProv.getProviderSite() != null) {
                xml.indentElement("ows:ProviderSite").attribute("xlink:href", servProv.getProviderSite()).endElement();
            }
            if ((servCont = servProv.getServiceContact()) != null) {
                xml.indentElement("ows:ServiceContact");
                this.appendTag(xml, "ows:IndividualName", servCont.getIndividualName(), null);
                this.appendTag(xml, "ows:PositionName", servCont.getPositionName(), null);
                xml.indentElement("ows:ContactInfo");
                if (servCont.getPhoneNumber() != null || servCont.getFaxNumber() != null) {
                    xml.indentElement("ows:Phone");
                    this.appendTag(xml, "ows:Voice", servCont.getPhoneNumber(), null);
                    this.appendTag(xml, "ows:Facsimile", servCont.getFaxNumber(), null);
                    xml.endElement();
                }
                xml.indentElement("ows:Address");
                this.appendTag(xml, "ows:DeliveryPoint", servCont.getAddressStreet(), null);
                this.appendTag(xml, "ows:City", servCont.getAddressCity(), null);
                this.appendTag(xml, "ows:AdministrativeArea", servCont.getAddressAdministrativeArea(), null);
                this.appendTag(xml, "ows:PostalCode", servCont.getAddressPostalCode(), null);
                this.appendTag(xml, "ows:Country", servCont.getAddressCountry(), null);
                this.appendTag(xml, "ows:ElectronicMailAddress", servCont.getAddressEmail(), null);
                xml.endElement("ows:Address");
                xml.endElement();
                xml.endElement();
            }
        } else {
            this.appendTag(xml, "ows:ProviderName", this.baseUrl, null);
            xml.indentElement("ows:ProviderSite").attribute("xlink:href", this.baseUrl).endElement();
            xml.indentElement("ows:ServiceContact");
            this.appendTag(xml, "ows:IndividualName", "GeoWebCache User", null);
            xml.endElement();
        }
        xml.endElement("ows:ServiceProvider");
    }

    private void operationsMetadata(XMLBuilder xml) throws IOException {
        xml.indentElement("ows:OperationsMetadata");
        this.operation(xml, "GetCapabilities", this.baseUrl);
        this.operation(xml, "GetTile", this.baseUrl);
        this.operation(xml, "GetFeatureInfo", this.baseUrl);
        for (WMTSExtension extension : this.extensions) {
            List<WMTSExtension.OperationMetadata> operationsMetaData = extension.getExtraOperationsMetadata();
            if (operationsMetaData != null) {
                for (WMTSExtension.OperationMetadata operationMetadata : operationsMetaData) {
                    this.operation(xml, operationMetadata.getName(), operationMetadata.getBaseUrl() == null ? this.baseUrl : operationMetadata.getBaseUrl());
                }
            }
            extension.encodedOperationsMetadata(xml);
        }
        xml.endElement("ows:OperationsMetadata");
    }

    private void operation(XMLBuilder xml, String operationName, String baseUrl) throws IOException {
        xml.indentElement("ows:Operation").attribute("name", operationName);
        xml.indentElement("ows:DCP");
        xml.indentElement("ows:HTTP");
        if (baseUrl.contains("?")) {
            xml.indentElement("ows:Get").attribute("xlink:href", baseUrl + "&");
        } else {
            xml.indentElement("ows:Get").attribute("xlink:href", baseUrl + "?");
        }
        xml.indentElement("ows:Constraint").attribute("name", "GetEncoding");
        xml.indentElement("ows:AllowedValues");
        xml.simpleElement("ows:Value", "KVP", true);
        xml.endElement();
        xml.endElement();
        xml.endElement();
        xml.endElement();
        xml.endElement();
        xml.endElement("ows:Operation");
    }

    private void contents(XMLBuilder xml) throws IOException {
        xml.indentElement("Contents");
        Iterable iter = this.tld.getLayerListFiltered();
        HashSet<GridSet> usedGridsets = new HashSet<GridSet>();
        for (TileLayer layer : iter) {
            if (!layer.isEnabled() || !layer.isAdvertised()) continue;
            this.layer(xml, layer, this.baseUrl, usedGridsets);
        }
        ArrayList<GridSet> capabilitiesGridsets = new ArrayList<GridSet>(this.gsb.getGridSets());
        capabilitiesGridsets.retainAll(usedGridsets);
        capabilitiesGridsets.sort(Comparator.comparing(GridSet::getName));
        for (GridSet gset : capabilitiesGridsets) {
            this.tileMatrixSet(xml, gset);
        }
        xml.endElement("Contents");
    }

    private void layer(XMLBuilder xml, TileLayer layer, String baseurl, Set<GridSet> usedGridsets) throws IOException {
        xml.indentElement("Layer");
        LayerMetaInformation layerMeta = layer.getMetaInformation();
        if (layerMeta == null) {
            this.appendTag(xml, "ows:Title", layer.getName(), null);
        } else {
            this.appendTag(xml, "ows:Title", layerMeta.getTitle(), null);
            this.appendTag(xml, "ows:Abstract", layerMeta.getDescription(), null);
        }
        this.layerWGS84BoundingBox(xml, layer);
        this.appendTag(xml, "ows:Identifier", layer.getName(), null);
        if (layer.getMetadataURLs() != null) {
            for (MetadataURL metadataURL : layer.getMetadataURLs()) {
                xml.indentElement("ows:Metadata").attribute("xlink:type", "simple").attribute("xlink:href", metadataURL.getUrl().toString()).endElement();
            }
        }
        List filters = layer.getParameterFilters();
        this.layerStyles(xml, layer, filters);
        this.layerFormats(xml, layer);
        this.layerInfoFormats(xml, layer);
        if (filters != null) {
            this.layerDimensions(xml, layer, filters);
        }
        this.layerGridSubSets(xml, layer, usedGridsets);
        this.layerResourceUrls(xml, layer, filters, this.restBaseUrl);
        for (WMTSExtension extension : this.extensions) {
            extension.encodeLayer(xml, layer);
        }
        xml.endElement("Layer");
    }

    private void layerWGS84BoundingBox(XMLBuilder xml, TileLayer layer) throws IOException {
        GridSubset subset = layer.getGridSubsetForSRS(SRS.getEPSG4326());
        if (subset != null) {
            double[] coords = subset.getOriginalExtent().getCoords();
            xml.indentElement("ows:WGS84BoundingBox");
            xml.simpleElement("ows:LowerCorner", coords[0] + " " + coords[1], true);
            xml.simpleElement("ows:UpperCorner", coords[2] + " " + coords[3], true);
            xml.endElement("ows:WGS84BoundingBox");
            return;
        }
        subset = layer.getGridSubsetForSRS(SRS.getEPSG900913());
        if (subset != null) {
            double[] coords = subset.getOriginalExtent().getCoords();
            double originShift = 2.0037508342789244E7;
            double mx = coords[0];
            double my = coords[1];
            double lon = mx / originShift * 180.0;
            double lat = my / originShift * 180.0;
            lat = 57.29577951308232 * (2.0 * Math.atan(Math.exp(lat * Math.PI / 180.0)) - 1.5707963267948966);
            xml.indentElement("ows:WGS84BoundingBox");
            xml.simpleElement("ows:LowerCorner", lon + " " + lat, true);
            mx = coords[2];
            my = coords[3];
            lon = mx / originShift * 180.0;
            lat = my / originShift * 180.0;
            lat = 57.29577951308232 * (2.0 * Math.atan(Math.exp(lat * Math.PI / 180.0)) - 1.5707963267948966);
            xml.simpleElement("ows:UpperCorner", lon + " " + lat, true);
            xml.endElement("ows:WGS84BoundingBox");
        }
    }

    private Map<String, LegendInfo> getLegendsInfo(TileLayer layer) {
        HashMap<String, LegendInfo> legendsInfo = new HashMap<String, LegendInfo>();
        for (Map.Entry entry : layer.getLayerLegendsInfo().entrySet()) {
            String styleName = (String)entry.getKey();
            LegendInfo legend = (LegendInfo)entry.getValue();
            legendsInfo.put(styleName, new LegendInfoBuilder().withWidth(legend.getWidth()).withHeight(legend.getHeight()).withFormat(legend.getFormat()).withCompleteUrl(legend.getLegendUrl()).withStyleName(styleName).build());
        }
        legendsInfo.putAll(layer.getLayerLegendsInfo());
        return legendsInfo;
    }

    private void layerStyles(XMLBuilder xml, TileLayer layer, List<ParameterFilter> filters) throws IOException {
        String defStyle = layer.getStyles();
        Map<String, LegendInfo> legendsInfo = this.getLegendsInfo(layer);
        if (filters == null) {
            xml.indentElement("Style");
            xml.attribute("isDefault", "true");
            if (defStyle == null) {
                xml.simpleElement("ows:Identifier", "", true);
            } else {
                xml.simpleElement("ows:Identifier", TileLayer.encodeDimensionValue((String)defStyle), true);
            }
            this.encodeStyleLegendGraphic(xml, legendsInfo.get(defStyle));
            xml.endElement("Style");
        } else {
            ParameterFilter stylesFilter = null;
            Iterator<ParameterFilter> iter = filters.iterator();
            while (stylesFilter == null && iter.hasNext()) {
                ParameterFilter filter = iter.next();
                if (!filter.getKey().equalsIgnoreCase("STYLES")) continue;
                stylesFilter = filter;
            }
            List legalStyles = null;
            if (stylesFilter != null) {
                legalStyles = stylesFilter.getLegalValues();
            }
            if (legalStyles != null && !legalStyles.isEmpty()) {
                String defVal = stylesFilter.getDefaultValue();
                if (defVal == null) {
                    defVal = defStyle != null ? defStyle : "";
                }
                for (String value : legalStyles) {
                    xml.indentElement("Style");
                    if (value.equals(defVal)) {
                        xml.attribute("isDefault", "true");
                    }
                    xml.simpleElement("ows:Identifier", TileLayer.encodeDimensionValue((String)value), true);
                    this.encodeStyleLegendGraphic(xml, legendsInfo.get(value));
                    xml.endElement();
                }
            } else {
                xml.indentElement("Style");
                xml.attribute("isDefault", "true");
                xml.simpleElement("ows:Identifier", "", true);
                if (defStyle != null) {
                    this.encodeStyleLegendGraphic(xml, legendsInfo.get(defStyle));
                }
                xml.endElement();
            }
        }
    }

    private void encodeStyleLegendGraphic(XMLBuilder xml, LegendInfo legendInfo) throws IOException {
        if (legendInfo == null) {
            return;
        }
        xml.indentElement("LegendURL");
        Preconditions.checkNotNull((Object)legendInfo.getFormat(), (Object)"Legend format is mandatory in WMTS.");
        Preconditions.checkNotNull((Object)legendInfo.getLegendUrl(), (Object)"Legend URL is mandatory in WMTS.");
        xml.attribute("format", legendInfo.getFormat());
        xml.attribute("xlink:href", legendInfo.getLegendUrl());
        if (legendInfo.getWidth() != null) {
            xml.attribute("width", String.valueOf(legendInfo.getWidth()));
        }
        if (legendInfo.getHeight() != null) {
            xml.attribute("height", String.valueOf(legendInfo.getHeight()));
        }
        if (legendInfo.getMinScale() != null) {
            xml.attribute("minScaleDenominator", String.valueOf(legendInfo.getMinScale()));
        }
        if (legendInfo.getMaxScale() != null) {
            xml.attribute("maxScaleDenominator", String.valueOf(legendInfo.getMaxScale()));
        }
        xml.endElement("LegendURL");
    }

    private void layerFormats(XMLBuilder xml, TileLayer layer) throws IOException {
        List<String> mimeFormats = WMTSUtils.getLayerFormats(layer);
        for (String format : mimeFormats) {
            xml.simpleElement("Format", format, true);
        }
    }

    private void layerInfoFormats(XMLBuilder xml, TileLayer layer) throws IOException {
        if (layer.isQueryable()) {
            List<String> infoFormats = WMTSUtils.getInfoFormats(layer);
            for (String format : infoFormats) {
                xml.simpleElement("InfoFormat", format, true);
            }
        }
    }

    private void layerDimensions(XMLBuilder xml, TileLayer layer, List<ParameterFilter> filters) throws IOException {
        List<ParameterFilter> layerDimensions = WMTSUtils.getLayerDimensions(filters);
        for (ParameterFilter dimension : layerDimensions) {
            this.dimensionDescription(xml, dimension, dimension.getLegalValues());
        }
    }

    private void dimensionDescription(XMLBuilder xml, ParameterFilter filter, List<String> values) throws IOException {
        xml.indentElement("Dimension");
        xml.simpleElement("ows:Identifier", filter.getKey(), false);
        String defaultStr = TileLayer.encodeDimensionValue((String)filter.getDefaultValue());
        xml.simpleElement("Default", defaultStr, false);
        Iterator<String> iter = values.iterator();
        while (iter.hasNext()) {
            String value = TileLayer.encodeDimensionValue((String)iter.next());
            xml.simpleElement("Value", value, false);
        }
        xml.endElement("Dimension");
    }

    private void layerGridSubSets(XMLBuilder xml, TileLayer layer, Set<GridSet> usedGridSets) throws IOException {
        for (String gridSetId : layer.getGridSubsets()) {
            GridSubset gridSubset = layer.getGridSubset(gridSetId);
            xml.indentElement("TileMatrixSetLink");
            xml.simpleElement("TileMatrixSet", gridSubset.getName(), true);
            usedGridSets.add(gridSubset.getGridSet());
            if (!gridSubset.fullGridSetCoverage()) {
                String[] levelNames = gridSubset.getGridNames();
                long[][] wmtsLimits = gridSubset.getWMTSCoverages();
                xml.indentElement("TileMatrixSetLimits");
                for (int i = 0; i < levelNames.length; ++i) {
                    xml.indentElement("TileMatrixLimits");
                    xml.simpleElement("TileMatrix", levelNames[i], true);
                    xml.simpleElement("MinTileRow", Long.toString(wmtsLimits[i][1]), true);
                    xml.simpleElement("MaxTileRow", Long.toString(wmtsLimits[i][3]), true);
                    xml.simpleElement("MinTileCol", Long.toString(wmtsLimits[i][0]), true);
                    xml.simpleElement("MaxTileCol", Long.toString(wmtsLimits[i][2]), true);
                    xml.endElement();
                }
                xml.endElement();
            }
            xml.endElement("TileMatrixSetLink");
        }
    }

    private void layerResourceUrls(XMLBuilder xml, TileLayer layer, List<ParameterFilter> filters, String baseurl) throws IOException {
        String baseTemplate = baseurl + "/" + layer.getName();
        String commonTemplate = baseTemplate + "/{style}/{TileMatrixSet}/{TileMatrix}/{TileRow}/{TileCol}";
        Object commonDimensions = "";
        List<ParameterFilter> layerDimensions = WMTSUtils.getLayerDimensions(filters);
        if (!layerDimensions.isEmpty()) {
            commonDimensions = "&" + layerDimensions.stream().map(d -> d.getKey() + "={" + d.getKey() + "}").collect(Collectors.joining("&"));
        }
        List<String> mimeFormats = WMTSUtils.getLayerFormats(layer);
        for (String string : mimeFormats) {
            String template = commonTemplate + "?format=" + string + (String)commonDimensions;
            this.layerResourceUrlsGen(xml, string, "tile", template);
        }
        List<String> infoFormats = WMTSUtils.getInfoFormats(layer);
        for (String format : infoFormats) {
            String template = commonTemplate + "/{J}/{I}?format=" + format + (String)commonDimensions;
            this.layerResourceUrlsGen(xml, format, "FeatureInfo", template);
        }
        if (layer instanceof TileJSONProvider) {
            TileJSONProvider tileJSONProvider = (TileJSONProvider)layer;
            List<String> formatExtensions = WMTSUtils.getLayerFormatsExtensions(layer);
            String outputFormat = ApplicationMime.json.getFormat();
            if (tileJSONProvider.supportsTileJSON()) {
                for (String tileJsonFormat : formatExtensions) {
                    String template = baseTemplate + "/{style}/tilejson/" + tileJsonFormat + "?format=" + outputFormat;
                    this.layerResourceUrlsGen(xml, outputFormat, "TileJSON", template);
                }
            }
        }
    }

    private void layerResourceUrlsGen(XMLBuilder xml, String format, String type, String template) throws IOException {
        xml.indentElement("ResourceURL");
        xml.attribute("format", format);
        xml.attribute("resourceType", type);
        xml.attribute("template", template);
        xml.endElement("ResourceURL");
    }

    private void tileMatrixSet(XMLBuilder xml, GridSet gridSet) throws IOException {
        xml.indentElement("TileMatrixSet");
        xml.simpleElement("ows:Identifier", gridSet.getName(), true);
        xml.simpleElement("ows:SupportedCRS", "urn:ogc:def:crs:EPSG::" + gridSet.getSrs().getNumber(), true);
        for (int i = 0; i < gridSet.getNumLevels(); ++i) {
            double[] tlCoordinates = gridSet.getOrderedTopLeftCorner(i);
            this.tileMatrix(xml, gridSet.getGrid(i), tlCoordinates, gridSet.getTileWidth(), gridSet.getTileHeight(), gridSet.isScaleWarning());
        }
        xml.endElement("TileMatrixSet");
    }

    private void tileMatrix(XMLBuilder xml, Grid grid, double[] tlCoordinates, int tileWidth, int tileHeight, boolean scaleWarning) throws IOException {
        xml.indentElement("TileMatrix");
        if (scaleWarning) {
            xml.simpleElement("ows:Abstract", "The grid was not well-defined, the scale therefore assumes 1m per map unit.", true);
        }
        xml.simpleElement("ows:Identifier", grid.getName(), true);
        xml.simpleElement("ScaleDenominator", Double.toString(grid.getScaleDenominator()), true);
        xml.indentElement("TopLeftCorner").text(Double.toString(tlCoordinates[0])).text(" ").text(Double.toString(tlCoordinates[1])).endElement();
        xml.simpleElement("TileWidth", Integer.toString(tileWidth), true);
        xml.simpleElement("TileHeight", Integer.toString(tileHeight), true);
        xml.simpleElement("MatrixWidth", Long.toString(grid.getNumTilesWide()), true);
        xml.simpleElement("MatrixHeight", Long.toString(grid.getNumTilesHigh()), true);
        xml.endElement("TileMatrix");
    }

    private void appendTag(XMLBuilder xml, String tagName, String value, String defaultValue) throws IOException {
        if (value == null) {
            if (defaultValue == null) {
                return;
            }
            value = defaultValue;
        }
        xml.simpleElement(tagName, value, true);
    }
}

