/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service.wmts;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geowebcache.GeoWebCacheDispatcher;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.GeoWebCacheExtensions;
import org.geowebcache.config.ServerConfiguration;
import org.geowebcache.conveyor.Conveyor;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.filter.parameters.ParameterException;
import org.geowebcache.filter.security.SecurityDispatcher;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.OutsideCoverageException;
import org.geowebcache.layer.TileJSONProvider;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.geowebcache.service.HttpErrorCodeException;
import org.geowebcache.service.OWSException;
import org.geowebcache.service.Service;
import org.geowebcache.service.wmts.WMTSExtension;
import org.geowebcache.service.wmts.WMTSGetCapabilities;
import org.geowebcache.service.wmts.WMTSGetFeatureInfo;
import org.geowebcache.service.wmts.WMTSTileJSON;
import org.geowebcache.stats.RuntimeStats;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.util.NullURLMangler;
import org.geowebcache.util.ServletUtils;
import org.geowebcache.util.URLMangler;
import org.springframework.http.MediaType;

public class WMTSService
extends Service {
    public static final String SERVICE_WMTS = "wmts";
    public static final String SERVICE_PATH = "/service/wmts";
    public static final String REST_PATH = "/service/wmts/rest";
    public static final String GET_CAPABILITIES = "getcapabilities";
    public static final String GET_FEATUREINFO = "getfeatureinfo";
    public static final String GET_TILE = "gettile";
    public static final String GET_TILEJSON = "gettilejson";
    private static final String STYLE_HINT = ";style=";
    private StorageBroker sb;
    private TileLayerDispatcher tld;
    private GridSetBroker gsb;
    private RuntimeStats stats;
    private URLMangler urlMangler = new NullURLMangler();
    private GeoWebCacheDispatcher controller = null;
    private ServerConfiguration mainConfiguration;
    private final List<WMTSExtension> extensions = new ArrayList<WMTSExtension>();
    private SecurityDispatcher securityDispatcher;

    static final String buildRestPattern(int numPathElements, boolean hasStyle) {
        if (!hasStyle) {
            return ".*/service/wmts/rest" + Strings.repeat((String)"/([^/]+)", (int)numPathElements);
        }
        return ".*/service/wmts/rest/([^/]+)/([^/]*)" + Strings.repeat((String)"/([^/]+)", (int)(numPathElements - 2));
    }

    protected WMTSService() {
        super(SERVICE_WMTS);
        this.extensions.addAll(GeoWebCacheExtensions.extensions(WMTSExtension.class));
    }

    public WMTSService(StorageBroker sb, TileLayerDispatcher tld, GridSetBroker gsb, RuntimeStats stats) {
        super(SERVICE_WMTS);
        this.sb = sb;
        this.tld = tld;
        this.gsb = gsb;
        this.stats = stats;
        this.extensions.addAll(GeoWebCacheExtensions.extensions(WMTSExtension.class));
    }

    public WMTSService(StorageBroker sb, TileLayerDispatcher tld, GridSetBroker gsb, RuntimeStats stats, URLMangler urlMangler, GeoWebCacheDispatcher controller) {
        super(SERVICE_WMTS);
        this.sb = sb;
        this.tld = tld;
        this.gsb = gsb;
        this.stats = stats;
        this.urlMangler = urlMangler;
        this.controller = controller;
        this.extensions.addAll(GeoWebCacheExtensions.extensions(WMTSExtension.class));
    }

    public Conveyor getConveyor(HttpServletRequest request, HttpServletResponse response) throws GeoWebCacheException, OWSException {
        for (WMTSExtension extension : this.extensions) {
            Conveyor conveyor = extension.getConveyor(request, response, this.sb);
            if (conveyor == null) continue;
            return conveyor;
        }
        if (request.getPathInfo() != null && request.getPathInfo().contains("service/wmts/rest")) {
            return this.getRestConveyor(request, response);
        }
        String[] keys = new String[]{"layer", "request", "style", "format", "infoformat", "tilematrixset", "tilematrix", "tilerow", "tilecol", "tileformat", "i", "j"};
        String encoding = request.getCharacterEncoding();
        Map values = ServletUtils.selectedStringsFromMap((Map)request.getParameterMap(), (String)encoding, (String[])keys);
        return this.getKvpConveyor(request, response, values);
    }

    public Conveyor getRestConveyor(HttpServletRequest request, HttpServletResponse response) throws GeoWebCacheException, OWSException {
        String path;
        String accept = request.getHeader("Accept");
        if (accept != null) {
            List mediaTypes = MediaType.parseMediaTypes((String)accept);
            boolean representationAvailable = false;
            for (MediaType mediaType : mediaTypes) {
                if (!mediaType.includes(MediaType.APPLICATION_XML)) continue;
                representationAvailable = true;
                break;
            }
            if (!representationAvailable) {
                throw new HttpErrorCodeException(406, "Representation not available");
            }
        }
        if ((path = request.getPathInfo()).endsWith("/service/wmts/rest/WMTSCapabilities.xml")) {
            ConveyorTile tile = new ConveyorTile(this.sb, null, request, response);
            tile.setHint(GET_CAPABILITIES);
            tile.setRequestHandler(Conveyor.RequestHandler.SERVICE);
            return tile;
        }
        for (RestRequest restRequest : RestRequest.values()) {
            Map<String, String> values = restRequest.toKVP(request);
            if (values == null) continue;
            return this.getKvpConveyor(request, response, values);
        }
        throw new HttpErrorCodeException(404, "Unknown resource " + request.getPathInfo());
    }

    public Conveyor getKvpConveyor(HttpServletRequest request, HttpServletResponse response, Map<String, String> values) throws GeoWebCacheException, OWSException {
        ConveyorTile tile;
        List<String> versions;
        String acceptedVersions;
        String req;
        for (WMTSExtension extension : this.extensions) {
            Conveyor conveyor = extension.getConveyor(request, response, this.sb);
            if (conveyor == null) continue;
            return conveyor;
        }
        boolean isCitecompliant = this.isCiteCompliant();
        if (isCitecompliant) {
            WMTSService.performCiteValidation(request);
        }
        if ((req = values.get("request")) == null) {
            throw new OWSException(400, "MissingParameterValue", "request", "Missing Request parameter");
        }
        req = req.toLowerCase();
        if (isCitecompliant && (acceptedVersions = WMTSService.getParameterValue("AcceptVersions", request)) != null && !(versions = Arrays.asList(acceptedVersions.split("\\s*,\\s*"))).contains("1.0.0")) {
            throw new OWSException(400, "VersionNegotiationFailed", "null", "List of versions in AcceptVersions parameter value, in GetCapabilities operation request, did not include any version supported by this server.");
        }
        if (req.equals(GET_TILE)) {
            boolean isRestRequest;
            if (isCitecompliant && !(isRestRequest = WMTSService.isRestRequest(request)) && WMTSService.getParameterValue("Style", request) == null) {
                throw new OWSException(400, "MissingParameterValue", "Style", "Mandatory Style query parameter not provided.");
            }
            ConveyorTile tile2 = this.getTile(values, request, response, RequestType.TILE);
            return tile2;
        }
        if (req.equals(GET_CAPABILITIES)) {
            tile = new ConveyorTile(this.sb, values.get("layer"), request, response);
            tile.setHint(req);
            tile.setRequestHandler(Conveyor.RequestHandler.SERVICE);
            return tile;
        }
        if (req.equals(GET_FEATUREINFO)) {
            tile = this.getTile(values, request, response, RequestType.FEATUREINFO);
            tile.setHint(req);
            tile.setRequestHandler(Conveyor.RequestHandler.SERVICE);
            return tile;
        }
        if (req.equals(GET_TILEJSON)) {
            tile = new ConveyorTile(this.sb, values.get("layer"), request, response);
            String format = values.get("tileformat");
            tile.setMimeType(MimeType.createFromExtension((String)format));
            Object hint = req;
            String style = values.get("style");
            if (style != null) {
                hint = (String)hint + STYLE_HINT + style;
            }
            tile.setHint((String)hint);
            tile.setRequestHandler(Conveyor.RequestHandler.SERVICE);
            return tile;
        }
        throw new OWSException(400, "InvalidParameterValue", "request", "Invalid request name '%s'.".formatted(req));
    }

    private ConveyorTile getTile(Map<String, String> values, HttpServletRequest request, HttpServletResponse response, RequestType reqType) throws OWSException {
        long[] gridCov;
        String string;
        String format;
        Map filteringParameters;
        String encoding = request.getCharacterEncoding();
        String layer = values.get("layer");
        if (layer == null) {
            throw new OWSException(400, "MissingParameterValue", "LAYER", "Missing LAYER parameter");
        }
        TileLayer tileLayer = null;
        try {
            tileLayer = this.tld.getTileLayer(layer);
        }
        catch (GeoWebCacheException e) {
            throw new OWSException(400, "InvalidParameterValue", "LAYER", "LAYER " + layer + " is not known.");
        }
        HashMap<String, String[]> rawParameters = new HashMap<String, String[]>(request.getParameterMap());
        try {
            for (Map.Entry<String, String> entry : values.entrySet()) {
                rawParameters.put(entry.getKey(), new String[]{entry.getValue()});
            }
            for (Map.Entry<String, String> entry : rawParameters.entrySet()) {
                if (!entry.getKey().equalsIgnoreCase("STYLE")) continue;
                rawParameters.put("STYLES", (String[])entry.getValue());
                break;
            }
            filteringParameters = tileLayer.getModifiableParameters(rawParameters, encoding);
        }
        catch (ParameterException e) {
            throw new OWSException(e.getHttpCode(), e.getExceptionCode(), e.getLocator(), e.getMessage());
        }
        catch (GeoWebCacheException e) {
            throw new OWSException(500, "NoApplicableCode", "", e.getMessage() + " while fetching modifiable parameters for LAYER " + layer);
        }
        MimeType mimeType = null;
        if (reqType == RequestType.TILE) {
            String string2 = values.get("format");
            if (string2 == null) {
                throw new OWSException(400, "MissingParameterValue", "FORMAT", "Unable to determine requested FORMAT, " + string2);
            }
            try {
                mimeType = MimeType.createFromFormat((String)string2);
            }
            catch (MimeException me) {
                throw new OWSException(400, "InvalidParameterValue", "FORMAT", "Unable to determine requested FORMAT, " + string2);
            }
        }
        String string3 = values.get("infoformat");
        if (string3 == null) {
            throw new OWSException(400, "MissingParameterValue", "INFOFORMAT", "Parameter INFOFORMAT was not provided");
        }
        try {
            mimeType = MimeType.createFromFormat((String)string3);
        }
        catch (MimeException me) {
            throw new OWSException(400, "InvalidParameterValue", "INFOFORMAT", "Unable to determine requested INFOFORMAT, " + string3);
        }
        if (this.isCiteCompliant() && !WMTSService.isRestRequest(request) && (format = values.get("format")) == null) {
            throw new OWSException(400, "MissingParameterValue", "FORMAT", "Unable to determine requested FORMAT, " + format);
        }
        if ((string = values.get("tilematrixset")) == null) {
            throw new OWSException(400, "MissingParameterValue", "TILEMATRIXSET", "No TILEMATRIXSET specified");
        }
        GridSubset gridSubset = tileLayer.getGridSubset(string);
        if (gridSubset == null) {
            throw new OWSException(400, "InvalidParameterValue", "TILEMATRIXSET", "Unable to match requested TILEMATRIXSET " + string + " to those supported by layer");
        }
        String tileMatrix = values.get("tilematrix");
        if (tileMatrix == null) {
            throw new OWSException(400, "MissingParameterValue", "TILEMATRIX", "No TILEMATRIX specified");
        }
        long z = gridSubset.getGridIndex(tileMatrix);
        if (z < 0L) {
            throw new OWSException(400, "InvalidParameterValue", "TILEMATRIX", "Unknown TILEMATRIX " + tileMatrix);
        }
        String tileRow = values.get("tilerow");
        if (tileRow == null) {
            throw new OWSException(400, "MissingParameterValue", "TILEROW", "No TILEROW specified");
        }
        long tilesHigh = gridSubset.getNumTilesHigh((int)z);
        long y = tilesHigh - Long.parseLong(tileRow) - 1L;
        String tileCol = values.get("tilecol");
        if (tileCol == null) {
            throw new OWSException(400, "MissingParameterValue", "TILECOL", "No TILECOL specified");
        }
        long x = Long.parseLong(tileCol);
        if (x < (gridCov = gridSubset.getCoverage((int)z))[0] || x > gridCov[2]) {
            throw new OWSException(400, "TileOutOfRange", "TILECOL", "Column " + x + " is out of range, min: " + gridCov[0] + " max:" + gridCov[2]);
        }
        if (y < gridCov[1] || y > gridCov[3]) {
            long minRow = tilesHigh - gridCov[3] - 1L;
            long maxRow = tilesHigh - gridCov[1] - 1L;
            throw new OWSException(400, "TileOutOfRange", "TILEROW", "Row " + tileRow + " is out of range, min: " + minRow + " max:" + maxRow);
        }
        long[] tileIndex = new long[]{x, y, z};
        try {
            gridSubset.checkCoverage(tileIndex);
        }
        catch (OutsideCoverageException outsideCoverageException) {
            // empty catch block
        }
        ConveyorTile convTile = new ConveyorTile(this.sb, layer, gridSubset.getName(), tileIndex, mimeType, rawParameters, filteringParameters, request, response);
        convTile.setTileLayer(tileLayer);
        return convTile;
    }

    public void handleRequest(Conveyor conv) throws OWSException, GeoWebCacheException {
        for (WMTSExtension extension : this.extensions) {
            if (!extension.handleRequest(conv)) continue;
            return;
        }
        ConveyorTile tile = (ConveyorTile)conv;
        String servletPrefix = null;
        if (this.controller != null) {
            servletPrefix = this.controller.getServletPrefix();
        }
        String servletBase = ServletUtils.getServletBaseURL((HttpServletRequest)conv.servletReq, (String)servletPrefix);
        String context = ServletUtils.getServletContextPath((HttpServletRequest)conv.servletReq, (String[])new String[]{SERVICE_PATH, REST_PATH}, (String)servletPrefix);
        if (tile.getHint() != null) {
            if (tile.getHint().equals(GET_CAPABILITIES)) {
                WMTSGetCapabilities wmsGC = new WMTSGetCapabilities(this.tld, this.gsb, tile.servletReq, servletBase, context, this.urlMangler, this.extensions);
                wmsGC.writeResponse(tile.servletResp, this.stats);
            } else if (tile.getHint().equals(GET_FEATUREINFO)) {
                this.getSecurityDispatcher().checkSecurity(tile);
                ConveyorTile convTile = (ConveyorTile)conv;
                WMTSGetFeatureInfo wmsGFI = new WMTSGetFeatureInfo(convTile);
                wmsGFI.writeResponse(this.stats);
            } else if (tile.getHint().startsWith(GET_TILEJSON)) {
                this.getSecurityDispatcher().checkSecurity(tile);
                ConveyorTile convTile = (ConveyorTile)conv;
                TileLayer layer = convTile.getLayer();
                String hint = tile.getHint();
                String style = null;
                int styleIndex = hint.indexOf(STYLE_HINT);
                if (styleIndex != -1) {
                    style = hint.substring(styleIndex + STYLE_HINT.length());
                }
                if (layer instanceof TileJSONProvider) {
                    TileJSONProvider provider = (TileJSONProvider)layer;
                    if (!provider.supportsTileJSON()) {
                        throw new HttpErrorCodeException(404, "TileJSON Not supported");
                    }
                    WMTSTileJSON wmtsTileJSON = new WMTSTileJSON(convTile, servletBase, context, style, this.urlMangler);
                    wmtsTileJSON.writeResponse(layer);
                }
            }
        }
    }

    void addExtension(WMTSExtension extension) {
        this.extensions.add(extension);
    }

    public Collection<WMTSExtension> getExtensions() {
        return Collections.unmodifiableCollection(this.extensions);
    }

    public void setSecurityDispatcher(SecurityDispatcher secDisp) {
        this.securityDispatcher = secDisp;
    }

    protected SecurityDispatcher getSecurityDispatcher() {
        return this.securityDispatcher;
    }

    public void setMainConfiguration(ServerConfiguration mainConfiguration) {
        this.mainConfiguration = mainConfiguration;
    }

    ServerConfiguration getMainConfiguration() {
        return this.mainConfiguration;
    }

    protected boolean isCiteCompliant() {
        if (this.mainConfiguration != null && this.mainConfiguration.isWmtsCiteCompliant().booleanValue()) {
            return true;
        }
        for (WMTSExtension extension : this.extensions) {
            if (extension.getServiceInformation() == null || !extension.getServiceInformation().isCiteCompliant()) continue;
            return true;
        }
        return false;
    }

    private static void performCiteValidation(HttpServletRequest request) throws OWSException {
        if (WMTSService.isRestRequest(request)) {
            return;
        }
        String basePath = request.getPathInfo();
        String[] paths = basePath.split("/");
        String lastPath = paths[paths.length - 1];
        if (!lastPath.equalsIgnoreCase("WMTS")) {
            throw new OWSException(404, "NoApplicableCode", "request", "Service or request not found");
        }
        WMTSService.validateWmtsServiceName(SERVICE_WMTS, request);
    }

    private static boolean isRestRequest(HttpServletRequest request) {
        return request.getPathInfo().contains("service/wmts/rest");
    }

    private static void validateWmtsServiceName(String pathServiceName, HttpServletRequest request) throws OWSException {
        if (pathServiceName == null || !pathServiceName.equalsIgnoreCase("WMTS")) {
            return;
        }
        String requestedServiceName = WMTSService.getParameterValue("SERVICE", request);
        if (requestedServiceName == null) {
            throw new OWSException(400, "MissingParameterValue", "service", "Mandatory SERVICE query parameter not provided.");
        }
        if (!pathServiceName.equalsIgnoreCase(requestedServiceName)) {
            throw new OWSException(400, "InvalidParameterValue", "service", "URL path service '%s' don't match the requested service '%s'.".formatted(pathServiceName, requestedServiceName));
        }
    }

    private static String getParameterValue(String parameterName, HttpServletRequest request) {
        if (parameterName == null) {
            return null;
        }
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            if (entry.getKey() == null || !((String)entry.getKey()).equalsIgnoreCase(parameterName)) continue;
            String[] values = (String[])entry.getValue();
            return values != null ? values[0] : null;
        }
        return null;
    }

    static enum RestRequest {
        TILE(WMTSService.buildRestPattern(5, false), RequestType.TILE, false),
        TILE_STYLE(WMTSService.buildRestPattern(6, true), RequestType.TILE, true),
        FEATUREINFO(WMTSService.buildRestPattern(7, false), RequestType.FEATUREINFO, false),
        FEATUREINFO_STYLE(WMTSService.buildRestPattern(8, true), RequestType.FEATUREINFO, true),
        TILEJSON(WMTSService.buildRestPattern(3, false), RequestType.TILEJSON, false),
        TILEJSON_STYLE(WMTSService.buildRestPattern(4, true), RequestType.TILEJSON, true);

        final Pattern pattern;
        final RequestType type;
        final boolean hasStyle;

        private RestRequest(String pattern, RequestType type, boolean hasStyle) {
            this.pattern = Pattern.compile(pattern);
            this.type = type;
            this.hasStyle = hasStyle;
        }

        public Map<String, String> toKVP(HttpServletRequest request) {
            Matcher matcher = this.pattern.matcher(request.getPathInfo());
            if (!matcher.matches()) {
                return null;
            }
            HashMap<String, String> values = new HashMap<String, String>();
            int i = 1;
            String req = null;
            switch (this.type) {
                case FEATUREINFO: {
                    req = WMTSService.GET_FEATUREINFO;
                    break;
                }
                case TILEJSON: {
                    req = WMTSService.GET_TILEJSON;
                    break;
                }
                default: {
                    req = WMTSService.GET_TILE;
                }
            }
            boolean isFeatureInfo = this.type == RequestType.FEATUREINFO;
            values.put("request", req);
            values.put("layer", matcher.group(i++));
            if (this.hasStyle) {
                values.put("style", matcher.group(i++));
            }
            if (this.type != RequestType.TILEJSON) {
                values.put("tilematrixset", matcher.group(i++));
                values.put("tilematrix", matcher.group(i++));
                values.put("tilerow", matcher.group(i++));
                values.put("tilecol", matcher.group(i++));
                if (isFeatureInfo) {
                    values.put("j", matcher.group(i++));
                    values.put("i", matcher.group(i++));
                }
            } else {
                values.put("tileformat", matcher.group(++i));
            }
            if (request.getParameter("format") != null) {
                if (isFeatureInfo) {
                    values.put("infoformat", request.getParameter("format"));
                } else {
                    values.put("format", request.getParameter("format"));
                }
            }
            return values;
        }
    }

    static enum RequestType {
        TILE,
        CAPABILITIES,
        FEATUREINFO,
        TILEJSON;

    }
}

