/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service.wmts;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.mime.MimeType;

final class WMTSUtils {
    private WMTSUtils() {
    }

    static List<String> getLayerFormats(TileLayer layer) throws IOException {
        return layer.getMimeTypes().stream().map(MimeType::getFormat).collect(Collectors.toList());
    }

    static List<String> getLayerFormatsExtensions(TileLayer layer) throws IOException {
        return layer.getMimeTypes().stream().map(MimeType::getFileExtension).collect(Collectors.toList());
    }

    public static List<String> getInfoFormats(TileLayer layer) {
        return layer.getInfoMimeTypes().stream().map(MimeType::getFormat).collect(Collectors.toList());
    }

    public static List<ParameterFilter> getLayerDimensions(List<ParameterFilter> filters) {
        List<Object> dimensions = new ArrayList<ParameterFilter>(0);
        if (filters != null) {
            dimensions = filters.stream().filter(filter -> !"STYLES".equalsIgnoreCase(filter.getKey()) && filter.getLegalValues() != null).collect(Collectors.toList());
        }
        return dimensions;
    }

    public static String getKvpServiceMetadataURL(String baseUrl) {
        Object base = baseUrl;
        String anchor = "";
        if (((String)base).indexOf(35) != -1) {
            anchor = ((String)base).substring(((String)base).indexOf(35));
            base = ((String)base).substring(0, ((String)base).indexOf(35));
        }
        for (int l = ((String)base).length(); l > 0 && (((String)base).charAt(l - 1) == '?' || ((String)base).charAt(l - 1) == '&'); --l) {
            base = ((String)base).substring(0, l - 1);
        }
        base = ((String)base).indexOf(63) == -1 ? (String)base + "?" : (String)base + "&";
        return (String)base + "SERVICE=wmts&REQUEST=getcapabilities&VERSION=1.0.0" + anchor;
    }
}

