/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.jiffle.parser;

import java.util.Arrays;
import org.eclipse.imagen.media.jiffle.Jiffle;
import org.eclipse.imagen.media.jiffle.parser.node.ImagePos;

public class DirectSources {
    public static String setDestValue(Jiffle.RuntimeModel runtimeModel, String destVar, String expr) {
        switch (runtimeModel) {
            case DIRECT: {
                return String.format("writeToImage(%s, %s, %s)", destVar, ImagePos.DEFAULT, expr);
            }
            case INDIRECT: {
                return "return " + expr;
            }
        }
        throw new IllegalArgumentException("Invalid runtime model: " + String.valueOf((Object)runtimeModel));
    }

    public static String conCall(String ... args) {
        if (args == null || args.length < 1) {
            throw new IllegalArgumentException("No args provided");
        }
        if (args.length > 4) {
            throw new IllegalArgumentException("Too many args: " + Arrays.toString(args));
        }
        switch (args.length) {
            case 1: {
                return DirectSources.con1(args[0]);
            }
            case 2: {
                return DirectSources.con2(args[0], args[1]);
            }
            case 3: {
                return DirectSources.con3(args[0], args[1], args[2]);
            }
        }
        return DirectSources.con4(args[0], args[1], args[2], args[3]);
    }

    private static String con1(String x) {
        return String.format("(_stk.push(_FN.sign(%s)) == null ? Double.NaN : (_stk.peek() != 0 ? 1.0 : 0.0))", x);
    }

    private static String con2(String x, String a) {
        return String.format("(_stk.push(_FN.sign(%s)) == null ? Double.NaN : (_stk.peek() != 0 ? (%s) : 0.0))", x, a);
    }

    private static String con3(String x, String a, String b) {
        return String.format("(_stk.push(_FN.sign(%s)) == null ? Double.NaN : (_stk.peek() != 0 ? (%s) : (%s)))", x, a, b);
    }

    private static String con4(String x, String a, String b, String c) {
        return String.format("(_stk.push(_FN.sign(%s)) == null ? Double.NaN : (_stk.peek() == 1 ? (%s) : (_stk.peek() == 0 ? (%s) : (%s))))", x, a, b, c);
    }
}

