/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.jiffle.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.imagen.media.jiffle.parser.JiffleType;
import org.eclipse.imagen.media.jiffle.parser.JiffleTypeException;

public class FunctionInfo {
    private final String jiffleName;
    private final String runtimeName;
    private final Provider provider;
    private final boolean isVolatile;
    private final JiffleType returnType;
    private final List<JiffleType> argTypes;

    public FunctionInfo(String jiffleName, String runtimeName, Provider provider, boolean isVolatile, String returnTypeLabel, String ... argTypeLabels) {
        this.jiffleName = jiffleName;
        this.runtimeName = runtimeName;
        this.provider = provider;
        this.isVolatile = isVolatile;
        this.returnType = this.getTypeForLabel(returnTypeLabel, jiffleName, "return type");
        this.argTypes = new ArrayList<JiffleType>();
        if (this.argTypes != null && argTypeLabels.length > 0) {
            int i = 1;
            for (String label : argTypeLabels) {
                JiffleType t = this.getTypeForLabel(label, jiffleName, "arg " + i);
                this.argTypes.add(t);
                ++i;
            }
        }
    }

    private JiffleType getTypeForLabel(String typeLabel, String fnName, String context) {
        try {
            return JiffleType.get(typeLabel);
        }
        catch (JiffleTypeException ex) {
            String msg = "Type error getting info for " + fnName + " " + context;
            throw new IllegalStateException(msg, ex);
        }
    }

    public String getJiffleName() {
        return this.jiffleName;
    }

    public String getRuntimeName() {
        switch (this.provider) {
            case MATH: {
                return "Math." + this.runtimeName;
            }
            case JIFFLE: {
                return "_FN." + this.runtimeName;
            }
            case PROXY: {
                return this.runtimeName;
            }
        }
        throw new IllegalStateException("Internal compiler error: getRuntimeExpr");
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    public int getNumArgs() {
        return this.argTypes.size();
    }

    public List<JiffleType> getArgTypes() {
        return Collections.unmodifiableList(this.argTypes);
    }

    public boolean isProxy() {
        return this.provider == Provider.PROXY;
    }

    public JiffleType getReturnType() {
        return this.returnType;
    }

    public boolean matches(String fnName, JiffleType ... fnArgTypes) {
        if (!this.jiffleName.equals(fnName)) {
            return false;
        }
        if (!(fnArgTypes != null && fnArgTypes.length != 0 || this.argTypes.isEmpty())) {
            return false;
        }
        if (fnArgTypes != null && fnArgTypes.length != this.argTypes.size()) {
            return false;
        }
        int k = 0;
        for (JiffleType argType : this.argTypes) {
            if (argType == fnArgTypes[k++]) continue;
            return false;
        }
        return true;
    }

    public static enum Provider {
        JIFFLE("jiffle"),
        MATH("math"),
        PROXY("proxy");

        private String name;

        private Provider(String name) {
            this.name = name;
        }

        public static Provider get(String name) {
            String s = name.toLowerCase().trim();
            for (Provider p : Provider.values()) {
                if (!p.name.equals(s)) continue;
                return p;
            }
            return null;
        }
    }
}

