/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.jiffle.parser;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.imagen.media.jiffle.parser.FunctionInfo;
import org.eclipse.imagen.media.jiffle.parser.JiffleType;
import org.eclipse.imagen.media.jiffle.parser.UndefinedFunctionException;
import org.eclipse.imagen.media.jiffle.util.Strings;

public class FunctionLookup {
    private static final String PROPERTIES_FILE = "META-INF/org/eclipse/imagen/media/jiffle/FunctionLookup.properties";
    private static final Map<String, List<FunctionInfo>> lookup = new HashMap<String, List<FunctionInfo>>();
    private static final int JIFFLE_NAME = 0;
    private static final int RUNTIME_NAME = 1;
    private static final int PROVIDER = 2;
    private static final int VOLATILE = 3;
    private static final int RETURN = 4;
    private static final int FIRST_ARG = 5;
    private static final int MIN_ATTRIBUTES = 6;

    public static boolean isDefined(String jiffleName) {
        return lookup.containsKey(jiffleName);
    }

    public static boolean isDefined(String jiffleName, JiffleType ... argTypes) {
        try {
            FunctionLookup.getInfo(jiffleName, argTypes);
        }
        catch (UndefinedFunctionException ex) {
            return false;
        }
        return true;
    }

    public static FunctionInfo getInfo(String jiffleName, JiffleType ... argTypes) throws UndefinedFunctionException {
        List<FunctionInfo> fns = lookup.get(jiffleName);
        if (fns != null) {
            for (FunctionInfo info : fns) {
                if (!info.matches(jiffleName, argTypes)) continue;
                return info;
            }
        }
        throw new UndefinedFunctionException(String.format("Undefined function: %s(%s)", jiffleName, Strings.commas((Object[])argTypes)));
    }

    public static String getRuntimeExpr(String jiffleName, JiffleType ... argTypes) throws UndefinedFunctionException {
        return FunctionLookup.getInfo(jiffleName, argTypes).getRuntimeName();
    }

    public static JiffleType getReturnType(String jiffleName) throws UndefinedFunctionException {
        List<FunctionInfo> fns = lookup.get(jiffleName);
        if (fns != null) {
            return fns.get(0).getReturnType();
        }
        throw new UndefinedFunctionException("Undefined function: " + jiffleName);
    }

    static {
        InputStream in = null;
        try {
            in = FunctionLookup.class.getClassLoader().getResourceAsStream(PROPERTIES_FILE);
            Properties properties = new Properties();
            properties.load(in);
            Enumeration<?> names = properties.propertyNames();
            while (names.hasMoreElements()) {
                List<Object> fns;
                String name = (String)names.nextElement();
                String value = properties.getProperty(name);
                String[] attr = value.split("[,\\s]+");
                if (attr.length < 6) {
                    throw new IllegalArgumentException("Error reading META-INF/org/eclipse/imagen/media/jiffle/FunctionLookup.properties record: " + name + "=" + value);
                }
                FunctionInfo.Provider provider = FunctionInfo.Provider.get(attr[2]);
                if (provider == null) {
                    throw new IllegalArgumentException("Unrecognized Jiffle function provider (" + attr[2] + ") in META-INF/org/eclipse/imagen/media/jiffle/FunctionLookup.properties");
                }
                boolean isVolatile = Boolean.parseBoolean(attr[3]);
                int numArgs = "0".equals(attr[5]) ? 0 : attr.length - 5;
                String[] argTypes = new String[numArgs];
                int i = 0;
                int k = 5;
                while (i < numArgs) {
                    argTypes[i] = attr[k];
                    ++i;
                    ++k;
                }
                String fname = attr[0];
                if (lookup.containsKey(fname)) {
                    fns = lookup.get(fname);
                } else {
                    fns = new ArrayList();
                    lookup.put(fname, fns);
                }
                fns.add(new FunctionInfo(attr[0], attr[1], provider, isVolatile, attr[4], argTypes));
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Internal compiler error", ex);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

