/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.jiffle.parser;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.imagen.media.jiffle.parser.JiffleParserException;
import org.eclipse.imagen.media.jiffle.parser.Symbol;

public abstract class SymbolScope {
    protected final String name;
    protected final SymbolScope enclosingScope;
    protected final Map<String, Symbol> symbols;

    public SymbolScope(String name, SymbolScope enclosingScope) {
        this.name = name;
        this.enclosingScope = enclosingScope;
        this.symbols = new LinkedHashMap<String, Symbol>();
    }

    public String getName() {
        return this.name;
    }

    public SymbolScope getEnclosingScope() {
        return this.enclosingScope;
    }

    public void add(Symbol symbol) {
        this.add(symbol, false);
    }

    public void add(Symbol symbol, boolean allowReplacement) {
        if (this.symbols.containsKey(symbol.getName()) && !allowReplacement) {
            throw new IllegalArgumentException("Symbol " + symbol.getName() + " is already defined");
        }
        this.symbols.put(symbol.getName(), symbol);
    }

    public boolean has(String name) {
        if (this.symbols.containsKey(name)) {
            return true;
        }
        if (this.enclosingScope != null) {
            return this.enclosingScope.has(name);
        }
        return false;
    }

    public Symbol get(String name) {
        if (this.symbols.containsKey(name)) {
            return this.symbols.get(name);
        }
        if (this.enclosingScope != null) {
            return this.enclosingScope.get(name);
        }
        throw new JiffleParserException("Unknown symbol " + name);
    }

    public SymbolScope getDeclaringScope(String name) {
        if (this.symbols.containsKey(name)) {
            return this;
        }
        if (this.enclosingScope != null) {
            return this.enclosingScope.getDeclaringScope(name);
        }
        throw new IllegalArgumentException("Unknown symbol " + name + " in scope " + this.getName());
    }

    public Set<String> getByType(Symbol.Type type) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Symbol symbol : this.symbols.values()) {
            if (!type.equals((Object)symbol.getType())) continue;
            result.add(symbol.getName());
        }
        if (this.enclosingScope != null) {
            result.addAll(this.enclosingScope.getByType(type));
        }
        return result;
    }
}

