/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.jiffle.parser.node;

import java.util.Objects;
import org.eclipse.imagen.media.jiffle.parser.Errors;
import org.eclipse.imagen.media.jiffle.parser.JiffleType;
import org.eclipse.imagen.media.jiffle.parser.node.Expression;
import org.eclipse.imagen.media.jiffle.parser.node.NodeException;
import org.eclipse.imagen.media.jiffle.parser.node.SourceWriter;
import org.eclipse.imagen.media.jiffle.parser.node.Variable;

public class BinaryExpression
extends Expression {
    private final boolean declarationNeeded;
    private final Expression left;
    private final Expression right;
    private final Operator op;

    private static JiffleType getReturnType(Expression left, Expression right) {
        if (left.getType() == right.getType()) {
            return left.getType();
        }
        return JiffleType.LIST;
    }

    public BinaryExpression(int opCode, Expression left, Expression right) throws NodeException {
        this(opCode, left, right, false);
    }

    public BinaryExpression(int opCode, Expression left, Expression right, boolean declarationNeeded) throws NodeException {
        super(BinaryExpression.getReturnType(left, right));
        this.op = Operator.get(opCode);
        if (this.op == Operator.UNKNOWN) {
            throw new NodeException(Errors.INVALID_BINARY_EXPRESSION);
        }
        this.left = left.forceDouble();
        this.right = right.forceDouble();
        this.declarationNeeded = declarationNeeded;
    }

    @Override
    public void write(SourceWriter w) {
        if (this.declarationNeeded && this.left instanceof Variable) {
            String type = this.getJavaType();
            w.append(type).append(" ");
        }
        String leftCode = w.writeToString(this.left);
        String rightCode = w.writeToString(this.right);
        w.append(String.format(this.op.getFormat(), leftCode, rightCode));
    }

    private String getJavaType() {
        return this.left.getType() == JiffleType.D ? "double" : "List";
    }

    private String getInitialValue() {
        return this.left.getType() == JiffleType.D ? "Double.NaN" : "null";
    }

    public void writeDeclaration(SourceWriter w) {
        if (this.left instanceof Variable) {
            String type = this.getJavaType();
            String initialValue = this.getInitialValue();
            w.indent().append(type).append(" ").append(this.left).append(" = ").append(initialValue).append(";").newLine();
        }
    }

    public void appendName(SourceWriter w) {
        if (this.left instanceof Variable) {
            w.append(this.left.toString());
        }
    }

    public void writeDefaultValue(SourceWriter w) {
        if (!(this.left instanceof Variable)) {
            throw new IllegalStateException("Cannot write default value unless this is a declaration");
        }
        w.indent().append("if (Double.isNaN(").append(this.left).append(")) {").newLine();
        w.inc();
        w.indent().append(this).append(";").newLine();
        w.dec();
        w.line("}");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinaryExpression that = (BinaryExpression)o;
        return this.declarationNeeded == that.declarationNeeded && Objects.equals(this.left, that.left) && Objects.equals(this.right, that.right) && this.op == that.op;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.declarationNeeded, this.left, this.right, this.op});
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    public Operator getOp() {
        return this.op;
    }

    public String toString() {
        return String.valueOf(this.left) + " " + String.valueOf((Object)this.op) + " " + String.valueOf(this.right);
    }

    public static enum Operator {
        PLUS(32, "%s + %s"),
        MINUS(33, "%s - %s"),
        TIMES(29, "%s * %s"),
        DIV(30, "%s / %s"),
        MOD(31, "%s %% %s"),
        POW(28, "Math.pow(%s, %s)"),
        ASSIGN(50, "%s = %s"),
        PLUSEQ(48, "%s += %s"),
        MINUSEQ(49, "%s -= %s"),
        TIMESEQ(45, "%s *= %s"),
        DIVEQ(46, "%s /= %s"),
        UNKNOWN(-1, "");

        private final int code;
        private final String fmt;

        private Operator(int code, String fmt) {
            this.code = code;
            this.fmt = fmt;
        }

        public static Operator get(int code) {
            for (Operator o : Operator.values()) {
                if (code != o.code) continue;
                return o;
            }
            return UNKNOWN;
        }

        public String getFormat() {
            return this.fmt;
        }
    }
}

