/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.jiffle.parser.node;

import java.util.Arrays;
import java.util.Objects;
import org.eclipse.imagen.media.jiffle.parser.Errors;
import org.eclipse.imagen.media.jiffle.parser.FunctionInfo;
import org.eclipse.imagen.media.jiffle.parser.FunctionLookup;
import org.eclipse.imagen.media.jiffle.parser.JiffleType;
import org.eclipse.imagen.media.jiffle.parser.UndefinedFunctionException;
import org.eclipse.imagen.media.jiffle.parser.node.Expression;
import org.eclipse.imagen.media.jiffle.parser.node.NodeException;
import org.eclipse.imagen.media.jiffle.parser.node.SourceWriter;
import org.eclipse.imagen.media.jiffle.util.Strings;

public class FunctionCall
extends Expression {
    private final String runtimeName;
    private final boolean proxy;
    private final Expression[] args;

    public static FunctionCall of(String jiffleName, Expression ... args) throws NodeException {
        JiffleType[] argTypes = args == null ? new JiffleType[]{} : new JiffleType[args.length];
        for (int i = 0; i < argTypes.length; ++i) {
            argTypes[i] = args[i].getType();
        }
        try {
            FunctionInfo info = FunctionLookup.getInfo(jiffleName, argTypes);
            return new FunctionCall(info, args);
        }
        catch (UndefinedFunctionException ex) {
            throw new NodeException(Errors.UNKNOWN_FUNCTION);
        }
    }

    private FunctionCall(FunctionInfo info, Expression ... args) throws NodeException {
        super(info.getReturnType());
        this.runtimeName = info.getRuntimeName();
        this.proxy = info.isProxy();
        this.args = args == null ? new Expression[]{} : args;
    }

    public String toString() {
        String tail = this.proxy ? "()" : String.format("(%s)", Strings.commas(this.args));
        return this.runtimeName + tail;
    }

    @Override
    public void write(SourceWriter w) {
        w.append(this.runtimeName);
        if (!this.proxy) {
            w.append("(");
            for (int i = 0; i < this.args.length; ++i) {
                Expression arg = this.args[i];
                arg.write(w);
                if (i >= this.args.length - 1) continue;
                w.append(", ");
            }
            w.append(")");
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FunctionCall that = (FunctionCall)o;
        return this.proxy == that.proxy && Objects.equals(this.runtimeName, that.runtimeName) && Arrays.equals(this.args, that.args);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.runtimeName, this.proxy);
        result = 31 * result + Arrays.hashCode(this.args);
        return result;
    }

    public String getRuntimeName() {
        return this.runtimeName;
    }

    public boolean isProxy() {
        return this.proxy;
    }

    public Expression[] getArgs() {
        return this.args;
    }
}

