/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.jiffle.parser.node;

import java.util.Objects;
import org.eclipse.imagen.media.jiffle.parser.node.Expression;
import org.eclipse.imagen.media.jiffle.parser.node.Node;
import org.eclipse.imagen.media.jiffle.parser.node.SourceWriter;
import org.eclipse.imagen.media.jiffle.parser.node.Statement;

public class IfElse
implements Statement {
    private final Expression condition;
    private final Node ifStatement;
    private final Node elseStatement;

    public IfElse(Expression condition, Node ifStatement, Node elseStatement) {
        this.ifStatement = ifStatement;
        this.elseStatement = elseStatement;
        this.condition = condition;
    }

    @Override
    public void write(SourceWriter w) {
        w.indent().append("if (_FN.isTrue(").append(this.condition).append(")) {").newLine();
        w.inc();
        this.ifStatement.write(w);
        w.dec();
        if (this.elseStatement != null) {
            w.line("} else {");
            w.inc();
            this.elseStatement.write(w);
            w.dec();
        }
        w.line("}");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IfElse ifElse = (IfElse)o;
        return Objects.equals(this.condition, ifElse.condition) && Objects.equals(this.ifStatement, ifElse.ifStatement) && Objects.equals(this.elseStatement, ifElse.elseStatement);
    }

    public int hashCode() {
        return Objects.hash(this.condition, this.ifStatement, this.elseStatement);
    }

    public Expression getCondition() {
        return this.condition;
    }

    public Node getIfStatement() {
        return this.ifStatement;
    }

    public Node getElseStatement() {
        return this.elseStatement;
    }
}

