/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.jiffle.parser.node;

import java.util.Objects;
import org.eclipse.imagen.media.jiffle.parser.node.Expression;
import org.eclipse.imagen.media.jiffle.parser.node.SourceWriter;
import org.eclipse.imagen.media.jiffle.parser.node.Statement;
import org.eclipse.imagen.media.jiffle.parser.node.Variable;

public class LoopInRange
implements Statement {
    private Statement statement;
    private Variable loopVariable;
    private Expression low;
    private Expression high;

    public LoopInRange(Variable loopVariable, Expression low, Expression high, Statement statement) {
        this.loopVariable = loopVariable;
        this.low = low;
        this.high = high;
        this.statement = statement;
    }

    @Override
    public void write(SourceWriter w) {
        String lowVariable = "_lo" + String.valueOf(this.loopVariable);
        String highVariable = "_hi" + lowVariable;
        w.indent().append("final int ").append(lowVariable).append(" = (int) (").append(this.low).append(");").newLine();
        w.indent().append("final int ").append(highVariable).append(" = (int) (").append(this.high).append(");").newLine();
        w.indent().append("for(int ").append(this.loopVariable).append(" = ").append(lowVariable);
        w.append("; ").append(this.loopVariable).append(" <= ").append(highVariable);
        w.append("; ").append(this.loopVariable).append("++) {").newLine();
        w.inc();
        w.line("checkLoopIterations();");
        this.statement.write(w);
        w.dec();
        w.line("}");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoopInRange that = (LoopInRange)o;
        return Objects.equals(this.statement, that.statement) && Objects.equals(this.loopVariable, that.loopVariable) && Objects.equals(this.low, that.low) && Objects.equals(this.high, that.high);
    }

    public int hashCode() {
        return Objects.hash(this.statement, this.loopVariable, this.low, this.high);
    }

    public Statement getStatement() {
        return this.statement;
    }

    public Variable getLoopVariable() {
        return this.loopVariable;
    }

    public Expression getLow() {
        return this.low;
    }

    public Expression getHigh() {
        return this.high;
    }
}

