/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.jiffle.parser.node;

import java.util.Objects;
import org.eclipse.imagen.media.jiffle.parser.node.Expression;
import org.eclipse.imagen.media.jiffle.parser.node.SourceWriter;

public class ParenExpression
extends Expression {
    private final Expression expr;

    public ParenExpression(Expression e) {
        super(e.getType());
        this.expr = e;
    }

    public String toString() {
        return "(" + String.valueOf(this.expr) + ")";
    }

    @Override
    public void write(SourceWriter w) {
        w.append("(");
        this.expr.write(w);
        w.append(")");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ParenExpression that = (ParenExpression)o;
        return Objects.equals(this.expr, that.expr);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.expr);
    }

    public Expression getExpr() {
        return this.expr;
    }
}

