/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.jiffle.parser.node;

import java.util.Objects;
import org.eclipse.imagen.media.jiffle.parser.node.Expression;
import org.eclipse.imagen.media.jiffle.parser.node.FunctionCall;
import org.eclipse.imagen.media.jiffle.parser.node.Node;
import org.eclipse.imagen.media.jiffle.parser.node.NodeException;
import org.eclipse.imagen.media.jiffle.parser.node.SourceWriter;
import org.eclipse.imagen.media.jiffle.util.Strings;

public class Pixel
implements Node {
    public static final Pixel DEFAULT;
    private final Expression x;
    private final Expression y;

    public Pixel(Expression x, Expression y) {
        this.x = x;
        this.y = y;
    }

    public String toString() {
        return Strings.commas(this.x, this.y);
    }

    @Override
    public void write(SourceWriter w) {
        w.append(this.x).append(", ").append(this.y);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pixel pixel = (Pixel)o;
        return Objects.equals(this.x, pixel.x) && Objects.equals(this.y, pixel.y);
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y);
    }

    public Expression getX() {
        return this.x;
    }

    public Expression getY() {
        return this.y;
    }

    static {
        try {
            DEFAULT = new Pixel(FunctionCall.of("x", new Expression[0]), FunctionCall.of("y", new Expression[0]));
        }
        catch (NodeException ex) {
            throw new ExceptionInInitializerError();
        }
    }
}

