/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.jiffle.parser.node;

import java.util.Objects;
import org.eclipse.imagen.media.jiffle.parser.node.Expression;
import org.eclipse.imagen.media.jiffle.parser.node.SourceWriter;
import org.eclipse.imagen.media.jiffle.util.Strings;

public class PostfixUnaryExpression
extends Expression {
    private final Expression arg;
    private final String op;

    public PostfixUnaryExpression(Expression arg, String op) {
        super(arg.getType());
        this.arg = arg;
        this.op = op;
    }

    public String toString() {
        return Strings.spaces(this.arg, this.op);
    }

    @Override
    public void write(SourceWriter w) {
        w.append(this.arg).append(this.op);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PostfixUnaryExpression that = (PostfixUnaryExpression)o;
        return Objects.equals(this.arg, that.arg) && Objects.equals(this.op, that.op);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.arg, this.op);
    }

    public Expression getArg() {
        return this.arg;
    }

    public String getOp() {
        return this.op;
    }
}

