/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.jiffle.parser.node;

import java.util.Objects;
import org.eclipse.imagen.media.jiffle.Jiffle;
import org.eclipse.imagen.media.jiffle.parser.DirectSources;
import org.eclipse.imagen.media.jiffle.parser.Errors;
import org.eclipse.imagen.media.jiffle.parser.JiffleType;
import org.eclipse.imagen.media.jiffle.parser.node.Band;
import org.eclipse.imagen.media.jiffle.parser.node.Expression;
import org.eclipse.imagen.media.jiffle.parser.node.IntLiteral;
import org.eclipse.imagen.media.jiffle.parser.node.NodeException;
import org.eclipse.imagen.media.jiffle.parser.node.SourceWriter;

public class SetDestValue
extends Expression {
    private final String destVar;
    private final Expression expr;
    private final Band band;

    private static JiffleType ensureScalar(Expression e) throws NodeException {
        JiffleType type = e.getType();
        if (type == JiffleType.D) {
            return type;
        }
        throw new NodeException(Errors.EXPECTED_SCALAR);
    }

    public SetDestValue(String varName, Expression expr) throws NodeException {
        this(varName, new Band(new IntLiteral("0")), expr);
    }

    public SetDestValue(String varName, Band band, Expression expr) throws NodeException {
        super(SetDestValue.ensureScalar(expr));
        this.destVar = varName;
        this.expr = expr;
        this.band = band;
    }

    public String toString() {
        return DirectSources.setDestValue(Jiffle.RuntimeModel.DIRECT, this.destVar, this.expr.toString());
    }

    @Override
    public void write(SourceWriter w) {
        Jiffle.RuntimeModel runtimeModel = w.getRuntimeModel();
        switch (runtimeModel) {
            case DIRECT: {
                if (w.isInternalBaseClass()) {
                    w.append("d_").append(this.destVar).append(".write(_x, _y, ");
                    if (this.band != null) {
                        w.append(this.band);
                    } else {
                        w.append("0");
                    }
                    w.append(", ").append(this.expr).append(")");
                    break;
                }
                w.append("writeToImage(\"").append(this.destVar).append("\", _x, _y, ");
                if (this.band != null) {
                    w.append(this.band);
                } else {
                    w.append("0");
                }
                w.append(", ").append(this.expr).append(")");
                break;
            }
            case INDIRECT: {
                w.append("result[");
                if (this.band != null) {
                    w.append(this.band);
                } else {
                    w.append("0");
                }
                w.append("] = ").append(this.expr);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid runtime model: " + String.valueOf((Object)runtimeModel));
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SetDestValue that = (SetDestValue)o;
        return Objects.equals(this.destVar, that.destVar) && Objects.equals(this.expr, that.expr);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.destVar, this.expr);
    }

    public String getDestVar() {
        return this.destVar;
    }

    public Expression getExpr() {
        return this.expr;
    }
}

