/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.jiffle.parser.node;

import java.util.Objects;
import org.eclipse.imagen.media.jiffle.parser.node.Expression;
import org.eclipse.imagen.media.jiffle.parser.node.SourceWriter;
import org.eclipse.imagen.media.jiffle.parser.node.Statement;

public class Until
implements Statement {
    private final Expression condition;
    private final Statement statement;

    public Until(Expression condition, Statement statement) {
        this.condition = condition;
        this.statement = statement;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("while(!_FN.isTrue(").append(this.condition).append(")) {\n").append(this.statement).append("}");
        return sb.toString();
    }

    @Override
    public void write(SourceWriter w) {
        w.indent().append("while (!_FN.isTrue(");
        this.condition.write(w);
        w.append(")) {\n");
        w.inc();
        w.line("checkLoopIterations();");
        this.statement.write(w);
        w.dec();
        w.line("}");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Until until = (Until)o;
        return Objects.equals(this.condition, until.condition) && Objects.equals(this.statement, until.statement);
    }

    public int hashCode() {
        return Objects.hash(this.condition, this.statement);
    }

    public Expression getCondition() {
        return this.condition;
    }

    public Statement getStatement() {
        return this.statement;
    }
}

