/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.jiffle.runtime;

import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.imagen.media.jiffle.JiffleException;
import org.eclipse.imagen.media.jiffle.runtime.AbstractJiffleRuntime;
import org.eclipse.imagen.media.jiffle.runtime.CoordinateTransform;
import org.eclipse.imagen.media.jiffle.runtime.JiffleIndirectRuntime;
import org.eclipse.imagen.media.jiffle.runtime.WorldNotSetException;

public abstract class AbstractIndirectRuntime
extends AbstractJiffleRuntime
implements JiffleIndirectRuntime {
    List sourceImageNames = new ArrayList();
    String destImageName;
    Integer destinationBands;

    public AbstractIndirectRuntime(String[] variableNames) {
        super(variableNames);
        this.initOptionVars();
    }

    @Override
    public void setDestinationImage(String varName) {
        try {
            this.doSetDestinationImage(varName, null);
        }
        catch (WorldNotSetException worldNotSetException) {
            // empty catch block
        }
    }

    @Override
    public void setDestinationImage(String varName, CoordinateTransform tr) throws JiffleException {
        try {
            this.doSetDestinationImage(varName, tr);
        }
        catch (WorldNotSetException ex) {
            throw new JiffleException(String.format("Setting a coordinate tranform for a source (%s) withouthaving first set the world bounds and resolution", varName));
        }
    }

    private void doSetDestinationImage(String varName, CoordinateTransform tr) throws WorldNotSetException {
        this.destImageName = varName;
    }

    @Override
    public void setDefaultBounds() {
        String imageName = (String)this._images.keySet().iterator().next();
        RenderedImage refImage = ((AbstractJiffleRuntime.SourceImage)this._images.get((Object)imageName)).image;
        Rectangle rect = new Rectangle(refImage.getMinX(), refImage.getMinY(), refImage.getWidth(), refImage.getHeight());
        this.setWorldByResolution(rect, 1.0, 1.0);
    }

    @Override
    public void setDestinationBands(Map<String, Integer> destinationBands) {
        if (destinationBands.size() > 1 || destinationBands.isEmpty()) {
            throw new IllegalStateException("The indirect runtime works with one destination image only");
        }
        this.destinationBands = destinationBands.values().iterator().next();
    }

    @Override
    public int getOutputBands() {
        return this.destinationBands;
    }
}

