/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.jiffle.runtime;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public class DaemonThreadFactory
implements ThreadFactory {
    private static final String DEFAULT_ROOT_NAME = "daemon-";
    private final ReentrantLock lock = new ReentrantLock();
    private static final AtomicInteger threadCount = new AtomicInteger(0);
    private final int priority;
    private final String rootName;

    public DaemonThreadFactory() {
        this(5, DEFAULT_ROOT_NAME);
    }

    public DaemonThreadFactory(int priority) {
        this(priority, DEFAULT_ROOT_NAME);
    }

    public DaemonThreadFactory(int priority, String rootName) {
        String s;
        String string = s = rootName == null ? "" : rootName.trim();
        this.rootName = s.length() == 0 ? DEFAULT_ROOT_NAME : (s.endsWith("-") ? s : s + "-");
        this.priority = Math.min(10, Math.max(1, priority));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Thread newThread(Runnable r) {
        this.lock.lock();
        try {
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.setName(DEFAULT_ROOT_NAME + threadCount.getAndIncrement());
            t.setPriority(this.priority);
            Thread thread = t;
            return thread;
        }
        finally {
            this.lock.unlock();
        }
    }
}

