/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.v2_0.bindings;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.spatial.BinarySpatialOperator;
import org.geotools.api.filter.spatial.DistanceBufferOperator;
import org.geotools.api.filter.temporal.BinaryTemporalOperator;
import org.geotools.filter.v1_0.DistanceUnits;
import org.geotools.filter.v2_0.FES;
import org.geotools.xsd.Node;
import org.locationtech.jts.geom.Geometry;

public class FESParseEncodeUtil {
    static Expression[] temporal(Node node, FilterFactory factory) {
        PropertyName name = (PropertyName)node.getChildValue(PropertyName.class);
        Object other = null;
        for (Object o : node.getChildValues(Object.class)) {
            if (o == name) continue;
            other = o;
            break;
        }
        if (other == null) {
            throw new IllegalArgumentException("Temporal filter did not specify two operands");
        }
        Literal expr = null;
        if (other instanceof Expression) {
            Expression expression = other;
            expr = expression;
        } else {
            expr = factory.literal(other);
        }
        return new Expression[]{name, expr};
    }

    static Expression getProperty(BinaryTemporalOperator op, QName name) {
        return FESParseEncodeUtil.getProperty(op.getExpression1(), op.getExpression2(), name);
    }

    static Expression getProperty(BinarySpatialOperator op, QName name) {
        return FESParseEncodeUtil.getProperty(op.getExpression1(), op.getExpression2(), name);
    }

    static List<Object[]> getProperties(DistanceBufferOperator op) {
        ArrayList<Object[]> l = new ArrayList<Object[]>();
        l.add(FESParseEncodeUtil.distanceBufferOpProperty(op.getExpression1()));
        l.add(FESParseEncodeUtil.distanceBufferOpProperty(op.getExpression2()));
        l.add(new Object[]{new QName("http://www.opengis.net/fes/2.0", "Distance"), DistanceUnits.of((double)op.getDistance(), (String)op.getDistanceUnits())});
        return l;
    }

    static Object[] distanceBufferOpProperty(Expression e) {
        if (e instanceof PropertyName) {
            return new Object[]{FES.ValueReference, e};
        }
        if (e instanceof Literal) {
            Literal l = (Literal)e;
            if (l.getValue() instanceof Geometry) {
                Geometry g = (Geometry)l.getValue();
                return new Object[]{new QName("http://www.opengis.net/gml/3.2", g.getGeometryType()), g};
            }
            return new Object[]{FES.Literal, e};
        }
        if (e instanceof Function) {
            return new Object[]{FES.Function, e};
        }
        return new Object[]{FES.expression, e};
    }

    static Expression getProperty(Expression e1, Expression e2, QName name) {
        if (FES.ValueReference.equals(name)) {
            if (e1 instanceof PropertyName) {
                return e1;
            }
            if (e2 instanceof PropertyName) {
                return e2;
            }
        }
        if (FES.expression.equals(name)) {
            if (e1 instanceof PropertyName) {
                return e2;
            }
            if (e2 instanceof PropertyName) {
                return e1;
            }
        }
        return null;
    }
}

