/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.scale;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import java.util.logging.Logger;
import org.eclipse.imagen.ImageN;
import org.eclipse.imagen.Interpolation;
import org.eclipse.imagen.OperationDescriptorImpl;
import org.eclipse.imagen.ParameterBlockImageN;
import org.eclipse.imagen.PropertyGenerator;
import org.eclipse.imagen.ROI;
import org.eclipse.imagen.RenderableOp;
import org.eclipse.imagen.RenderedOp;
import org.eclipse.imagen.media.range.Range;
import org.eclipse.imagen.media.scale.JaiI18N;
import org.eclipse.imagen.media.scale.ScalePropertyGenerator;

public class ScaleDescriptor
extends OperationDescriptorImpl {
    private static final Logger LOGGER = Logger.getLogger(ScaleDescriptor.class.toString());
    private static final String[][] resources = new String[][]{{"GlobalName", "Scale"}, {"LocalName", "Scale"}, {"Vendor", "org.eclipse.imagen.media"}, {"Description", JaiI18N.getString("ScaleDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/ScaleDescriptor.html"}, {"Version", JaiI18N.getString("DescriptorVersion")}, {"arg0Desc", JaiI18N.getString("ScaleDescriptor1")}, {"arg1Desc", JaiI18N.getString("ScaleDescriptor2")}, {"arg2Desc", JaiI18N.getString("ScaleDescriptor3")}, {"arg3Desc", JaiI18N.getString("ScaleDescriptor4")}, {"arg4Desc", JaiI18N.getString("ScaleDescriptor5")}, {"arg5Desc", JaiI18N.getString("ScaleDescriptor6")}, {"arg6Desc", JaiI18N.getString("ScaleDescriptor7")}, {"arg7Desc", JaiI18N.getString("ScaleDescriptor8")}, {"arg8Desc", JaiI18N.getString("ScaleDescriptor9")}};
    private static final Class[] paramClasses = new Class[]{Float.class, Float.class, Float.class, Float.class, Interpolation.class, ROI.class, Boolean.class, Range.class, double[].class};
    private static final String[] paramNames = new String[]{"xScale", "yScale", "xTrans", "yTrans", "interpolation", "ROI", "useRoiAccessor", "nodata", "backgroundValues"};
    private static final Object[] paramDefaults = new Object[]{new Float(1.0f), new Float(1.0f), new Float(0.0f), new Float(0.0f), Interpolation.getInstance((int)0), null, false, null, null};

    public ScaleDescriptor() {
        super(resources, 1, paramClasses, paramNames, paramDefaults);
    }

    public boolean isRenderableSupported() {
        return false;
    }

    public PropertyGenerator[] getPropertyGenerators() {
        PropertyGenerator[] pg = new PropertyGenerator[]{new ScalePropertyGenerator()};
        return pg;
    }

    protected boolean validateParameters(ParameterBlock args, StringBuffer msg) {
        if (!super.validateParameters(args, msg)) {
            return false;
        }
        float xScale = args.getFloatParameter(0);
        float yScale = args.getFloatParameter(1);
        ROI roi = null;
        if (args.getNumParameters() > 5 && args.getObjectParameter(5) != null) {
            roi = (ROI)args.getObjectParameter(5);
        }
        if ((xScale <= 0.0f || yScale <= 0.0f) && roi == null) {
            msg.append(this.getName() + " " + JaiI18N.getString("ScaleDescriptor6"));
            return false;
        }
        return true;
    }

    public Number getParamMinValue(int index) {
        if (index == 0 || index == 1) {
            return new Float(0.0f);
        }
        if (index == 2 || index == 3) {
            return new Float(-3.4028235E38f);
        }
        if (index == 4 || index == 5 || index == 6 || index == 7 || index == 8) {
            return null;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public static RenderedOp create(RenderedImage source0, Float xScale, Float yScale, Float xTrans, Float yTrans, Interpolation interpolation, ROI roi, Boolean useRoiAccessor, Range nodata, double[] backgroundValues, RenderingHints hints) {
        ParameterBlockImageN pb = new ParameterBlockImageN("Scale", "rendered");
        pb.setSource("source0", (Object)source0);
        pb.setParameter("xScale", (Object)xScale);
        pb.setParameter("yScale", (Object)yScale);
        pb.setParameter("xTrans", (Object)xTrans);
        pb.setParameter("yTrans", (Object)yTrans);
        pb.setParameter("interpolation", (Object)interpolation);
        pb.setParameter("nodata", (Object)nodata);
        if (roi != null) {
            pb.setParameter("ROI", (Object)roi);
        }
        if (backgroundValues != null) {
            pb.setParameter("backgroundValues", (Object)backgroundValues);
        }
        pb.setParameter("useRoiAccessor", (Object)useRoiAccessor);
        return ImageN.create((String)"Scale", (ParameterBlock)pb, (RenderingHints)hints);
    }

    public static RenderedOp create(RenderedImage source0, Float xScale, Float yScale, Float xTrans, Float yTrans, Interpolation interpolation, RenderingHints hints) {
        ParameterBlockImageN pb = new ParameterBlockImageN("Scale", "rendered");
        pb.setSource("source0", (Object)source0);
        pb.setParameter("xScale", (Object)xScale);
        pb.setParameter("yScale", (Object)yScale);
        pb.setParameter("xTrans", (Object)xTrans);
        pb.setParameter("yTrans", (Object)yTrans);
        pb.setParameter("interpolation", (Object)interpolation);
        return ImageN.create((String)"Scale", (ParameterBlock)pb, (RenderingHints)hints);
    }

    public static RenderableOp createRenderable(RenderableImage source0, Float xScale, Float yScale, Float xTrans, Float yTrans, Interpolation interpolation, ROI roi, Range nodata, double[] backgroundValues, RenderingHints hints) {
        ParameterBlockImageN pb = new ParameterBlockImageN("Scale", "renderable");
        pb.setSource("source0", (Object)source0);
        pb.setParameter("xScale", (Object)xScale);
        pb.setParameter("yScale", (Object)yScale);
        pb.setParameter("xTrans", (Object)xTrans);
        pb.setParameter("yTrans", (Object)yTrans);
        pb.setParameter("interpolation", (Object)interpolation);
        pb.setParameter("nodata", (Object)nodata);
        if (roi != null) {
            pb.setParameter("ROI", (Object)roi);
        }
        if (backgroundValues != null) {
            pb.setParameter("backgroundValues", (Object)backgroundValues);
        }
        return ImageN.createRenderable((String)"Scale", (ParameterBlock)pb, (RenderingHints)hints);
    }
}

