/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.scale;

import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.Collections;
import java.util.Map;
import org.eclipse.imagen.BorderExtender;
import org.eclipse.imagen.ImageLayout;
import org.eclipse.imagen.ImageN;
import org.eclipse.imagen.Interpolation;
import org.eclipse.imagen.InterpolationBicubic;
import org.eclipse.imagen.InterpolationBilinear;
import org.eclipse.imagen.PlanarImage;
import org.eclipse.imagen.ROI;
import org.eclipse.imagen.ROIShape;
import org.eclipse.imagen.RenderedOp;
import org.eclipse.imagen.media.translate.TranslateIntOpImage;
import org.eclipse.imagen.media.util.PropertyGeneratorImpl;
import org.eclipse.imagen.media.utilities.ImageLayout2;
import org.eclipse.imagen.media.vectorbin.ROIGeometry;
import org.eclipse.imagen.operator.ConstantDescriptor;
import org.locationtech.jts.geom.Geometry;

class ScalePropertyGenerator
extends PropertyGeneratorImpl {
    public ScalePropertyGenerator() {
        super(new String[]{"ROI"}, new Class[]{ROI.class}, new Class[]{RenderedOp.class});
    }

    public Object getProperty(String name, Object opNode) {
        this.validate(name, opNode);
        if (opNode instanceof RenderedOp && name.equalsIgnoreCase("roi")) {
            RenderedOp op = (RenderedOp)opNode;
            ParameterBlock pb = op.getParameterBlock();
            RenderedImage src = pb.getRenderedSource(0);
            Object property = src.getProperty("ROI");
            if (property == null || property.equals(Image.UndefinedProperty) || !(property instanceof ROI)) {
                if (pb.getObjectParameter(5) != null) {
                    property = pb.getObjectParameter(5);
                } else {
                    return Image.UndefinedProperty;
                }
            }
            ROI srcROI = (ROI)property;
            Interpolation interp = (Interpolation)pb.getObjectParameter(4);
            Rectangle srcBounds = new Rectangle(src.getMinX(), src.getMinY(), src.getWidth(), src.getHeight());
            if (!srcBounds.contains(srcROI.getBounds())) {
                srcROI = srcROI.intersect((ROI)new ROIShape((Shape)srcBounds));
            }
            float sx = pb.getFloatParameter(0);
            float sy = pb.getFloatParameter(1);
            float tx = pb.getFloatParameter(2);
            float ty = pb.getFloatParameter(3);
            ImageLayout targetLayout = new ImageLayout((RenderedImage)op);
            targetLayout.unsetValid(512);
            targetLayout.unsetValid(256);
            Rectangle dstBounds = op.getBounds();
            TranslateIntOpImage roiImage = null;
            if (sx == 1.0f && sy == 1.0f && Math.abs(tx - (float)((int)tx)) < 0.01f && Math.abs(ty - (float)((int)ty)) < 0.01f) {
                roiImage = new TranslateIntOpImage((RenderedImage)srcROI.getAsImage(), null, (int)tx, (int)ty);
            } else if (interp instanceof org.eclipse.imagen.media.interpolators.InterpolationBilinear || interp instanceof InterpolationBilinear || interp instanceof org.eclipse.imagen.media.interpolators.InterpolationBicubic || interp instanceof InterpolationBicubic) {
                ImageLayout2 layout = new ImageLayout2();
                int minx = (int)srcBounds.getMinX();
                int miny = (int)srcBounds.getMinY();
                int w = (int)srcBounds.getWidth();
                int h = (int)srcBounds.getHeight();
                layout.setMinX(minx);
                layout.setMinY(miny);
                layout.setWidth(w);
                layout.setHeight(h);
                RenderingHints hints = new RenderingHints(Collections.emptyMap());
                hints.putAll((Map<?, ?>)op.getRenderingHints());
                hints.put(ImageN.KEY_IMAGE_LAYOUT, layout);
                RenderedOp constantImage = ConstantDescriptor.create((Float)new Float(w), (Float)new Float(h), (Number[])new Byte[]{(byte)-1}, (RenderingHints)hints);
                BorderExtender extender = BorderExtender.createInstance((int)1);
                RenderingHints scalingHints = new RenderingHints(Collections.emptyMap());
                scalingHints.putAll((Map<?, ?>)op.getRenderingHints());
                scalingHints.put(ImageN.KEY_IMAGE_LAYOUT, targetLayout);
                scalingHints.put(ImageN.KEY_BORDER_EXTENDER, extender);
                boolean isBilinear = interp instanceof org.eclipse.imagen.media.interpolators.InterpolationBilinear || interp instanceof InterpolationBilinear;
                org.eclipse.imagen.media.interpolators.InterpolationBilinear interpParam = isBilinear ? new org.eclipse.imagen.media.interpolators.InterpolationBilinear(interp.getSubsampleBitsH(), null, false, 0.0, constantImage.getSampleModel().getDataType()) : new org.eclipse.imagen.media.interpolators.InterpolationBicubic(interp.getSubsampleBitsH(), null, false, 0.0, constantImage.getSampleModel().getDataType(), false, 8);
                ParameterBlock paramBlock = new ParameterBlock();
                paramBlock.setSource(constantImage, 0);
                paramBlock.add(Float.valueOf(sx));
                paramBlock.add(Float.valueOf(sy));
                paramBlock.add(Float.valueOf(tx));
                paramBlock.add(Float.valueOf(ty));
                paramBlock.add(interpParam);
                if (srcROI instanceof ROIGeometry) {
                    ROIGeometry roiGeom = (ROIGeometry)srcROI;
                    Geometry geom = roiGeom.getAsGeometry();
                    if (geom != null && !geom.isEmpty()) {
                        paramBlock.add(srcROI);
                    }
                } else {
                    paramBlock.add(srcROI);
                }
                roiImage = ImageN.create((String)"Scale", (ParameterBlock)paramBlock, (RenderingHints)scalingHints);
            } else {
                RenderingHints scalingHints = new RenderingHints(Collections.emptyMap());
                scalingHints.putAll((Map<?, ?>)op.getRenderingHints());
                scalingHints.put(ImageN.KEY_IMAGE_LAYOUT, targetLayout);
                PlanarImage roiMod = srcROI.getAsImage();
                ParameterBlock paramBlock = new ParameterBlock();
                paramBlock.setSource(roiMod, 0);
                paramBlock.add(Float.valueOf(sx));
                paramBlock.add(Float.valueOf(sy));
                paramBlock.add(Float.valueOf(tx));
                paramBlock.add(Float.valueOf(ty));
                if (interp != null) {
                    if (interp instanceof org.eclipse.imagen.media.interpolators.InterpolationBicubic || interp instanceof InterpolationBicubic) {
                        org.eclipse.imagen.media.interpolators.InterpolationBilinear interpBilinear = new org.eclipse.imagen.media.interpolators.InterpolationBilinear(interp.getSubsampleBitsH(), null, false, 0.0, roiMod.getSampleModel().getDataType());
                        paramBlock.add(interpBilinear);
                    } else {
                        paramBlock.add(interp);
                    }
                }
                roiImage = ImageN.create((String)"Scale", (ParameterBlock)paramBlock, (RenderingHints)scalingHints);
            }
            ROI dstROI = new ROI((RenderedImage)roiImage, 1);
            if (!dstBounds.contains(dstROI.getBounds())) {
                dstROI = dstROI.intersect((ROI)new ROIShape((Shape)dstBounds));
            }
            return dstROI;
        }
        return Image.UndefinedProperty;
    }
}

