/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.feature.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDTypeDefinition;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.AttributeType;
import org.geotools.api.feature.type.ComplexType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.FeatureTypeFactory;
import org.geotools.api.feature.type.GeometryType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.feature.type.PropertyDescriptor;
import org.geotools.api.feature.type.Schema;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.util.InternationalString;
import org.geotools.data.complex.feature.type.AttributeTypeProxy;
import org.geotools.data.complex.feature.type.ComplexTypeProxy;
import org.geotools.data.complex.feature.type.FeatureTypeProxy;
import org.geotools.data.complex.feature.type.GeometryTypeProxy;
import org.geotools.feature.NameImpl;
import org.geotools.feature.type.AbstractLazyComplexTypeImpl;
import org.geotools.feature.type.GeometryTypeImpl;
import org.geotools.feature.type.Types;
import org.geotools.geometry.jts.CurvedGeometry;
import org.geotools.util.logging.Logging;
import org.geotools.xs.XSSchema;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.SchemaIndex;
import org.geotools.xsd.Schemas;
import org.geotools.xsd.complex.FeatureTypeRegistryConfiguration;
import org.locationtech.jts.geom.Geometry;
import org.xml.sax.helpers.NamespaceSupport;

public class FeatureTypeRegistry {
    private static final Logger LOGGER = Logging.getLogger(FeatureTypeRegistry.class);
    private List<SchemaIndex> schemas = new ArrayList<SchemaIndex>();
    private HashMap<Name, AttributeDescriptor> descriptorRegistry;
    private HashMap<Name, AttributeType> typeRegistry;
    private HashMap<Name, AttributeType> anonTypeRegistry;
    private FeatureTypeFactory typeFactory;
    private FeatureTypeRegistryConfiguration helper;
    private boolean includeAttributes;
    private static volatile AttributeType XMLATTRIBUTE_TYPE;
    private Stack<Name> processingTypes;
    private static Map<Class<? extends FeatureTypeRegistryConfiguration>, Map<Name, AttributeType>> FOUNDATION_TYPES;

    public FeatureTypeRegistry(FeatureTypeFactory typeFactory, FeatureTypeRegistryConfiguration helper) {
        this(null, typeFactory, helper);
    }

    public FeatureTypeRegistry(NamespaceSupport namespaces, FeatureTypeFactory typeFactory, FeatureTypeRegistryConfiguration helper) {
        this(namespaces, typeFactory, helper, false);
    }

    public FeatureTypeRegistry(NamespaceSupport namespaces, FeatureTypeFactory typeFactory, FeatureTypeRegistryConfiguration helper, boolean includeAttributes) {
        this.typeFactory = typeFactory;
        this.descriptorRegistry = new HashMap();
        this.typeRegistry = new HashMap();
        this.anonTypeRegistry = new HashMap();
        this.processingTypes = new Stack();
        this.helper = helper;
        this.includeAttributes = includeAttributes;
        this.createFoundationTypes();
    }

    public void addSchemas(SchemaIndex schemaIndex) {
        this.schemas.add(schemaIndex);
    }

    public void disposeSchemaIndexes() {
        for (SchemaIndex schemaIndex : this.schemas) {
            schemaIndex.destroy();
        }
    }

    public AttributeDescriptor getDescriptor(Name descriptorName, CoordinateReferenceSystem crs) {
        AttributeDescriptor descriptor = this.descriptorRegistry.get(descriptorName);
        if (descriptor == null) {
            XSDElementDeclaration elemDecl = this.getElementDeclaration(descriptorName);
            descriptor = this.createAttributeDescriptor(null, elemDecl, crs);
            LOGGER.finest("Registering attribute descriptor " + String.valueOf(descriptor.getName()));
            this.register(descriptor);
        }
        return descriptor;
    }

    private XSDElementDeclaration getElementDeclaration(Name descriptorName) {
        SchemaIndex schemaIndex;
        QName qname = Types.toQName(descriptorName);
        XSDElementDeclaration elemDecl = null;
        Iterator<SchemaIndex> iterator = this.schemas.iterator();
        while (iterator.hasNext() && (elemDecl = (schemaIndex = iterator.next()).getElementDeclaration(qname)) == null) {
        }
        if (elemDecl == null) {
            String msg = "No top level element found in schemas: " + String.valueOf(qname);
            LOGGER.log(Level.WARNING, msg);
            throw new NoSuchElementException(msg);
        }
        return elemDecl;
    }

    public AttributeType getAttributeType(Name typeName) {
        return this.getAttributeType(typeName, null, null);
    }

    public AttributeType getAttributeType(Name typeName, XSDTypeDefinition xsdType, CoordinateReferenceSystem crs) {
        AttributeType type = this.typeRegistry.get(typeName);
        if (type == null || type instanceof AbstractLazyComplexTypeImpl) {
            if (xsdType == null) {
                xsdType = this.getTypeDefinition(typeName);
            }
            LOGGER.finest("Creating attribute type " + String.valueOf(typeName));
            type = this.createType(typeName, xsdType, crs, false);
            LOGGER.finest("Registering attribute type " + String.valueOf(typeName));
        }
        return type;
    }

    private void setSubstitutionGroup(XSDComplexTypeDefinition container, XSDElementDeclaration elemDecl, PropertyDescriptor descriptor, CoordinateReferenceSystem crs) {
        if (descriptor.getUserData().get("substitutionGroup") != null) {
            return;
        }
        ArrayList<AttributeDescriptor> substitutionGroup = new ArrayList<AttributeDescriptor>();
        descriptor.getUserData().put("substitutionGroup", substitutionGroup);
        int minOccurs = Schemas.getMinOccurs((XSDComplexTypeDefinition)container, (XSDElementDeclaration)elemDecl);
        int maxOccurs = Schemas.getMaxOccurs((XSDComplexTypeDefinition)container, (XSDElementDeclaration)elemDecl);
        boolean nillable = elemDecl.isNillable();
        for (XSDElementDeclaration sub : elemDecl.getSubstitutionGroup()) {
            if (sub.getName().equals(elemDecl.getName()) && sub.getTargetNamespace().equals(elemDecl.getTargetNamespace())) continue;
            Name elemName = Types.typeName(sub.getTargetNamespace(), sub.getName());
            AttributeType type = this.getTypeOf(sub, crs);
            if (type == null) continue;
            substitutionGroup.add(this.createAttributeDescriptor(type, crs, elemName, minOccurs, maxOccurs, nillable, null));
        }
        XSDTypeDefinition typeDef = elemDecl.getType();
        if (typeDef instanceof XSDComplexTypeDefinition) {
            Name typeName = Types.typeName(typeDef.getTargetNamespace(), typeDef.getName());
            AttributeType attType = this.typeRegistry.get(typeName);
            if (!this.processingTypes.contains(typeName)) {
                if (attType == null || attType instanceof AbstractLazyComplexTypeImpl) {
                    LOGGER.finest("Creating attribute type " + String.valueOf(typeName));
                    this.createType(typeName, typeDef, crs, false);
                    LOGGER.finest("Registering attribute type " + String.valueOf(typeName));
                } else if (attType instanceof ComplexType) {
                    ComplexType complexType = (ComplexType)attType;
                    Collection children = complexType.getDescriptors();
                    List childParticles = Schemas.getChildElementParticles((XSDTypeDefinition)typeDef, (boolean)true);
                    for (XSDParticle particle : childParticles) {
                        XSDElementDeclaration element = (XSDElementDeclaration)particle.getContent();
                        if (element.isElementDeclarationReference()) {
                            element = element.getResolvedElementDeclaration();
                        }
                        PropertyDescriptor childDesc = null;
                        for (PropertyDescriptor desc : children) {
                            if (!desc.getName().getLocalPart().equals(element.getName()) || !desc.getName().getNamespaceURI().equals(element.getTargetNamespace())) continue;
                            childDesc = desc;
                            break;
                        }
                        if (childDesc == null) continue;
                        this.setSubstitutionGroup((XSDComplexTypeDefinition)typeDef, element, childDesc, crs);
                    }
                }
            }
        }
    }

    private XSDTypeDefinition getTypeDefinition(Name typeName) {
        SchemaIndex schemaIndex;
        QName qName = Types.toQName(typeName);
        XSDTypeDefinition typeDefinition = null;
        Iterator<SchemaIndex> iterator = this.schemas.iterator();
        while (iterator.hasNext() && (typeDefinition = (schemaIndex = iterator.next()).getTypeDefinition(qName)) == null) {
        }
        if (typeDefinition == null) {
            throw new IllegalArgumentException("XSD type definition not found in schemas: " + String.valueOf(qName));
        }
        return typeDefinition;
    }

    private void register(AttributeDescriptor descriptor) {
        Name name = descriptor.getName();
        this.descriptorRegistry.put(name, descriptor);
    }

    private void register(AttributeType type, boolean anonymous) {
        Name name = type.getName();
        AttributeType old = anonymous ? this.anonTypeRegistry.put(name, type) : this.typeRegistry.put(name, type);
        if (old != null) {
            LOGGER.fine(String.valueOf(type.getName()) + " replaced by new value.");
        }
    }

    public void register(AttributeType type) {
        this.register(type, false);
    }

    private AttributeDescriptor createAttributeDescriptor(XSDComplexTypeDefinition container, XSDElementDeclaration elemDecl, CoordinateReferenceSystem crs) {
        int minOccurs = container == null ? 0 : Schemas.getMinOccurs((XSDComplexTypeDefinition)container, (XSDElementDeclaration)elemDecl);
        int maxOccurs = container == null ? Integer.MAX_VALUE : Schemas.getMaxOccurs((XSDComplexTypeDefinition)container, (XSDElementDeclaration)elemDecl);
        return this.createAttributeDescriptor(elemDecl, minOccurs, maxOccurs, crs);
    }

    private AttributeDescriptor createAttributeDescriptor(AttributeType type, CoordinateReferenceSystem crs, Name elemName, int minOccurs, int maxOccurs, boolean nillable, Object defaultValue) {
        AttributeDescriptor descriptor = null;
        if (maxOccurs == -1) {
            maxOccurs = Integer.MAX_VALUE;
        }
        if (!(type instanceof AttributeTypeProxy) && (Geometry.class.isAssignableFrom(type.getBinding()) || CurvedGeometry.class.isAssignableFrom(type.getBinding()))) {
            GeometryTypeImpl geomType = new GeometryTypeImpl(type.getName(), type.getBinding(), crs, type.isIdentified(), type.isAbstract(), type.getRestrictions(), type.getSuper(), type.getDescription());
            descriptor = this.typeFactory.createGeometryDescriptor((GeometryType)geomType, elemName, minOccurs, maxOccurs, nillable, defaultValue);
        } else {
            descriptor = this.typeFactory.createAttributeDescriptor(type, elemName, minOccurs, maxOccurs, nillable, defaultValue);
        }
        return descriptor;
    }

    private AttributeDescriptor createAttributeDescriptor(XSDElementDeclaration elemDecl, int minOccurs, int maxOccurs, CoordinateReferenceSystem crs) {
        String targetNamespace = elemDecl.getTargetNamespace();
        String name = elemDecl.getName();
        Name elemName = Types.typeName(targetNamespace, name);
        AttributeType type = this.getTypeOf(elemDecl, crs);
        boolean nillable = elemDecl.isNillable();
        Object defaultValue = null;
        AttributeDescriptor descriptor = this.createAttributeDescriptor(type, crs, elemName, minOccurs, maxOccurs, nillable, defaultValue);
        descriptor.getUserData().put(XSDElementDeclaration.class, elemDecl);
        return descriptor;
    }

    private AttributeType getTypeOf(XSDElementDeclaration elemDecl, CoordinateReferenceSystem crs) {
        AttributeType type;
        if (elemDecl.isElementDeclarationReference()) {
            elemDecl = elemDecl.getResolvedElementDeclaration();
        }
        boolean hasToBeRegistered = false;
        XSDTypeDefinition typeDefinition = elemDecl.getAnonymousTypeDefinition();
        if (typeDefinition == null) {
            hasToBeRegistered = true;
            typeDefinition = elemDecl.getTypeDefinition();
        }
        if (typeDefinition == null) {
            SchemaIndex schemaIndex;
            QName qname = Types.toQName(Types.typeName(elemDecl.getTargetNamespace(), elemDecl.getName()));
            Iterator<SchemaIndex> iterator = this.schemas.iterator();
            while (iterator.hasNext() && (elemDecl = (schemaIndex = iterator.next()).getElementDeclaration(qname)) == null) {
            }
            if (elemDecl != null) {
                if (elemDecl.isElementDeclarationReference()) {
                    elemDecl = elemDecl.getResolvedElementDeclaration();
                }
                if ((typeDefinition = elemDecl.getAnonymousTypeDefinition()) == null) {
                    typeDefinition = elemDecl.getTypeDefinition();
                }
            }
        }
        if (typeDefinition == null) {
            String msg = "The element declaration " + elemDecl.getTargetNamespace() + "#" + elemDecl.getName() + " has a null type definition, can't continue, fix it on the schema";
            LOGGER.warning(msg);
            throw new NoSuchElementException(msg);
        }
        if (hasToBeRegistered) {
            String name;
            String targetNamespace = typeDefinition.getTargetNamespace();
            Name typeName = Types.typeName(targetNamespace, name = typeDefinition.getName());
            type = this.getAttributeType(typeName, typeDefinition, crs);
            if (type == null) {
                type = this.createType(typeName, typeDefinition, crs, false);
            }
        } else {
            String name = elemDecl.getName();
            String targetNamespace = elemDecl.getTargetNamespace();
            Name overrideName = Types.typeName(targetNamespace, name);
            type = this.createType(overrideName, typeDefinition, crs, true);
        }
        return type;
    }

    private AttributeType createProxiedType(Name assignedName, XSDTypeDefinition typeDefinition, Map typeRegistry) {
        AttributeTypeProxy type = null == typeDefinition.getSimpleType() && typeDefinition instanceof XSDComplexTypeDefinition ? (this.helper.isFeatureType(typeDefinition) ? new FeatureTypeProxy(assignedName, typeRegistry) : new ComplexTypeProxy(assignedName, typeRegistry)) : (this.helper.isGeometryType(typeDefinition) ? new GeometryTypeProxy(assignedName, typeRegistry) : new AttributeTypeProxy(assignedName, typeRegistry));
        return type;
    }

    private AttributeType createType(Name assignedName, XSDTypeDefinition typeDefinition, CoordinateReferenceSystem crs, boolean anonymous) {
        AttributeType attType;
        if (this.processingTypes.contains(assignedName)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Recursion found for type " + String.valueOf(assignedName) + ". Proxying it.");
            }
            AttributeType attType2 = this.createProxiedType(assignedName, typeDefinition, anonymous ? this.anonTypeRegistry : this.typeRegistry);
            return attType2;
        }
        this.processingTypes.push(assignedName);
        XSDTypeDefinition baseType = typeDefinition.getBaseType();
        AttributeType superType = null;
        if (baseType != null) {
            String targetNamespace = baseType.getTargetNamespace();
            String name = baseType.getName();
            if (name != null) {
                NameImpl baseTypeName = new NameImpl(targetNamespace, name);
                superType = this.getAttributeType(baseTypeName, baseType, crs);
            }
        } else {
            LOGGER.fine(String.valueOf(assignedName) + " has no super type");
        }
        if (typeDefinition instanceof XSDComplexTypeDefinition) {
            XSDAttributeDeclaration att;
            AttributeDescriptor descriptor;
            XSDComplexTypeDefinition complexTypeDef = (XSDComplexTypeDefinition)typeDefinition;
            boolean includeParents = true;
            List children = Schemas.getChildElementDeclarations((XSDTypeDefinition)typeDefinition, (boolean)includeParents);
            ArrayList<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>(children.size());
            Iterator iterator = children.iterator();
            while (iterator.hasNext()) {
                XSDElementDeclaration child;
                XSDElementDeclaration childDecl = child = (XSDElementDeclaration)iterator.next();
                try {
                    descriptor = this.createAttributeDescriptor(complexTypeDef, childDecl, crs);
                }
                catch (NoSuchElementException e) {
                    String msg = "Failed to create descriptor for '" + childDecl.getTargetNamespace() + "#" + childDecl.getName() + " from container '" + typeDefinition.getTargetNamespace() + "#" + typeDefinition.getName() + "'";
                    NoSuchElementException nse = new NoSuchElementException(msg);
                    nse.initCause(e);
                    throw nse;
                }
                schema.add((PropertyDescriptor)descriptor);
            }
            if (this.includeAttributes) {
                for (XSDAttributeUse attgcontent : complexTypeDef.getAttributeUses()) {
                    att = attgcontent.getAttributeDeclaration();
                    descriptor = this.createAttributeDescriptor(this.getXmlAttributeType(), null, new NameImpl(att.getTargetNamespace(), "@" + att.getName()), 0, 1, false, null);
                    schema.add((PropertyDescriptor)descriptor);
                }
            }
            for (XSDElementDeclaration elemDecl : children) {
                if (elemDecl.isElementDeclarationReference()) {
                    elemDecl = elemDecl.getResolvedElementDeclaration();
                }
                att = null;
                for (PropertyDescriptor desc : schema) {
                    if (!desc.getName().getLocalPart().equals(elemDecl.getName()) || !desc.getName().getNamespaceURI().equals(elemDecl.getTargetNamespace())) continue;
                    att = desc;
                    break;
                }
                this.setSubstitutionGroup(complexTypeDef, elemDecl, (PropertyDescriptor)att, crs);
            }
            attType = this.createComplexAttributeType(assignedName, schema, complexTypeDef, superType);
        } else {
            Class<String> binding = String.class;
            boolean isIdentifiable = false;
            boolean isAbstract = false;
            List restrictions = Collections.emptyList();
            InternationalString description = null;
            attType = this.typeFactory.createAttributeType(assignedName, binding, isIdentifiable, isAbstract, restrictions, superType, description);
        }
        attType.getUserData().put(XSDTypeDefinition.class, typeDefinition);
        this.processingTypes.pop();
        this.register(attType, anonymous);
        return attType;
    }

    private AttributeType createComplexAttributeType(Name assignedName, Collection<PropertyDescriptor> schema, XSDComplexTypeDefinition typeDefinition, AttributeType superType) {
        FeatureType type;
        boolean isAbstract = false;
        List restrictions = Collections.emptyList();
        InternationalString description = null;
        if (this.helper.isFeatureType((XSDTypeDefinition)typeDefinition)) {
            type = this.typeFactory.createFeatureType(assignedName, schema, null, isAbstract, restrictions, superType, description);
        } else {
            boolean isIdentifiable = this.helper.isIdentifiable(typeDefinition);
            type = this.typeFactory.createComplexType(assignedName, schema, isIdentifiable, isAbstract, restrictions, superType, description);
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFoundationTypes() {
        Map foundationTypes;
        Map map = foundationTypes = FOUNDATION_TYPES.computeIfAbsent(this.helper.getClass(), o -> new HashMap());
        synchronized (map) {
            if (!foundationTypes.isEmpty()) {
                this.typeRegistry.putAll(foundationTypes);
                return;
            }
            this.importSchema((Schema)new XSSchema());
            for (Schema schema : this.helper.getSchemas()) {
                this.importSchema(schema);
            }
            for (Configuration config : this.helper.getConfigurations()) {
                this.addSchemas(Schemas.findSchemas((Configuration)config));
            }
            foundationTypes.putAll(this.typeRegistry);
        }
    }

    protected void importSchema(Schema schema) {
        for (Map.Entry nameAttributeTypeEntry : schema.entrySet()) {
            Name key = (Name)nameAttributeTypeEntry.getKey();
            Object value = nameAttributeTypeEntry.getValue();
            if (this.typeRegistry.containsKey(key)) {
                LOGGER.finer("Ignoring " + String.valueOf(key) + " as it already exists. type " + value.getClass().getName());
                continue;
            }
            LOGGER.finer("Importing " + String.valueOf(key) + " of type " + value.getClass().getName());
            if (value instanceof AttributeType) {
                AttributeType type = (AttributeType)value;
                this.register(type, false);
                continue;
            }
            if (!(value instanceof AttributeDescriptor)) continue;
            AttributeDescriptor descriptor = (AttributeDescriptor)value;
            this.register(descriptor);
        }
        LOGGER.fine("Schema " + schema.getURI() + " imported successfully");
    }

    public AttributeType getXmlAttributeType() {
        if (XMLATTRIBUTE_TYPE == null) {
            XMLATTRIBUTE_TYPE = this.typeFactory.createAttributeType((Name)new NameImpl(null, "@attribute"), String.class, false, false, Collections.emptyList(), null, null);
        }
        return XMLATTRIBUTE_TYPE;
    }

    static {
        FOUNDATION_TYPES = new ConcurrentHashMap<Class<? extends FeatureTypeRegistryConfiguration>, Map<Name, AttributeType>>();
    }
}

