/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.geotools.appschema.resolver.xml.AppSchemaConfiguration;
import org.geotools.xml.resolver.SchemaCatalog;
import org.geotools.xml.resolver.SchemaResolver;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.SchemaIndex;
import org.geotools.xsd.Schemas;

public class EmfComplexFeatureReader {
    private SchemaResolver resolver = new SchemaResolver();

    protected EmfComplexFeatureReader() {
    }

    public SchemaResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(SchemaResolver resolver) {
        this.resolver = resolver;
    }

    public void setResolver(URL catalogLocation) {
        this.resolver = new SchemaResolver(SchemaCatalog.build(catalogLocation));
    }

    public SchemaIndex parse(Configuration configuration) throws IOException {
        SchemaIndex appSchemaIndex = Schemas.findSchemas((Configuration)configuration);
        return appSchemaIndex;
    }

    public SchemaIndex parse(String nameSpace, String schemaLocation) throws IOException {
        AppSchemaConfiguration configuration = new AppSchemaConfiguration(nameSpace, schemaLocation, this.resolver);
        return this.parse((Configuration)configuration);
    }

    public SchemaIndex parse(URL location) throws IOException {
        String nameSpace = this.findSchemaNamespace(location);
        String schemaLocation = location.toExternalForm();
        return this.parse(nameSpace, schemaLocation);
    }

    public String findSchemaNamespace(URL location) throws IOException {
        String targetNamespace = null;
        URL resolvedLocation = new URL(this.resolver.resolve(location.toExternalForm()));
        try (InputStream input = resolvedLocation.openStream();){
            XMLInputFactory factory = XMLInputFactory.newFactory();
            factory.setProperty("javax.xml.stream.supportDTD", false);
            factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            XMLStreamReader parser = factory.createXMLStreamReader(input, "UTF-8");
            while (parser.hasNext() && 1 != parser.next()) {
            }
            for (int i = 0; i < parser.getAttributeCount(); ++i) {
                if (!"targetNamespace".equals(parser.getAttributeLocalName(i))) continue;
                targetNamespace = parser.getAttributeValue(i);
                break;
            }
        }
        catch (XMLStreamException e) {
            String msg = "Cannot find target namespace for schema document " + String.valueOf(resolvedLocation);
            throw (RuntimeException)new RuntimeException(msg).initCause(e);
        }
        if (targetNamespace == null) {
            throw new IllegalArgumentException("Input document does not specifies a targetNamespace");
        }
        return targetNamespace;
    }

    public static EmfComplexFeatureReader newInstance() {
        return new EmfComplexFeatureReader();
    }
}

