/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota.jdbc;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang3.SerializationUtils;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheEnvironment;
import org.geowebcache.GeoWebCacheExtensions;
import org.geowebcache.config.ConfigurationException;
import org.geowebcache.io.GeoWebCacheXStream;

public class JDBCConfiguration
implements Serializable {
    private static final Logger LOG = Logging.getLogger((String)JDBCConfiguration.class.getName());
    String dialect;
    String JNDISource;
    String schema;
    ConnectionPoolConfiguration connectionPool;

    public static JDBCConfiguration load(File sourceFile) throws ConfigurationException {
        JDBCConfiguration jDBCConfiguration;
        FileInputStream fis = new FileInputStream(sourceFile);
        try {
            jDBCConfiguration = JDBCConfiguration.load(fis);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ConfigurationException("Failed to load the configuration from " + sourceFile.getAbsolutePath(), (Throwable)e);
            }
        }
        fis.close();
        return jDBCConfiguration;
    }

    public static JDBCConfiguration load(InputStream is) throws ConfigurationException {
        XStream xs = JDBCConfiguration.getXStream();
        JDBCConfiguration conf = (JDBCConfiguration)xs.fromXML(is);
        JDBCConfiguration.validateConfiguration(conf.clone(true));
        return conf;
    }

    public static void validateConfiguration(JDBCConfiguration conf) throws ConfigurationException {
        if (conf.getDialect() == null) {
            throw new ConfigurationException("A dialect must be provided, possible values are H2, HSQL, Oracle, PostgresSQL");
        }
        ConnectionPoolConfiguration cp = conf.getConnectionPool();
        String dialect = conf.getDialect();
        if (conf.getJNDISource() == null && cp == null && !"H2".equals(dialect) && !"HSQL".equals(dialect)) {
            throw new ConfigurationException("No data source provided, either configure JNDISource or connectionPool");
        }
        if (cp != null) {
            if (cp.getDriver() == null) {
                throw new ConfigurationException("No JDBC driver provided");
            }
            if (cp.getUrl() == null) {
                throw new ConfigurationException("No JDBC URL provided");
            }
            String vq = cp.getValidationQuery();
            if (vq != null) {
                if ("H2".equalsIgnoreCase(dialect)) {
                    if (!vq.equalsIgnoreCase("SELECT 1")) {
                        throw new ConfigurationException("H2 validation query required to be: SELECT 1");
                    }
                } else if ("Oracle".equalsIgnoreCase(dialect)) {
                    if (!vq.equalsIgnoreCase("SELECT 1 FROM DUAL")) {
                        throw new ConfigurationException("Oracle validation query required to be: SELECT 1 FROM DUAL");
                    }
                } else if (!vq.equalsIgnoreCase("SELECT 1") && !vq.equalsIgnoreCase("SELECT 1 FROM DUAL")) {
                    LOG.config(dialect + " non standard validation query '" + vq + "', recommended either 'SELECT 1' or 'SELECT 1 FROM DUAL'.");
                }
            }
        }
    }

    public static void store(JDBCConfiguration config, OutputStream os) {
        XStream xs = JDBCConfiguration.getXStream();
        xs.toXML((Object)config, os);
    }

    public static void store(JDBCConfiguration config, File file) throws ConfigurationException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            JDBCConfiguration.store(config, fos);
        }
        catch (IOException e) {
            throw new ConfigurationException("Failed to store the configuration into " + file.getAbsolutePath(), (Throwable)e);
        }
    }

    private static XStream getXStream() {
        GeoWebCacheXStream xs = new GeoWebCacheXStream();
        xs.allowTypesByWildcard(new String[]{"org.geowebcache.**"});
        xs.setMode(1001);
        xs.alias("gwcJdbcConfiguration", JDBCConfiguration.class);
        xs.alias("connectionPool", ConnectionPoolConfiguration.class);
        return xs;
    }

    public String getJNDISource() {
        return this.JNDISource;
    }

    public void setJNDISource(String jndiSource) {
        this.JNDISource = jndiSource;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public ConnectionPoolConfiguration getConnectionPool() {
        return this.connectionPool;
    }

    public void setConnectionPool(ConnectionPoolConfiguration connectionPool) {
        this.connectionPool = connectionPool;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.JNDISource == null ? 0 : this.JNDISource.hashCode());
        result = 31 * result + (this.connectionPool == null ? 0 : this.connectionPool.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JDBCConfiguration other = (JDBCConfiguration)obj;
        if (this.JNDISource == null ? other.JNDISource != null : !this.JNDISource.equals(other.JNDISource)) {
            return false;
        }
        return !(this.connectionPool == null ? other.connectionPool != null : !this.connectionPool.equals(other.connectionPool));
    }

    public String getDialect() {
        return this.dialect;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    public String toString() {
        return "JDBCConfiguration [dialect=" + this.dialect + ", JNDISource=" + this.JNDISource + ", connectionPool=" + String.valueOf(this.connectionPool) + "]";
    }

    public JDBCConfiguration clone(boolean allowEnvParametrization) {
        JDBCConfiguration conf = (JDBCConfiguration)SerializationUtils.clone((Serializable)this);
        GeoWebCacheEnvironment gwcEnvironment = (GeoWebCacheEnvironment)GeoWebCacheExtensions.bean(GeoWebCacheEnvironment.class);
        if (allowEnvParametrization && gwcEnvironment != null && gwcEnvironment.isAllowEnvParametrization()) {
            conf.setDialect((String)gwcEnvironment.resolveValue((Object)this.getDialect()));
            conf.setJNDISource((String)gwcEnvironment.resolveValue((Object)this.getJNDISource()));
            ConnectionPoolConfiguration connectionPoolConfig = this.getConnectionPool();
            if (connectionPoolConfig != null) {
                ConnectionPoolConfiguration expConnectionPoolConfig = (ConnectionPoolConfiguration)SerializationUtils.clone((Serializable)connectionPoolConfig);
                expConnectionPoolConfig.setDriver((String)gwcEnvironment.resolveValue((Object)connectionPoolConfig.getDriver()));
                expConnectionPoolConfig.setUrl((String)gwcEnvironment.resolveValue((Object)connectionPoolConfig.getUrl()));
                expConnectionPoolConfig.setUsername((String)gwcEnvironment.resolveValue((Object)connectionPoolConfig.getUsername()));
                expConnectionPoolConfig.setPassword((String)gwcEnvironment.resolveValue((Object)connectionPoolConfig.getPassword()));
                expConnectionPoolConfig.setValidationQuery((String)gwcEnvironment.resolveValue((Object)connectionPoolConfig.getValidationQuery()));
                conf.setConnectionPool(expConnectionPoolConfig);
            }
        }
        return conf;
    }

    public static class ConnectionPoolConfiguration
    implements Serializable {
        private static final long serialVersionUID = 6677252877141737936L;
        String driver;
        String url;
        String username;
        String password;
        int minConnections;
        int maxConnections;
        int connectionTimeout;
        String validationQuery;
        int maxOpenPreparedStatements;

        public String getDriver() {
            return this.driver;
        }

        public void setDriver(String driver) {
            this.driver = driver;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public int getMinConnections() {
            return this.minConnections;
        }

        public void setMinConnections(int minConnections) {
            this.minConnections = minConnections;
        }

        public int getMaxConnections() {
            return this.maxConnections;
        }

        public void setMaxConnections(int maxConnections) {
            this.maxConnections = maxConnections;
        }

        public int getConnectionTimeout() {
            return this.connectionTimeout;
        }

        public void setConnectionTimeout(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
        }

        public String getValidationQuery() {
            return this.validationQuery;
        }

        public void setValidationQuery(String validationQuery) {
            this.validationQuery = validationQuery;
        }

        public int getMaxOpenPreparedStatements() {
            return this.maxOpenPreparedStatements;
        }

        public void setMaxOpenPreparedStatements(int maxOpenPreparedStatements) {
            this.maxOpenPreparedStatements = maxOpenPreparedStatements;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.connectionTimeout;
            result = 31 * result + (this.driver == null ? 0 : this.driver.hashCode());
            result = 31 * result + this.maxConnections;
            result = 31 * result + this.maxOpenPreparedStatements;
            result = 31 * result + this.minConnections;
            result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
            result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
            result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
            result = 31 * result + (this.validationQuery == null ? 0 : this.validationQuery.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConnectionPoolConfiguration other = (ConnectionPoolConfiguration)obj;
            if (this.connectionTimeout != other.connectionTimeout) {
                return false;
            }
            if (this.driver == null ? other.driver != null : !this.driver.equals(other.driver)) {
                return false;
            }
            if (this.maxConnections != other.maxConnections) {
                return false;
            }
            if (this.maxOpenPreparedStatements != other.maxOpenPreparedStatements) {
                return false;
            }
            if (this.minConnections != other.minConnections) {
                return false;
            }
            if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
                return false;
            }
            if (this.url == null ? other.url != null : !this.url.equals(other.url)) {
                return false;
            }
            if (this.username == null ? other.username != null : !this.username.equals(other.username)) {
                return false;
            }
            return !(this.validationQuery == null ? other.validationQuery != null : !this.validationQuery.equals(other.validationQuery));
        }

        public String toString() {
            return "ConnectionPoolConfiguration [driver=" + this.driver + ", url=" + this.url + ", username=" + this.username + ", password=" + this.password + ", minConnections=" + this.minConnections + ", maxConnections=" + this.maxConnections + ", connectionTimeout=" + this.connectionTimeout + ", validationQuery=" + this.validationQuery + ", maxOpenPreparedStatements=" + this.maxOpenPreparedStatements + "]";
        }
    }
}

