/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.awt.RenderingHints;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.easymock.EasyMock;
import org.geotools.api.data.DataAccess;
import org.geotools.api.data.DataAccessFactory;
import org.geotools.api.data.DataAccessFinder;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.DataStoreFactorySpi;
import org.geotools.api.data.DataStoreFinder;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.FeatureWriter;
import org.geotools.api.data.LockingManager;
import org.geotools.api.data.Query;
import org.geotools.api.data.ServiceInfo;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DataAccessFinderTest {
    private static final String MOCK_DS_PARAM_KEY = "MOCK_PARAM_KEY";
    private static final DataAccess<FeatureType, Feature> MOCK_DATAACCESS = new DataAccess<FeatureType, Feature>(){

        public void createSchema(FeatureType featureType) throws IOException {
        }

        public void dispose() {
        }

        public FeatureSource<FeatureType, Feature> getFeatureSource(Name typeName) throws IOException {
            return null;
        }

        public ServiceInfo getInfo() {
            return null;
        }

        public List<Name> getNames() throws IOException {
            return null;
        }

        public FeatureType getSchema(Name name) throws IOException {
            return null;
        }

        public void updateSchema(Name typeName, FeatureType featureType) throws IOException {
        }

        public void removeSchema(Name typeName) throws IOException {
        }
    };
    private static final DataStore MOCK_DATASTORE = new DataStore(){

        public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Query query, Transaction transaction) throws IOException {
            return null;
        }

        public SimpleFeatureSource getFeatureSource(String typeName) throws IOException {
            return null;
        }

        public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Filter filter, Transaction transaction) throws IOException {
            return null;
        }

        public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Transaction transaction) throws IOException {
            return null;
        }

        public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(String typeName, Transaction transaction) throws IOException {
            return null;
        }

        public LockingManager getLockingManager() {
            return null;
        }

        public SimpleFeatureType getSchema(String typeName) throws IOException {
            return null;
        }

        public String[] getTypeNames() throws IOException {
            return null;
        }

        public void updateSchema(String typeName, SimpleFeatureType featureType) throws IOException {
        }

        public void removeSchema(String typeName) throws IOException {
        }

        public void createSchema(SimpleFeatureType featureType) throws IOException {
        }

        public void dispose() {
        }

        public SimpleFeatureSource getFeatureSource(Name typeName) throws IOException {
            return null;
        }

        public ServiceInfo getInfo() {
            return null;
        }

        public List<Name> getNames() throws IOException {
            return null;
        }

        public SimpleFeatureType getSchema(Name name) throws IOException {
            return null;
        }

        public void updateSchema(Name typeName, SimpleFeatureType featureType) throws IOException {
        }

        public void removeSchema(Name typeName) throws IOException {
        }
    };

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testGetDataStore() throws IOException {
        HashMap<String, Class> params = new HashMap<String, Class>();
        params.put(MOCK_DS_PARAM_KEY, MockUnavailableDataStoreFactory.class);
        DataStore dataStore = DataStoreFinder.getDataStore(params);
        Assert.assertNull((Object)dataStore);
        params.put(MOCK_DS_PARAM_KEY, MockDataStoreFactory.class);
        dataStore = DataStoreFinder.getDataStore(params);
        Assert.assertSame((Object)MOCK_DATASTORE, (Object)dataStore);
    }

    @Test
    public void testGetDataAccess() throws IOException {
        HashMap<String, Class<MockDataAccessFactory>> params = new HashMap<String, Class<MockDataAccessFactory>>();
        params.put(MOCK_DS_PARAM_KEY, MockUnavailableDataStoreFactory.class);
        DataAccess dataStore = DataAccessFinder.getDataStore(params);
        Assert.assertNull((Object)dataStore);
        params.put(MOCK_DS_PARAM_KEY, MockDataStoreFactory.class);
        dataStore = DataAccessFinder.getDataStore(params);
        Assert.assertSame((Object)MOCK_DATASTORE, (Object)dataStore);
        params.put(MOCK_DS_PARAM_KEY, MockDataAccessFactory.class);
        dataStore = DataAccessFinder.getDataStore(params);
        Assert.assertSame(MOCK_DATAACCESS, (Object)dataStore);
    }

    @Test
    public void testGetAllDataStores() {
        Iterator availableDataStores = DataStoreFinder.getAllDataStores();
        Assert.assertNotNull((Object)availableDataStores);
        Assert.assertTrue((boolean)availableDataStores.hasNext());
        DataStoreFactorySpi dsf1 = (DataStoreFactorySpi)availableDataStores.next();
        Assert.assertTrue((boolean)availableDataStores.hasNext());
        DataStoreFactorySpi dsf2 = (DataStoreFactorySpi)availableDataStores.next();
        Assert.assertFalse((boolean)availableDataStores.hasNext());
        Assert.assertNotNull((Object)dsf1);
        Assert.assertNotNull((Object)dsf2);
        if (dsf1 instanceof MockUnavailableDataStoreFactory) {
            Assert.assertTrue((boolean)(dsf2 instanceof MockDataStoreFactory));
        } else {
            Assert.assertTrue((boolean)(dsf1 instanceof MockDataStoreFactory));
            Assert.assertTrue((boolean)(dsf2 instanceof MockUnavailableDataStoreFactory));
        }
    }

    @Test
    public void testGetAllDataAccess() {
        Iterator availableDataStores = DataAccessFinder.getAllDataStores();
        Assert.assertNotNull((Object)availableDataStores);
        Assert.assertTrue((boolean)availableDataStores.hasNext());
        DataAccessFactory dsf1 = (DataAccessFactory)availableDataStores.next();
        Assert.assertTrue((boolean)availableDataStores.hasNext());
        DataAccessFactory dsf2 = (DataAccessFactory)availableDataStores.next();
        Assert.assertTrue((boolean)availableDataStores.hasNext());
        DataAccessFactory dsf3 = (DataAccessFactory)availableDataStores.next();
        Assert.assertFalse((boolean)availableDataStores.hasNext());
        Assert.assertNotNull((Object)dsf1);
        Assert.assertNotNull((Object)dsf2);
        Assert.assertNotNull((Object)dsf3);
        HashSet classes = new HashSet();
        classes.add(dsf1.getClass());
        classes.add(dsf2.getClass());
        classes.add(dsf3.getClass());
        Assert.assertTrue((boolean)classes.contains(MockDataAccessFactory.class));
        Assert.assertTrue((boolean)classes.contains(MockDataStoreFactory.class));
        Assert.assertTrue((boolean)classes.contains(MockUnavailableDataStoreFactory.class));
    }

    @Test
    public void testGetAvailableDataStores() {
        Iterator availableDataStores = DataStoreFinder.getAvailableDataStores();
        Assert.assertNotNull((Object)availableDataStores);
        Assert.assertTrue((boolean)availableDataStores.hasNext());
        DataStoreFactorySpi dsf = (DataStoreFactorySpi)availableDataStores.next();
        Assert.assertFalse((boolean)availableDataStores.hasNext());
        Assert.assertTrue((boolean)(dsf instanceof MockDataStoreFactory));
    }

    @Test
    public void testGetAvailableDataAccess() {
        Iterator availableDataAccess = DataAccessFinder.getAvailableDataStores();
        Assert.assertNotNull((Object)availableDataAccess);
        Assert.assertTrue((boolean)availableDataAccess.hasNext());
        HashSet classes = new HashSet();
        DataAccessFactory daf = (DataAccessFactory)availableDataAccess.next();
        Assert.assertNotNull((Object)daf);
        classes.add(daf.getClass());
        Assert.assertTrue((boolean)availableDataAccess.hasNext());
        daf = (DataAccessFactory)availableDataAccess.next();
        Assert.assertNotNull((Object)daf);
        classes.add(daf.getClass());
        Assert.assertFalse((boolean)availableDataAccess.hasNext());
        Assert.assertTrue((boolean)classes.contains(MockDataStoreFactory.class));
        Assert.assertTrue((boolean)classes.contains(MockDataAccessFactory.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDynamicRegistration() throws Exception {
        Map<String, String> params = Map.of("testKey", "testValue");
        DataAccessFactory mockFactory = (DataAccessFactory)EasyMock.createMock(DataAccessFactory.class);
        EasyMock.expect((Object)mockFactory.isAvailable()).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)mockFactory.canProcess(params)).andReturn((Object)true).anyTimes();
        DataAccess mockAccess = (DataAccess)EasyMock.createMock(DataAccess.class);
        EasyMock.expect((Object)mockFactory.createDataStore(params)).andReturn((Object)mockAccess).anyTimes();
        EasyMock.replay((Object[])new Object[]{mockFactory});
        Assert.assertNull((Object)DataAccessFinder.getDataStore(params));
        DataAccessFinder.registerFactory((DataAccessFactory)mockFactory);
        try {
            Assert.assertEquals((Object)mockAccess, (Object)DataAccessFinder.getDataStore(params));
        }
        finally {
            DataAccessFinder.deregisterFactory((DataAccessFactory)mockFactory);
        }
        Assert.assertNull((Object)DataAccessFinder.getDataStore(params));
    }

    public static class MockUnavailableDataStoreFactory
    extends MockDataStoreFactory {
        @Override
        public boolean isAvailable() {
            return false;
        }
    }

    public static class MockDataStoreFactory
    implements DataStoreFactorySpi {
        public boolean isAvailable() {
            return true;
        }

        public boolean canProcess(Map<String, ?> params) {
            return MockDataStoreFactory.class.equals(params.get(DataAccessFinderTest.MOCK_DS_PARAM_KEY));
        }

        public DataStore createDataStore(Map<String, ?> params) throws IOException {
            return MOCK_DATASTORE;
        }

        public DataStore createNewDataStore(Map<String, ?> params) throws IOException {
            return null;
        }

        public String getDescription() {
            return null;
        }

        public String getDisplayName() {
            return null;
        }

        public DataAccessFactory.Param[] getParametersInfo() {
            return null;
        }

        public Map<RenderingHints.Key, ?> getImplementationHints() {
            return null;
        }
    }

    public static class MockDataAccessFactory
    implements DataAccessFactory {
        public boolean isAvailable() {
            return true;
        }

        public boolean canProcess(Map<String, ?> params) {
            return MockDataAccessFactory.class.equals(params.get(DataAccessFinderTest.MOCK_DS_PARAM_KEY));
        }

        public DataAccess<FeatureType, Feature> createDataStore(Map<String, ?> params) throws IOException {
            return MOCK_DATAACCESS;
        }

        public String getDescription() {
            return null;
        }

        public String getDisplayName() {
            return null;
        }

        public DataAccessFactory.Param[] getParametersInfo() {
            return null;
        }

        public Map<RenderingHints.Key, ?> getImplementationHints() {
            return null;
        }
    }
}

