/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.geotools.api.data.SimpleFeatureStore;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.IllegalAttributeException;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.identity.FeatureId;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

public class TransactionTest {
    MemoryDataStore ds;
    SimpleFeatureType type;
    Geometry geom;

    @Before
    public void setUp() throws Exception {
        this.type = DataUtilities.createType((String)"default", (String)"name:String,*geom:Geometry");
        GeometryFactory fac = new GeometryFactory();
        this.geom = fac.createPoint(new Coordinate(10.0, 10.0));
        SimpleFeature f1 = SimpleFeatureBuilder.build((SimpleFeatureType)this.type, (Object[])new Object[]{"original", this.geom}, null);
        this.ds = new MemoryDataStore(new SimpleFeature[]{f1});
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testAddFeature() throws Exception {
        SimpleFeature f1 = SimpleFeatureBuilder.build((SimpleFeatureType)this.type, (Object[])new Object[]{"one", this.geom}, null);
        SimpleFeature f2 = SimpleFeatureBuilder.build((SimpleFeatureType)this.type, (Object[])new Object[]{"two", this.geom}, null);
        SimpleFeatureStore store = (SimpleFeatureStore)this.ds.getFeatureSource("default");
        store.setTransaction((Transaction)new DefaultTransaction());
        store.addFeatures((FeatureCollection)DataUtilities.collection((SimpleFeature)f1));
        store.addFeatures((FeatureCollection)DataUtilities.collection((SimpleFeature)f2));
        this.count(store, 3);
    }

    @Test
    public void testRemoveFeature() throws Exception {
        SimpleFeature f1 = SimpleFeatureBuilder.build((SimpleFeatureType)this.type, (Object[])new Object[]{"one", this.geom}, null);
        SimpleFeatureStore store = (SimpleFeatureStore)this.ds.getFeatureSource("default");
        store.setTransaction((Transaction)new DefaultTransaction());
        List fid = store.addFeatures((FeatureCollection)DataUtilities.collection((SimpleFeature)f1));
        this.count(store, 2);
        FeatureId identifier = (FeatureId)fid.iterator().next();
        String next = identifier.getID();
        FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);
        Id f = filterFactory.id(Collections.singleton(filterFactory.featureId(next)));
        store.removeFeatures((Filter)f);
        this.count(store, 1);
    }

    private void count(SimpleFeatureStore store, int expected) throws IOException, IllegalAttributeException {
        int i = 0;
        try (SimpleFeatureIterator reader = store.getFeatures().features();){
            while (reader.hasNext()) {
                reader.next();
                ++i;
            }
        }
        Assert.assertEquals((String)"Number of known feature as obtained from reader", (long)expected, (long)i);
    }
}

