/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.geometry.jts.CompoundCurve;
import org.geotools.geometry.jts.CompoundRing;
import org.geotools.geometry.jts.CurvedGeometry;
import org.geotools.geometry.jts.MultiCurve;
import org.geotools.geometry.jts.MultiCurvedGeometry;
import org.geotools.test.TestData;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.Converters;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.io.WKTReader;

public class GeometryTypeConverterTest {
    Set<ConverterFactory> factories = null;
    List<String> tests = new ArrayList<String>();
    WKTReader wktReader = new WKTReader();

    protected Converter getConverter(Geometry source, Class<?> target) {
        Assert.assertNotNull((String)"Cannot get ConverterFactory for Geometry -> Geometry conversion", this.factories);
        if (this.factories == null) {
            return null;
        }
        for (ConverterFactory factory : this.factories) {
            Converter candidate = factory.createConverter(source.getClass(), target, null);
            if (candidate == null) continue;
            return candidate;
        }
        Assert.fail((String)("Cannot get ConverterFactory for " + source.getClass().getName() + " -> " + target.getName() + " conversion"));
        return null;
    }

    @Before
    public void setUp() throws Exception {
        this.factories = Converters.getConverterFactories(Geometry.class, Geometry.class);
        File testData = TestData.file((Object)this, (String)"converter/tests.txt");
        Assert.assertNotNull((String)"Cannot find test file (converter.txt)", (Object)testData);
        try (BufferedReader reader = new BufferedReader(new FileReader(testData, StandardCharsets.UTF_8));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                this.tests.add(line);
            }
        }
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testData() throws Exception {
        for (String test : this.tests) {
            String[] parts = test.split(":");
            Assert.assertEquals((String)"Test rows should have the form \"source:target:expected:description\"", (long)4L, (long)parts.length);
            Geometry source = this.wktReader.read(parts[0]);
            source.setSRID(4326);
            Class<?> target = Class.forName("org.locationtech.jts.geom." + parts[1]);
            String expected = parts[2];
            Geometry converted = this.convert(source, target);
            Assert.assertEquals((Object)expected, (Object)converted.toText());
            Assert.assertEquals((long)4326L, (long)converted.getSRID());
        }
    }

    private Geometry convert(Geometry source, Class<?> target) throws Exception {
        Converter converter = this.getConverter(source, target);
        Object dest = converter.convert((Object)source, target);
        Assert.assertNotNull((String)("Cannot convert " + source.toText() + " to " + target.getName()), (Object)dest);
        Assert.assertTrue((String)"Converted object is not a Geometry", (boolean)(dest instanceof Geometry));
        return (Geometry)dest;
    }

    @Test
    public void testLineStringToCurve() throws Exception {
        Geometry ls = new WKTReader().read("LINESTRING(0 0, 10 10)");
        Converter converter = this.getConverter(ls, CurvedGeometry.class);
        CurvedGeometry curve = (CurvedGeometry)converter.convert((Object)ls, CurvedGeometry.class);
        Assert.assertTrue((boolean)(curve instanceof CompoundCurve));
        CompoundCurve cc = (CompoundCurve)curve;
        Assert.assertEquals((long)1L, (long)cc.getComponents().size());
        Assert.assertEquals((Object)ls, cc.getComponents().get(0));
    }

    @Test
    public void testLineStringToMultiCurve() throws Exception {
        Geometry ls = new WKTReader().read("LINESTRING(0 0, 10 10)");
        Converter converter = this.getConverter(ls, CurvedGeometry.class);
        MultiCurvedGeometry curve = (MultiCurvedGeometry)converter.convert((Object)ls, MultiCurvedGeometry.class);
        Assert.assertTrue((boolean)(curve instanceof MultiCurve));
        MultiCurve mc = (MultiCurve)curve;
        Assert.assertEquals((long)1L, (long)mc.getNumGeometries());
        Assert.assertEquals((Object)ls, (Object)mc.getGeometryN(0));
    }

    @Test
    public void testLinearRingToCurve() throws Exception {
        Geometry ls = new WKTReader().read("LINEARRING(0 0, 10 10, 10 0, 0 0)");
        Map<String, String> userData = Collections.singletonMap("test", "value");
        ls.setUserData(userData);
        Converter converter = this.getConverter(ls, CurvedGeometry.class);
        CurvedGeometry curve = (CurvedGeometry)converter.convert((Object)ls, CurvedGeometry.class);
        Assert.assertTrue((boolean)(curve instanceof CompoundRing));
        CompoundRing cr = (CompoundRing)curve;
        Assert.assertEquals((long)1L, (long)cr.getComponents().size());
        Assert.assertEquals((Object)ls, cr.getComponents().get(0));
        Assert.assertEquals(userData, (Object)cr.getUserData());
    }

    @Test
    public void testPolygonToMultiPolygon() throws Exception {
        Geometry pol = new WKTReader().read("POLYGON((0 0, 10 10, 10 0, 0 0))");
        Map<String, String> userData = Collections.singletonMap("test", "value");
        pol.setUserData(userData);
        Converter converter = this.getConverter(pol, MultiPolygon.class);
        MultiPolygon mp = (MultiPolygon)converter.convert((Object)pol, MultiPolygon.class);
        Assert.assertEquals((long)1L, (long)mp.getNumGeometries());
        Assert.assertEquals((Object)pol, (Object)mp.getGeometryN(0));
        Assert.assertNull((Object)mp.getGeometryN(0).getUserData());
        Assert.assertEquals(userData, (Object)mp.getUserData());
    }
}

