/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.geotools.api.feature.type.Name;
import org.geotools.feature.NameImpl;
import org.junit.Assert;
import org.junit.Test;

public class NameImplTest {
    @Test
    public void testSerialize() throws Exception {
        NameImpl name = new NameImpl("hello", "world");
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(buffer);
        out.writeObject(name);
        byte[] bytes = buffer.toByteArray();
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        ObjectInputStream in = new ObjectInputStream(input);
        Name copy = (Name)in.readObject();
        Assert.assertNotSame((Object)name, (Object)copy);
        Assert.assertEquals((Object)name, (Object)copy);
    }

    @Test
    public void testCompare() {
        NameImpl scoped1 = new NameImpl("hello", "world");
        NameImpl scoped2 = new NameImpl("hello", "fred");
        NameImpl fred = new NameImpl("world");
        Assert.assertEquals((long)0L, (long)scoped1.compareTo(scoped1));
        Assert.assertEquals((long)0L, (long)scoped2.compareTo(scoped2));
        Assert.assertEquals((long)0L, (long)fred.compareTo(fred));
        Assert.assertTrue((scoped1.compareTo(scoped2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((scoped2.compareTo(scoped1) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((scoped2.compareTo(scoped1) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((scoped1.compareTo(new NameImpl(null, scoped1.getLocalPart())) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((new NameImpl(null, scoped1.getLocalPart()).compareTo(scoped1) > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)new NameImpl(null, "t").compareTo(new NameImpl(null, "t")));
    }
}

