/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.simple;

import java.util.ArrayList;
import java.util.Arrays;
import org.geotools.api.feature.Attribute;
import org.geotools.api.feature.IllegalAttributeException;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.PropertyIsGreaterThanOrEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.type.Types;
import org.geotools.util.NumberRange;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;

public class SimpleFeatureBuilderTest {
    SimpleFeatureBuilder builder;
    SimpleFeatureType featureType;

    @Before
    public void setUp() throws Exception {
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        AttributeTypeBuilder attributeBuilder = new AttributeTypeBuilder();
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        typeBuilder.setName("test");
        typeBuilder.add("point", Point.class, (CoordinateReferenceSystem)null);
        PropertyIsGreaterThanOrEqualTo nonNegative = ff.greaterOrEqual((Expression)ff.property("."), (Expression)ff.literal(0));
        attributeBuilder.setBinding(Integer.class);
        attributeBuilder.setNillable(false);
        attributeBuilder.addRestriction((Filter)nonNegative);
        typeBuilder.add(attributeBuilder.buildDescriptor("integer"));
        typeBuilder.add("float", Float.class);
        this.featureType = typeBuilder.buildFeatureType();
        this.builder = new SimpleFeatureBuilder(this.featureType);
        this.builder.setValidating(true);
    }

    @Test
    public void testSanity() throws Exception {
        GeometryFactory gf = new GeometryFactory();
        this.builder.add((Object)gf.createPoint(new Coordinate(0.0, 0.0)));
        this.builder.add((Object)1);
        this.builder.add((Object)Float.valueOf(2.0f));
        SimpleFeature feature = this.builder.buildFeature("fid");
        Assert.assertNotNull((Object)feature);
        Assert.assertEquals((long)3L, (long)feature.getAttributeCount());
        Assert.assertEquals((Object)gf.createPoint(new Coordinate(0.0, 0.0)), (Object)feature.getAttribute("point"));
        Assert.assertEquals((Object)1, (Object)feature.getAttribute("integer"));
        Assert.assertEquals((Object)Float.valueOf(2.0f), (Object)feature.getAttribute("float"));
    }

    @Test
    public void testValidation() {
        GeometryFactory gf = new GeometryFactory();
        Point point = gf.createPoint(new Coordinate(0.0, 0.0));
        this.builder.setValidating(false);
        this.builder.add((Object)point);
        this.builder.add((Object)-1);
        this.builder.add((Object)Float.valueOf(0.0f));
        SimpleFeature invalidFeature = this.builder.buildFeature("invalid");
        Assert.assertTrue((String)"valid", (boolean)Types.isValid((Attribute)((Attribute)invalidFeature.getProperty("point"))));
        Assert.assertFalse((String)"valid", (boolean)Types.isValid((Attribute)((Attribute)invalidFeature.getProperty("integer"))));
        Assert.assertTrue((String)"valid", (boolean)Types.isValid((Attribute)((Attribute)invalidFeature.getProperty("float"))));
        Assert.assertFalse((String)"invalid", (boolean)Types.isValid((Attribute)invalidFeature));
        this.builder.setValidating(true);
        this.builder.add((Object)point);
        try {
            this.builder.add((Object)-1);
            Assert.fail((String)"Builder with validation enabled should not be able to add an invalid value");
        }
        catch (IllegalAttributeException illegalAttributeException) {
            // empty catch block
        }
        this.builder.reset();
        this.builder.setValidating(false);
        this.builder.add((Object)point);
        this.builder.add((Object)-1);
        this.builder.add((Object)Float.valueOf(0.0f));
        this.builder.setValidating(true);
        try {
            SimpleFeature brokenFeature = this.builder.buildFeature("broken");
            Assert.assertNotNull((Object)brokenFeature);
            Assert.fail((String)"Builder with validation should not produce invalid feature");
        }
        catch (IllegalAttributeException illegalAttributeException) {
            // empty catch block
        }
    }

    @Test
    public void testBeRelaxedAboutNumberOfAttributes() throws Exception {
        GeometryFactory gf = new GeometryFactory();
        Point point = gf.createPoint(new Coordinate(0.0, 0.0));
        this.builder.add((Object)point);
        this.builder.add((Object)1);
        SimpleFeature feature = this.builder.buildFeature("fid.1");
        Assert.assertNotNull((Object)feature);
        Assert.assertEquals((long)3L, (long)feature.getAttributeCount());
        Assert.assertEquals((Object)gf.createPoint(new Coordinate(0.0, 0.0)), (Object)feature.getAttribute("point"));
        Assert.assertEquals((Object)1, (Object)feature.getAttribute("integer"));
        Assert.assertNull((Object)feature.getAttribute("float"));
        ArrayList<Point> tooFew = new ArrayList<Point>();
        tooFew.add(point);
        SimpleFeature feature2 = SimpleFeatureBuilder.build((SimpleFeatureType)this.featureType, tooFew, (String)"fid.2");
        Assert.assertNotNull((Object)feature2);
        Assert.assertSame((String)"provided point", (Object)point, (Object)feature.getAttribute(0));
        Assert.assertNotNull((String)"default count", (Object)feature.getAttribute(1));
        ArrayList<Object> tooMany = new ArrayList<Object>();
        tooMany.add(point);
        tooMany.add(1);
        tooMany.add(Float.valueOf(3.0f));
        tooMany.add("Sasquatch");
        SimpleFeature feature3 = SimpleFeatureBuilder.build((SimpleFeatureType)this.featureType, tooMany, (String)"fid.3");
        Assert.assertNotNull((Object)feature3);
    }

    @Test
    public void testSetSequential() throws Exception {
        GeometryFactory gf = new GeometryFactory();
        this.builder.set("point", (Object)gf.createPoint(new Coordinate(0.0, 0.0)));
        this.builder.set("integer", (Object)1);
        this.builder.set("float", (Object)Float.valueOf(2.0f));
        SimpleFeature feature = this.builder.buildFeature("fid");
        Assert.assertNotNull((Object)feature);
        Assert.assertEquals((long)3L, (long)feature.getAttributeCount());
        Assert.assertEquals((Object)gf.createPoint(new Coordinate(0.0, 0.0)), (Object)feature.getAttribute(0));
        Assert.assertEquals((Object)1, (Object)feature.getAttribute(1));
        Assert.assertEquals((Object)Float.valueOf(2.0f), (Object)feature.getAttribute(2));
    }

    @Test
    public void testSetNonSequential() throws Exception {
        GeometryFactory gf = new GeometryFactory();
        this.builder.set("float", (Object)Float.valueOf(2.0f));
        this.builder.set("point", (Object)gf.createPoint(new Coordinate(0.0, 0.0)));
        this.builder.set("integer", (Object)1);
        SimpleFeature feature = this.builder.buildFeature("fid");
        Assert.assertNotNull((Object)feature);
        Assert.assertEquals((long)3L, (long)feature.getAttributeCount());
        Assert.assertEquals((Object)gf.createPoint(new Coordinate(0.0, 0.0)), (Object)feature.getAttribute(0));
        Assert.assertEquals((Object)1, (Object)feature.getAttribute(1));
        Assert.assertEquals((Object)Float.valueOf(2.0f), (Object)feature.getAttribute(2));
    }

    @Test
    public void testSetTooFew() throws Exception {
        this.builder.set("integer", (Object)1);
        SimpleFeature feature = this.builder.buildFeature("fid");
        Assert.assertNotNull((Object)feature);
        Assert.assertEquals((long)3L, (long)feature.getAttributeCount());
        Assert.assertNull((Object)feature.getAttribute(0));
        Assert.assertEquals((Object)1, (Object)feature.getAttribute(1));
        Assert.assertNull((Object)feature.getAttribute(2));
    }

    @Test
    public void testConverting() throws Exception {
        this.builder.set("integer", (Object)"1");
        this.builder.buildFeature("fid");
        try {
            this.builder.set("integer", (Object)"foo");
            Assert.fail((String)"should have failed");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testCreateFeatureWithLength() throws Exception {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("test");
        builder.length(5).add("name", String.class);
        SimpleFeatureType featureType = builder.buildFeatureType();
        SimpleFeature feature = SimpleFeatureBuilder.build((SimpleFeatureType)featureType, (Object[])new Object[]{"Val"}, (String)"ID");
        Assert.assertNotNull((Object)feature);
        try {
            feature = SimpleFeatureBuilder.build((SimpleFeatureType)featureType, (Object[])new Object[]{"Longer Than 5"}, (String)"ID");
            feature.validate();
            Assert.fail((String)"this should fail because the value is longer than 5 characters");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testCreateFeatureWithRestriction() throws Exception {
        FilterFactory fac = CommonFactoryFinder.getFilterFactory(null);
        String attributeName = "string";
        PropertyIsEqualTo filter = fac.equals((Expression)fac.property("."), (Expression)fac.literal((Object)"Value"));
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("test");
        builder.restriction((Filter)filter).add(attributeName, String.class);
        SimpleFeatureType featureType = builder.buildFeatureType();
        SimpleFeature feature = SimpleFeatureBuilder.build((SimpleFeatureType)featureType, (Object[])new Object[]{"Value"}, (String)"ID");
        Assert.assertNotNull((Object)feature);
        try {
            SimpleFeature sf = SimpleFeatureBuilder.build((SimpleFeatureType)featureType, (Object[])new Object[]{"NotValue"}, (String)"ID");
            sf.validate();
            Assert.fail((String)"PropertyIsEqualTo filter should have failed");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testCreateFeatureWithOptions() throws Exception {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("test");
        builder.options(new Object[]{"a", "b", "c"}).add("name", String.class);
        SimpleFeatureType featureType = builder.buildFeatureType();
        SimpleFeature feature = SimpleFeatureBuilder.build((SimpleFeatureType)featureType, (Object[])new Object[]{"a"}, (String)"ID");
        Assert.assertNotNull((Object)feature);
        feature.validate();
        try {
            feature = SimpleFeatureBuilder.build((SimpleFeatureType)featureType, (Object[])new Object[]{"d"}, (String)"ID");
            feature.validate();
            Assert.fail((String)"this should fail because the value is not either a, b or c, but d");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testCreateFeatureWithOptionsOnAttributeTypeBuilder() throws Exception {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("test");
        AttributeTypeBuilder atb = new AttributeTypeBuilder();
        atb.name("name").binding(String.class).options(Arrays.asList("a", "b", "c"));
        builder.add(atb.buildDescriptor("name"));
        SimpleFeatureType featureType = builder.buildFeatureType();
        SimpleFeature feature = SimpleFeatureBuilder.build((SimpleFeatureType)featureType, (Object[])new Object[]{"a"}, (String)"ID");
        Assert.assertNotNull((Object)feature);
        feature.validate();
        try {
            feature = SimpleFeatureBuilder.build((SimpleFeatureType)featureType, (Object[])new Object[]{"d"}, (String)"ID");
            feature.validate();
            Assert.fail((String)"this should fail because the value is not either a, b or c, but d");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testCreateFeatureWithRange() throws Exception {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("test");
        builder.range(NumberRange.create((int)0, (int)100)).add("size", String.class);
        SimpleFeatureType featureType = builder.buildFeatureType();
        SimpleFeature feature = SimpleFeatureBuilder.build((SimpleFeatureType)featureType, (Object[])new Object[]{100}, (String)"ID");
        Assert.assertNotNull((Object)feature);
        feature.validate();
        try {
            feature = SimpleFeatureBuilder.build((SimpleFeatureType)featureType, (Object[])new Object[]{101}, (String)"ID");
            feature.validate();
            Assert.fail((String)"this should fail because the value is outside the permitted range [0,100]");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testCreateFeatureWithRangeOnAttributeTypeBuilder() throws Exception {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("test");
        AttributeTypeBuilder atb = new AttributeTypeBuilder();
        atb.name("size").binding(String.class).range(NumberRange.create((int)0, (int)100));
        builder.add(atb.buildDescriptor("size"));
        SimpleFeatureType featureType = builder.buildFeatureType();
        SimpleFeature feature = SimpleFeatureBuilder.build((SimpleFeatureType)featureType, (Object[])new Object[]{100}, (String)"ID");
        Assert.assertNotNull((Object)feature);
        feature.validate();
        try {
            feature = SimpleFeatureBuilder.build((SimpleFeatureType)featureType, (Object[])new Object[]{101}, (String)"ID");
            feature.validate();
            Assert.fail((String)"this should fail because the value is outside the permitted range [0,100]");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testUserData() throws Exception {
        SimpleFeature feature = this.buildUserDataFeature();
        Assert.assertNotNull((Object)feature);
        Assert.assertEquals((Object)"bar", feature.getUserData().get("foo"));
        this.builder = new SimpleFeatureBuilder(feature.getFeatureType());
        this.builder.init(feature);
        feature = this.builder.buildFeature("fid");
        Assert.assertNotNull((Object)feature);
        Assert.assertEquals((Object)"bar", feature.getUserData().get("foo"));
    }

    private SimpleFeature buildUserDataFeature() {
        GeometryFactory gf = new GeometryFactory();
        this.builder.add((Object)gf.createPoint(new Coordinate(0.0, 0.0)));
        this.builder.add((Object)1);
        this.builder.add((Object)Float.valueOf(2.0f));
        this.builder.featureUserData((Object)"foo", (Object)"bar");
        return this.builder.buildFeature("fid");
    }

    @Test
    public void testCopyUserData() throws Exception {
        SimpleFeature template = this.buildUserDataFeature();
        this.builder = new SimpleFeatureBuilder(template.getFeatureType());
        GeometryFactory gf = new GeometryFactory();
        this.builder.add((Object)gf.createPoint(new Coordinate(1.0, 1.0)));
        this.builder.add((Object)2);
        this.builder.add((Object)Float.valueOf(4.0f));
        this.builder.featureUserData(template);
        SimpleFeature feature = this.builder.buildFeature("myfid");
        Assert.assertEquals((Object)"bar", feature.getUserData().get("foo"));
    }
}

