/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import org.geotools.feature.visitor.AbstractCalcResult;
import org.junit.Assert;
import org.junit.Test;

public class CalcResultTest {
    MockCalcResult result = new MockCalcResult();
    Integer val1 = 4;
    Long val2 = 5L;
    Float val3 = Float.valueOf(6.0f);
    Double val4 = 7.0;
    String val5 = "8";
    String val6 = "Random text of arbitrary complexity.";

    @Test
    public void testInt() {
        this.result.setValue(this.val1);
        Assert.assertEquals((long)4L, (long)this.result.toInt());
        this.result.setValue(this.val2);
        Assert.assertEquals((long)5L, (long)this.result.toInt());
        this.result.setValue(this.val3);
        Assert.assertEquals((long)6L, (long)this.result.toInt());
        this.result.setValue(this.val4);
        Assert.assertEquals((long)7L, (long)this.result.toInt());
        this.result.setValue(this.val5);
        Assert.assertEquals((long)0L, (long)this.result.toInt());
        this.result.setValue(this.val6);
        Assert.assertEquals((long)0L, (long)this.result.toInt());
    }

    @Test
    public void testLong() {
        this.result.setValue(this.val1);
        Assert.assertEquals((long)4L, (long)this.result.toLong());
        this.result.setValue(this.val2);
        Assert.assertEquals((long)5L, (long)this.result.toLong());
        this.result.setValue(this.val3);
        Assert.assertEquals((long)6L, (long)this.result.toLong());
        this.result.setValue(this.val4);
        Assert.assertEquals((long)7L, (long)this.result.toLong());
        this.result.setValue(this.val5);
        Assert.assertEquals((long)0L, (long)this.result.toLong());
        this.result.setValue(this.val6);
        Assert.assertEquals((long)0L, (long)this.result.toLong());
    }

    @Test
    public void testFloat() {
        this.result.setValue(this.val1);
        Assert.assertEquals((float)4.0f, (float)this.result.toFloat(), (float)0.0f);
        this.result.setValue(this.val2);
        Assert.assertEquals((float)5.0f, (float)this.result.toFloat(), (float)0.0f);
        this.result.setValue(this.val3);
        Assert.assertEquals((float)6.0f, (float)this.result.toFloat(), (float)0.0f);
        this.result.setValue(this.val4);
        Assert.assertEquals((float)7.0f, (float)this.result.toFloat(), (float)0.0f);
        this.result.setValue(this.val5);
        Assert.assertEquals((float)0.0f, (float)this.result.toFloat(), (float)0.0f);
        this.result.setValue(this.val6);
        Assert.assertEquals((float)0.0f, (float)this.result.toFloat(), (float)0.0f);
    }

    @Test
    public void testDouble() {
        this.result.setValue(this.val1);
        Assert.assertEquals((double)4.0, (double)this.result.toDouble(), (double)0.0);
        this.result.setValue(this.val2);
        Assert.assertEquals((double)5.0, (double)this.result.toDouble(), (double)0.0);
        this.result.setValue(this.val3);
        Assert.assertEquals((double)6.0, (double)this.result.toDouble(), (double)0.0);
        this.result.setValue(this.val4);
        Assert.assertEquals((double)7.0, (double)this.result.toDouble(), (double)0.0);
        this.result.setValue(this.val5);
        Assert.assertEquals((double)0.0, (double)this.result.toDouble(), (double)0.0);
        this.result.setValue(this.val6);
        Assert.assertEquals((double)0.0, (double)this.result.toDouble(), (double)0.0);
    }

    @Test
    public void testString() {
        this.result.setValue(this.val1);
        Assert.assertEquals((Object)"4", (Object)this.result.toString());
        this.result.setValue(this.val2);
        Assert.assertEquals((Object)"5", (Object)this.result.toString());
        this.result.setValue(this.val3);
        Assert.assertEquals((Object)"6.0", (Object)this.result.toString());
        this.result.setValue(this.val4);
        Assert.assertEquals((Object)"7.0", (Object)this.result.toString());
        this.result.setValue(this.val5);
        Assert.assertEquals((Object)"8", (Object)this.result.toString());
        this.result.setValue(this.val6);
        Assert.assertEquals((Object)"Random text of arbitrary complexity.", (Object)this.result.toString());
    }

    public static class MockCalcResult
    extends AbstractCalcResult {
        Object value;

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }
}

