/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.memory.MemoryFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.visitor.MinVisitor;
import org.junit.Assert;
import org.junit.Test;

public class MinVisitorTest {
    private static SimpleFeatureType SCHEMA;

    @Test(expected=IllegalStateException.class)
    public void visitedFlagSetWithoutValue() throws Exception {
        MemoryFeatureCollection collection = new MemoryFeatureCollection(SCHEMA);
        collection.add(SimpleFeatureBuilder.build((SimpleFeatureType)SCHEMA, (Object[])new Object[]{1}, (String)"1"));
        PreVisitedMinVisitor falseVisitor = new PreVisitedMinVisitor("AInteger");
        try {
            collection.accepts((FeatureVisitor)falseVisitor, null);
        }
        catch (Exception e) {
            while (e.getCause() != null) {
                e = (Exception)e.getCause();
            }
            throw e;
        }
    }

    @Test
    public void resetCallWillNullify() throws Exception {
        MemoryFeatureCollection collection = new MemoryFeatureCollection(SCHEMA);
        collection.add(SimpleFeatureBuilder.build((SimpleFeatureType)SCHEMA, (Object[])new Object[]{1}, (String)"1"));
        MinVisitor visitor = new MinVisitor("AInteger");
        collection.accepts((FeatureVisitor)visitor, null);
        visitor.reset();
        collection.accepts((FeatureVisitor)visitor, null);
        Assert.assertEquals((Object)1, (Object)((Integer)visitor.getMin()));
    }

    static {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("Test");
        builder.add("AInteger", Integer.class);
        SCHEMA = builder.buildFeatureType();
    }

    private static class PreVisitedMinVisitor
    extends MinVisitor {
        PreVisitedMinVisitor(String attribute) {
            super(attribute);
            this.visited = true;
        }
    }
}

