/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.FilterFactory;
import org.geotools.data.DataUtilities;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.visitor.UniqueVisitor;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.locationtech.jts.io.WKTReader;

public class UniqueVisitorTest {
    private static WKTReader wktParser = new WKTReader();
    private static SimpleFeatureType uniqueValuesCountTestType;
    private static FeatureCollection featureCollection;
    static FilterFactory ff;

    @BeforeClass
    public static void setup() throws Exception {
        uniqueValuesCountTestType = DataUtilities.createType((String)"uniqueValuesCount", (String)"id:Integer,aStringValue:String,aDoubleValue:Double,aIntValue:Integer,geo:Geometry");
        SimpleFeature[] simpleFeatures = new SimpleFeature[]{SimpleFeatureBuilder.build((SimpleFeatureType)uniqueValuesCountTestType, (Object[])new Object[]{1, "A", 50.0, 3, wktParser.read("POINT(-5 -5)")}, null), SimpleFeatureBuilder.build((SimpleFeatureType)uniqueValuesCountTestType, (Object[])new Object[]{2, "B", 10.0, 4, wktParser.read("POINT(-5 -5)")}, null), SimpleFeatureBuilder.build((SimpleFeatureType)uniqueValuesCountTestType, (Object[])new Object[]{3, "C", 20.0, 1, wktParser.read("POINT(-5 -5)")}, null), SimpleFeatureBuilder.build((SimpleFeatureType)uniqueValuesCountTestType, (Object[])new Object[]{4, "D", 30.0, 5, wktParser.read("POINT(5 5)")}, null), SimpleFeatureBuilder.build((SimpleFeatureType)uniqueValuesCountTestType, (Object[])new Object[]{5, "E", 60.0, 6, wktParser.read("POINT(5 5)")}, null), SimpleFeatureBuilder.build((SimpleFeatureType)uniqueValuesCountTestType, (Object[])new Object[]{6, "E", 10.0, 7, wktParser.read("POINT(5 5)")}, null), SimpleFeatureBuilder.build((SimpleFeatureType)uniqueValuesCountTestType, (Object[])new Object[]{7, "C", 20.0, 10, wktParser.read("POINT(5 -5)")}, null), SimpleFeatureBuilder.build((SimpleFeatureType)uniqueValuesCountTestType, (Object[])new Object[]{8, "C", 30.0, 11, wktParser.read("POINT(5 -5)")}, null), SimpleFeatureBuilder.build((SimpleFeatureType)uniqueValuesCountTestType, (Object[])new Object[]{9, "A", 500.0, 12, wktParser.read("POINT(0 0)")}, null), SimpleFeatureBuilder.build((SimpleFeatureType)uniqueValuesCountTestType, (Object[])new Object[]{10, "A", 500.0, 12, wktParser.read("POINT(0 0)")}, null), SimpleFeatureBuilder.build((SimpleFeatureType)uniqueValuesCountTestType, (Object[])new Object[]{11, "A", 500.0, 12, wktParser.read("POINT(0 0)")}, null)};
        featureCollection = DataUtilities.collection((SimpleFeature[])simpleFeatures);
    }

    @Test
    public void testUniqueVisitor() throws IOException {
        UniqueVisitor uniqueVisitor = new UniqueVisitor(new String[]{"aStringValue"});
        featureCollection.accepts((FeatureVisitor)uniqueVisitor, null);
        Set result = uniqueVisitor.getResult().toSet();
        List<String> expected = Arrays.asList("A", "B", "C", "D", "E");
        Assert.assertEquals((long)expected.size(), (long)result.size());
        Assert.assertTrue((boolean)expected.containsAll(result));
    }

    @Test
    public void testUniqueVisitor2() throws IOException {
        UniqueVisitor uniqueVisitor = new UniqueVisitor(new String[]{"aDoubleValue"});
        featureCollection.accepts((FeatureVisitor)uniqueVisitor, null);
        Set result = uniqueVisitor.getResult().toSet();
        List<Double> expected = Arrays.asList(10.0, 20.0, 30.0, 50.0, 60.0, 500.0);
        Assert.assertEquals((long)expected.size(), (long)result.size());
        Assert.assertTrue((boolean)result.containsAll(expected));
    }

    @Test
    public void testMultipleAttributes() throws IOException {
        UniqueVisitor uniqueVisitor = new UniqueVisitor(new String[]{"aStringValue", "aDoubleValue"});
        featureCollection.accepts((FeatureVisitor)uniqueVisitor, null);
        Set result = uniqueVisitor.getResult().toSet();
        HashSet expected = new HashSet(8);
        this.addValues(expected, "A", 500.0);
        this.addValues(expected, "C", 30.0);
        this.addValues(expected, "C", 20.0);
        this.addValues(expected, "E", 10.0);
        this.addValues(expected, "E", 60.0);
        this.addValues(expected, "D", 30.0);
        this.addValues(expected, "B", 10.0);
        this.addValues(expected, "A", 50.0);
        Assert.assertEquals((long)expected.size(), (long)result.size());
        Assert.assertTrue((boolean)expected.containsAll(result));
    }

    @Test
    public void testMultipleAttributes2() throws IOException {
        UniqueVisitor uniqueVisitor = new UniqueVisitor(new String[]{"aStringValue", "aDoubleValue", "aIntValue"});
        featureCollection.accepts((FeatureVisitor)uniqueVisitor, null);
        Set result = uniqueVisitor.getResult().toSet();
        HashSet expected = new HashSet(9);
        this.addValues(expected, "C", 20.0, 10);
        this.addValues(expected, "A", 500.0, 12);
        this.addValues(expected, "E", 10.0, 7);
        this.addValues(expected, "B", 10.0, 4);
        this.addValues(expected, "E", 60.0, 6);
        this.addValues(expected, "D", 30.0, 5);
        this.addValues(expected, "C", 30.0, 11);
        this.addValues(expected, "A", 50.0, 3);
        this.addValues(expected, "C", 20.0, 1);
        Assert.assertEquals((long)expected.size(), (long)result.size());
        Assert.assertTrue((boolean)expected.containsAll(result));
    }

    private void addValues(Set set, Object ... values) {
        LinkedList list = Arrays.stream(values).collect(Collectors.toCollection(LinkedList::new));
        set.add(list);
    }

    static {
        ff = CommonFactoryFinder.getFilterFactory();
    }
}

