/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.Collections;
import java.util.logging.Logger;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.And;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.spatial.Disjoint;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.FidFilterImpl;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.IsBetweenImpl;
import org.geotools.filter.LikeFilterImpl;
import org.geotools.filter.LiteralExpressionImpl;
import org.geotools.filter.NullFilterImpl;
import org.geotools.filter.expression.AddImpl;
import org.geotools.filter.expression.SubtractImpl;
import org.geotools.filter.identity.FeatureIdImpl;
import org.geotools.util.logging.Logging;
import org.junit.Assert;
import org.junit.Test;

public class FilterEqualsTest {
    private static final Logger LOGGER = Logging.getLogger(FilterEqualsTest.class);
    private FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    private Expression testExp1;
    private Expression testExp2;
    private Expression testExp3;
    private Expression testExp4;
    private Filter tFilter1;
    private static SimpleFeatureType testSchema = null;

    @Test
    public void testLiteralExpressionImplEquals() {
        try {
            LiteralExpressionImpl testString1 = new LiteralExpressionImpl("test literal");
            LiteralExpressionImpl testString2 = new LiteralExpressionImpl("test literal");
            Assert.assertEquals((Object)testString1, (Object)testString2);
            LiteralExpressionImpl testOtherString = new LiteralExpressionImpl("not test literal");
            Assert.assertNotEquals((Object)testString1, (Object)testOtherString);
            LiteralExpressionImpl testNumber34 = new LiteralExpressionImpl((Object)34);
            Assert.assertNotEquals((Object)testString1, (Object)testNumber34);
            LiteralExpressionImpl testOtherNumber34 = new LiteralExpressionImpl((Object)34);
            Assert.assertEquals((Object)testNumber34, (Object)testOtherNumber34);
        }
        catch (IllegalFilterException e) {
            LOGGER.warning("bad filter " + e.getMessage());
        }
    }

    @Test
    public void testFidFilter() {
        FidFilterImpl ff = new FidFilterImpl(Collections.singleton(new FeatureIdImpl("1")));
        FidFilterImpl ff2 = new FidFilterImpl(Collections.singleton(new FeatureIdImpl("1")));
        Assert.assertNotNull((Object)ff2);
        Assert.assertEquals((Object)ff, (Object)ff2);
        Assert.assertNotEquals(null, (Object)ff);
        ff2.addFid("2");
        Assert.assertNotEquals((Object)ff, (Object)ff2);
        ff.addFid("2");
        Assert.assertEquals((Object)ff, (Object)ff2);
    }

    @Test
    public void testExpressionMath() {
        try {
            this.testExp1 = new LiteralExpressionImpl((Object)5.0);
            this.testExp2 = new LiteralExpressionImpl((Object)5.0);
            AddImpl testMath1 = new AddImpl(null, null);
            testMath1.setExpression1(this.testExp1);
            testMath1.setExpression2(this.testExp2);
            AddImpl testMath2 = new AddImpl(null, null);
            testMath2.setExpression1(this.testExp2);
            testMath2.setExpression2(this.testExp1);
            Assert.assertEquals((Object)testMath1, (Object)testMath2);
            this.testExp3 = new LiteralExpressionImpl((Object)4);
            this.testExp4 = new LiteralExpressionImpl((Object)4);
            testMath2.setExpression1(this.testExp3);
            Assert.assertNotEquals((Object)testMath1, (Object)testMath2);
            testMath1.setExpression1(this.testExp4);
            Assert.assertEquals((Object)testMath1, (Object)testMath2);
            testMath1 = new SubtractImpl(null, null);
            testMath1.setExpression1(this.testExp4);
            testMath1.setExpression1(this.testExp2);
            Assert.assertNotEquals((Object)testMath1, (Object)testMath2);
        }
        catch (IllegalFilterException e) {
            LOGGER.warning("bad filter: " + e.getMessage());
        }
    }

    @Test
    public void testExpressionAttribute() throws IllegalFilterException, SchemaException {
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.add("testBoolean", Boolean.class);
        ftb.add("testString", String.class);
        ftb.setName("test2");
        SimpleFeatureType testSchema2 = ftb.buildFeatureType();
        this.testExp1 = new AttributeExpressionImpl(testSchema, "testBoolean");
        this.testExp2 = new AttributeExpressionImpl(testSchema, "testBoolean");
        Assert.assertEquals((Object)this.testExp1, (Object)this.testExp2);
        this.testExp3 = new AttributeExpressionImpl(testSchema, "testString");
        Assert.assertNotEquals((Object)this.testExp1, (Object)this.testExp3);
        this.testExp4 = new AttributeExpressionImpl(testSchema2, "testBoolean");
        Assert.assertNotEquals((Object)this.testExp1, (Object)this.testExp4);
        this.testExp1 = new AttributeExpressionImpl(testSchema2, "testBoolean");
        Assert.assertEquals((Object)this.testExp1, (Object)this.testExp4);
    }

    @Test
    public void testCompareFilter() throws IllegalFilterException {
        this.testExp1 = new LiteralExpressionImpl((Object)45);
        this.testExp2 = new LiteralExpressionImpl((Object)45);
        this.testExp3 = new AttributeExpressionImpl(testSchema, "testInteger");
        this.testExp4 = new AttributeExpressionImpl(testSchema, "testInteger");
        PropertyIsEqualTo cFilter1 = this.ff.equals(this.testExp1, this.testExp3);
        PropertyIsEqualTo cFilter2 = this.ff.equals(this.testExp1, this.testExp3);
        Assert.assertEquals((Object)cFilter1, (Object)cFilter2);
        cFilter2 = this.ff.equals(this.testExp2, this.testExp4);
        Assert.assertEquals((Object)cFilter1, (Object)cFilter2);
        cFilter2 = this.ff.equals((Expression)this.ff.literal((Object)45.0), this.testExp3);
        Assert.assertEquals((Object)cFilter1, (Object)cFilter2);
        this.tFilter1 = this.ff.between(this.testExp1, this.testExp2, this.testExp3);
        Assert.assertNotEquals((Object)cFilter1, (Object)this.tFilter1);
    }

    @Test
    public void testBetweenFilter() throws IllegalFilterException {
        IsBetweenImpl bFilter1 = new IsBetweenImpl(null, null, null);
        IsBetweenImpl bFilter2 = new IsBetweenImpl(null, null, null);
        LiteralExpressionImpl testLit1 = new LiteralExpressionImpl((Object)55);
        LiteralExpressionImpl testLit2 = new LiteralExpressionImpl((Object)55);
        this.testExp1 = new LiteralExpressionImpl((Object)45);
        this.testExp2 = new LiteralExpressionImpl((Object)45);
        this.testExp3 = new AttributeExpressionImpl(testSchema, "testInteger");
        this.testExp4 = new AttributeExpressionImpl(testSchema, "testInteger");
        bFilter1.setExpression1(this.testExp1);
        bFilter2.setExpression1(this.testExp2);
        bFilter1.setExpression(this.testExp3);
        bFilter2.setExpression(this.testExp4);
        bFilter1.setExpression2((Expression)testLit1);
        bFilter2.setExpression2((Expression)testLit2);
        Assert.assertEquals((Object)bFilter2, (Object)bFilter1);
        this.tFilter1 = this.ff.equals(Expression.NIL, Expression.NIL);
        Assert.assertNotEquals((Object)bFilter2, (Object)this.tFilter1);
        bFilter2.setExpression2((Expression)new LiteralExpressionImpl((Object)65));
        Assert.assertNotEquals((Object)bFilter2, (Object)bFilter1);
    }

    @Test
    public void testLikeFilter() throws IllegalFilterException {
        LikeFilterImpl lFilter1 = new LikeFilterImpl();
        LikeFilterImpl lFilter2 = new LikeFilterImpl();
        String pattern = "te_st!";
        String wcMulti = "!";
        String wcSingle = "_";
        String escape = "#";
        this.testExp2 = new LiteralExpressionImpl((Object)45);
        this.testExp3 = new AttributeExpressionImpl(testSchema, "testInteger");
        this.testExp4 = new AttributeExpressionImpl(testSchema, "testInteger");
        lFilter1.setExpression(this.testExp3);
        lFilter2.setExpression(this.testExp4);
        lFilter1.setLiteral(pattern);
        lFilter1.setWildCard(wcMulti);
        lFilter1.setSingleChar(wcSingle);
        lFilter1.setEscape(escape);
        lFilter2.setLiteral(pattern);
        lFilter2.setWildCard(wcMulti);
        lFilter2.setSingleChar(wcSingle);
        lFilter2.setEscape(escape);
        Assert.assertEquals((Object)lFilter1, (Object)lFilter2);
        lFilter2.setLiteral("te__t!");
        lFilter2.setWildCard(wcMulti);
        lFilter2.setSingleChar(wcSingle);
        lFilter2.setEscape(escape);
        Assert.assertNotEquals((Object)lFilter1, (Object)lFilter2);
        lFilter2.setLiteral(pattern);
        lFilter2.setWildCard(wcMulti);
        lFilter2.setSingleChar(wcSingle);
        lFilter2.setEscape(escape);
        lFilter2.setExpression(this.testExp2);
        Assert.assertNotEquals((Object)lFilter1, (Object)lFilter2);
    }

    @Test
    public void testLogicFilter() throws IllegalFilterException {
        this.testExp1 = new LiteralExpressionImpl((Object)45);
        this.testExp2 = new LiteralExpressionImpl((Object)45);
        this.testExp3 = new AttributeExpressionImpl(testSchema, "testInteger");
        this.testExp4 = new AttributeExpressionImpl(testSchema, "testInteger");
        PropertyIsEqualTo cFilter1 = this.ff.equals(this.testExp1, this.testExp2);
        PropertyIsEqualTo cFilter2 = this.ff.equals(this.testExp2, this.testExp4);
        And logFilter1 = this.ff.and((Filter)cFilter1, (Filter)cFilter2);
        And logFilter2 = this.ff.and((Filter)cFilter1, (Filter)cFilter2);
        Assert.assertEquals((Object)logFilter1, (Object)logFilter2);
        logFilter1 = this.ff.not((Filter)cFilter2);
        Assert.assertNotEquals((Object)logFilter1, (Object)logFilter2);
        cFilter1 = this.ff.equals(this.testExp1, this.testExp3);
        logFilter2 = this.ff.not((Filter)cFilter1);
        Assert.assertEquals((Object)logFilter1, (Object)logFilter2);
        Assert.assertNotEquals((Object)logFilter1, (Object)this.ff.between(this.testExp1, this.testExp2, this.testExp3));
        Or logFilter3 = this.ff.or((Filter)logFilter1, (Filter)logFilter2);
        Or logFilter4 = this.ff.or((Filter)logFilter1, (Filter)logFilter2);
        Assert.assertEquals((Object)logFilter3, (Object)logFilter4);
        Or logFilter5 = this.ff.or((Filter)cFilter1, (Filter)logFilter3);
        Or logFilter6 = this.ff.or((Filter)logFilter4, (Filter)cFilter1);
        Assert.assertEquals((Object)logFilter5, (Object)logFilter6);
        Assert.assertEquals((Object)logFilter4, (Object)logFilter3);
    }

    @Test
    public void testNullFilter() throws IllegalFilterException {
        this.testExp1 = new AttributeExpressionImpl(testSchema, "testDouble");
        this.testExp2 = new AttributeExpressionImpl(testSchema, "testDouble");
        this.testExp3 = new AttributeExpressionImpl(testSchema, "testBoolean");
        NullFilterImpl nullFilter1 = new NullFilterImpl(Expression.NIL);
        NullFilterImpl nullFilter2 = new NullFilterImpl(Expression.NIL);
        nullFilter1.setExpression(this.testExp1);
        nullFilter2.setExpression(this.testExp2);
        Assert.assertEquals((Object)nullFilter1, (Object)nullFilter2);
        nullFilter1.setExpression(this.testExp3);
        Assert.assertNotEquals((Object)nullFilter1, (Object)nullFilter2);
    }

    @Test
    public void testGeometryFilter() throws IllegalFilterException {
        Disjoint geomFilter1 = this.ff.disjoint(this.testExp1, this.testExp4);
        Disjoint geomFilter2 = this.ff.disjoint(this.testExp2, this.testExp4);
        Assert.assertEquals((Object)geomFilter1, (Object)geomFilter2);
        geomFilter2 = this.ff.disjoint(this.testExp2, (Expression)new LiteralExpressionImpl((Object)45.0));
        Assert.assertNotEquals((Object)geomFilter1, (Object)geomFilter2);
        this.tFilter1 = this.ff.between((Expression)this.ff.literal(1), (Expression)this.ff.literal(-1), (Expression)this.ff.literal(3));
        Assert.assertNotEquals((Object)geomFilter1, (Object)this.tFilter1);
    }
}

