/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import org.geotools.api.filter.And;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.expression.Expression;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.Filters;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class FiltersTest {
    private static final double DELTA = 1.0E-7;
    private static Filters filters;
    private static FilterFactory ff;
    private static Filter a;
    private static Filter b;
    private static Filter c;
    private static Filter d;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        ff = CommonFactoryFinder.getFilterFactory(null);
        filters = new Filters(ff);
        a = ff.greater((Expression)ff.property("zone"), (Expression)ff.literal(7));
        b = ff.like((Expression)ff.property("suburb"), "N%");
        c = ff.equals((Expression)ff.property("Subject"), (Expression)ff.literal((Object)"foo"));
        d = ff.equals((Expression)ff.property("Subject"), (Expression)ff.literal((Object)"bar"));
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        ff = null;
        filters = null;
    }

    @Test
    public void testAnd() {
        Filter result = Filters.and((FilterFactory)ff, (Filter)a, (Filter)b);
        Assert.assertEquals((Object)ff.and(a, b), (Object)result);
    }

    @Test
    public void testOr() {
        Filter result = Filters.or((FilterFactory)ff, (Filter)a, (Filter)b);
        Assert.assertEquals((Object)ff.or(a, b), (Object)result);
    }

    @Test
    public void testDuplicate() {
        Filter copy = filters.duplicate(a);
        Assert.assertNotSame((Object)copy, (Object)a);
        Assert.assertEquals((Object)copy, (Object)a);
    }

    @Test
    public void testAsInt() {
        Assert.assertEquals((long)1L, (long)Filters.asInt((Expression)ff.literal(1)));
        Assert.assertEquals((long)1L, (long)Filters.asInt((Expression)ff.literal((Object)"1")));
        Assert.assertEquals((long)-1L, (long)Filters.asInt((Expression)ff.property("fred")));
    }

    @Test
    public void testAsString() {
        Assert.assertEquals((Object)"1", (Object)Filters.asString((Expression)ff.literal((Object)"1")));
        Assert.assertEquals((Object)"1", (Object)Filters.asString((Expression)ff.literal(1)));
        Assert.assertEquals((Object)"1.0", (Object)Filters.asString((Expression)ff.literal(1.0)));
        Assert.assertEquals((Object)"3.14", (Object)Filters.asString((Expression)ff.literal(3.14)));
        Assert.assertEquals((Object)"#000000", (Object)Filters.asString((Expression)ff.literal((Object)Color.BLACK)));
    }

    @Test
    public void testAsDouble() {
        Assert.assertEquals((double)1.0, (double)Filters.asInt((Expression)ff.literal(1)), (double)1.0E-7);
        Assert.assertEquals((double)1.0, (double)Filters.asInt((Expression)ff.literal((Object)"1")), (double)1.0E-7);
    }

    @Test
    public void testNumber() {
        Assert.assertEquals((double)1.0, (double)Filters.number((Object)"1.0"), (double)1.0E-7);
        Assert.assertEquals((double)1.0, (double)Filters.number((Object)"1"), (double)1.0E-7);
    }

    @Test
    public void testGets() throws Throwable {
        Assert.assertEquals((Object)1L, (Object)Filters.gets((String)"1.0", Long.class));
    }

    @Test
    public void testPutsDouble() {
        Assert.assertEquals((Object)"1", (Object)Filters.puts((double)1.0));
        Assert.assertEquals((Object)"3.14", (Object)Filters.puts((double)3.14));
    }

    @Test
    public void testPutsObject() {
        Assert.assertEquals((Object)"42", (Object)Filters.puts((double)42.0));
    }

    @Test
    public void testPutsColor() {
        Assert.assertEquals((Object)"#0000ff", (Object)Filters.puts((Color)Color.BLUE));
    }

    @Test
    public void testRemoveFilter() {
        Filter results = Filters.removeFilter(null, (Filter)a);
        Assert.assertNull((String)"Start with nothing should end with nothing", (Object)results);
        results = Filters.removeFilter((Filter)a, null);
        Assert.assertSame((String)"Existing should be returned with null target", (Object)a, (Object)results);
        And base = ff.and(Arrays.asList(a, b, c));
        results = Filters.removeFilter((Filter)base, (Filter)d);
        Assert.assertEquals((String)"Should not change when target not a child", (Object)base, (Object)results);
        results = Filters.removeFilter((Filter)base, (Filter)b);
        And expected = ff.and(a, c);
        Assert.assertEquals((Object)expected, (Object)results);
        results = Filters.removeFilter((Filter)results, (Filter)a);
        Assert.assertEquals((Object)results, (Object)c);
        results = Filters.removeFilter((Filter)results, (Filter)c);
        Assert.assertSame((String)"Include should be returned when same filter", (Object)Filter.INCLUDE, (Object)results);
    }

    @Test
    public void testRemoveFilterCompound() {
        Or childOr = ff.or(Arrays.asList(b, c, d));
        And base = ff.and(a, (Filter)childOr);
        Filter results = Filters.removeFilter((Filter)base, (Filter)d, (boolean)false);
        Assert.assertEquals((String)"Filter should not be removed because it should not recurse", (Object)base, (Object)results);
        results = Filters.removeFilter((Filter)base, (Filter)d);
        Assert.assertNotEquals((String)"Results should be a new object with different children", (Object)base, (Object)results);
        childOr = ff.or(b, c);
        And expected = ff.and(a, (Filter)childOr);
        Assert.assertEquals((Object)expected, (Object)results);
        results = Filters.removeFilter((Filter)results, (Filter)c);
        expected = ff.and(a, b);
        Assert.assertEquals((Object)expected, (Object)results);
        results = Filters.removeFilter((Filter)results, (Filter)a);
        Assert.assertEquals((Object)b, (Object)results);
        results = Filters.removeFilter((Filter)results, (Filter)b);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)results);
    }

    @Test
    public void testFindPropertyName() {
        String results = Filters.findPropertyName((Filter)b);
        Assert.assertEquals((Object)"suburb", (Object)results);
        ff.equals((Expression)ff.literal((Object)"bar"), (Expression)ff.literal((Object)"foo"));
    }

    @Test
    public void testFindPropertyNameEmpty() {
        Assert.assertNull((Object)Filters.findPropertyName(null));
        PropertyIsEqualTo f = ff.equals((Expression)ff.literal((Object)"bar"), (Expression)ff.literal((Object)"foo"));
        Assert.assertNull((Object)Filters.findPropertyName((Filter)f));
    }

    @Test
    public void testEmptyEscape() {
        PropertyIsLike like = ff.like((Expression)ff.literal((Object)"abc def"), "*de*", "*", "_", "");
        Assert.assertTrue((boolean)like.evaluate(null));
    }

    @Test
    public void testLogicFilterEquality() {
        And andAB = ff.and(a, b);
        And andAA = ff.and(a, a);
        Assert.assertNotEquals((Object)andAB, (Object)andAA);
        And andAAA = ff.and(List.of(a, a, a));
        Assert.assertNotEquals((Object)andAA, (Object)andAAA);
        And andAAB = ff.and(List.of(a, a, b));
        And andABA = ff.and(List.of(a, b, a));
        Assert.assertEquals((Object)andAAB, (Object)andABA);
    }
}

