/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.api.filter.expression.Add;
import org.geotools.api.filter.expression.Divide;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.Multiply;
import org.geotools.api.filter.expression.NilExpression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.expression.Subtract;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.Filters;
import org.geotools.filter.FunctionExpression;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.LiteralExpressionImpl;
import org.geotools.util.logging.Logging;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FunctionExpressionImplTest {
    private static final Logger LOGGER = Logging.getLogger(FunctionExpressionImplTest.class);
    FunctionExpressionImpl function;
    TestExpressionVisitor testVisitor;

    @Before
    public void setUp() throws Exception {
        this.function = new FunctionExpressionImpl(FunctionExpressionImpl.functionName((String)"testFunction", (String)"test:String", (String[])new String[]{"argument:String"})){};
        this.testVisitor = new TestExpressionVisitor();
    }

    @After
    public void tearDown() throws Exception {
        this.function = null;
        this.testVisitor = null;
    }

    @Test
    public void testAcceptExpressionVisitor() {
        Object extraData = new Object();
        this.function.accept((ExpressionVisitor)this.testVisitor, extraData);
        Object[] expected = new Object[]{Boolean.TRUE, extraData};
        Object[] actual = this.testVisitor.functionVisited;
        Assert.assertEquals((Object)expected[0], (Object)actual[0]);
        Assert.assertEquals((Object)expected[1], (Object)actual[1]);
    }

    @Test
    public void testGetType() {
        Assert.assertEquals((long)114L, (long)Filters.getExpressionType((Expression)this.function));
    }

    @Test
    public void testGetName() {
        FunctionExpressionImpl anonymous = new FunctionExpressionImpl(FunctionExpressionImpl.functionName((String)"testFunction", (String)"text:String", (String[])new String[0])){};
        Assert.assertEquals((Object)"testFunction", (Object)anonymous.getName());
    }

    @Test
    public void testGetParameters() {
        List<LiteralExpressionImpl> expected;
        this.function.params = expected = Collections.singletonList(new LiteralExpressionImpl(10.0));
        Assert.assertEquals(expected, (Object)this.function.getParameters());
    }

    @Test
    public void testSetParameters() {
        List<LiteralExpressionImpl> expected = Collections.singletonList(new LiteralExpressionImpl(10.0));
        this.function.setParameters(expected);
        Assert.assertEquals(expected, (Object)this.function.params);
    }

    @Test
    public void testGetArgs() {
        List<LiteralExpressionImpl> expected = Collections.singletonList(new LiteralExpressionImpl(10.0));
        this.function.setParameters(expected);
        List actual = this.function.getParameters();
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testSetArgs() {
        List<LiteralExpressionImpl> expected = Collections.singletonList(new LiteralExpressionImpl(10.0));
        this.function.setParameters(expected);
        Assert.assertEquals(expected, (Object)this.function.params);
    }

    @Test
    public void testGetArgCount() {
        List<LiteralExpressionImpl> expected = Collections.singletonList(new LiteralExpressionImpl(10.0));
        this.function.setParameters(expected);
        Assert.assertEquals((long)1L, (long)this.function.getFunctionName().getArgumentCount());
    }

    @Test
    public void testGetImplementationHints() {
        Assert.assertNotNull((Object)this.function.getImplementationHints());
        Assert.assertTrue((boolean)this.function.getImplementationHints().isEmpty());
    }

    @Test
    public void testImplementations() throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        List<Class<?>> functionClasses = this.loadFunctionClasses();
        LinkedList<String> errors = new LinkedList<String>();
        for (Class<?> functionClass : functionClasses) {
            Function function = (Function)functionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.testFunction(function, errors);
        }
        if (!errors.isEmpty()) {
            String errorsMessage = this.buildErrosMessage(errors);
            LOGGER.info(errorsMessage);
            Assert.fail((String)errorsMessage);
        }
    }

    private String buildErrosMessage(List errors) {
        StringBuffer sb = new StringBuffer("Some function expression implementations violates contract:\n");
        int errorCount = 1;
        for (Object o : errors) {
            String error = (String)o;
            sb.append(errorCount++ + " - ");
            sb.append(error);
            sb.append("\n");
        }
        return sb.toString();
    }

    private void testFunction(Function function, List<String> errors) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        List parameters;
        String functionClass = function.getClass().getName();
        if (null == function.getName()) {
            errors.add(functionClass + ": getName() == null");
        }
        this.testVisitor = new TestExpressionVisitor();
        String extraData = "[extraData correctly returned]";
        function.accept((ExpressionVisitor)this.testVisitor, (Object)extraData);
        Object[] functionVisited = this.testVisitor.functionVisited;
        if (Boolean.TRUE != functionVisited[0] || extraData != functionVisited[1]) {
            errors.add(functionClass + ": accept didn't called visitor.visit(Function, extraData):  visited: " + String.valueOf(functionVisited[0]) + ", extraData: " + String.valueOf(functionVisited[1]));
        }
        try {
            function.toString();
        }
        catch (Exception e) {
            this.addExceptionError(errors, functionClass, "toString", e);
        }
        if (function instanceof FunctionExpression) {
            FunctionExpression expression = (FunctionExpression)function;
            this.testDeprecatedMethods(expression, errors);
        }
        if ((parameters = function.getParameters()) == null) {
            errors.add(functionClass + ".getParameters() returns null");
        }
    }

    private void addExceptionError(List<String> errors, String functionClass, String method, Exception e) {
        errors.add(functionClass + "." + method + "() throwed an exception: " + e.getMessage());
    }

    private void testDeprecatedMethods(FunctionExpression function, List<String> errors) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        String functionClass = function.getClass().getName();
        int argCount = function.getFunctionName().getArgumentCount();
        if (argCount < 0) {
            argCount = 5;
        }
        ArrayList<AttributeExpressionImpl> expected = new ArrayList<AttributeExpressionImpl>();
        for (int i = 0; i < argCount; ++i) {
            AttributeExpressionImpl ex = new AttributeExpressionImpl("attName");
            expected.add(ex);
        }
        try {
            function.setParameters(expected);
        }
        catch (Exception e) {
            this.addExceptionError(errors, functionClass, "setArgs", e);
        }
        ArrayList returnedParams = function.getParameters();
        if (returnedParams == null) {
            errors.add(functionClass + ".getParameters() returned null when parameters were set through setArgs(Expression[])");
        } else if (!expected.equals(returnedParams)) {
            errors.add(functionClass + ".getParameters() returned a wrong result when parameters were set through setArgs(Expression[])");
        }
        function = (FunctionExpression)function.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        function.setParameters(expected);
        List returnedArgs = function.getParameters();
        if (returnedArgs == null) {
            errors.add(functionClass + ".getParameters() returns null then arguments set through setParameters()");
        } else {
            returnedParams = new ArrayList(expected);
            if (!expected.equals(returnedParams)) {
                errors.add(functionClass + ".getParameters() incompatible with getParameters()");
            }
        }
        if (114 != Filters.getExpressionType((Expression)function)) {
            errors.add(functionClass + ".getType != 114");
        }
    }

    private List<Class<?>> loadFunctionClasses() throws IOException, ClassNotFoundException {
        String spiDefinitionResource = "/META-INF/services/org.geotools.api.filter.expression.Function";
        try (InputStream in = this.getClass().getResourceAsStream("/META-INF/services/org.geotools.api.filter.expression.Function");){
            LinkedList linkedList;
            if (in == null) {
                throw new FileNotFoundException("/META-INF/services/org.geotools.api.filter.expression.Function");
            }
            LinkedList functionClasses = new LinkedList();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                String className;
                while ((className = reader.readLine()) != null) {
                    Class<?> functionClazz = Class.forName(className);
                    functionClasses.add(functionClazz);
                }
                linkedList = functionClasses;
            }
            return linkedList;
        }
    }

    private static class TestExpressionVisitor
    implements ExpressionVisitor {
        public Object[] functionVisited = new Object[]{Boolean.FALSE, null};

        private TestExpressionVisitor() {
        }

        public Object visit(Function expression, Object extraData) {
            this.functionVisited[0] = Boolean.TRUE;
            this.functionVisited[1] = extraData;
            return null;
        }

        public Object visit(Add expression, Object extraData) {
            return null;
        }

        public Object visit(Divide expression, Object extraData) {
            return null;
        }

        public Object visit(Literal expression, Object extraData) {
            return null;
        }

        public Object visit(Multiply expression, Object extraData) {
            return null;
        }

        public Object visit(PropertyName expression, Object extraData) {
            return null;
        }

        public Object visit(Subtract expression, Object extraData) {
            return null;
        }

        public Object visit(NilExpression arg0, Object arg1) {
            return null;
        }
    }
}

