/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.function.FilterFunction_minimumCircle;
import org.geotools.filter.function.FunctionTestFixture;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.algorithm.MinimumBoundingCircle;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;

public class FilterFunction_minimumCircleTest {
    @Test
    public void testGetArgCount() {
        FilterFunction_minimumCircle f = new FilterFunction_minimumCircle();
        Assert.assertEquals((long)1L, (long)f.getFunctionName().getArgumentCount());
    }

    @Test
    public void getName() {
        FilterFunction_minimumCircle f = new FilterFunction_minimumCircle();
        Assert.assertEquals((Object)"mincircle", (Object)f.getName());
    }

    @Test
    public void testEvaluate() throws Exception {
        SimpleFeatureCollection featureCollection = FunctionTestFixture.polygons();
        FilterFactory ff = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
        Function exp = ff.function("mincircle", new Expression[]{ff.property("geom")});
        try (SimpleFeatureIterator iter = featureCollection.features();){
            while (iter.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iter.next();
                Geometry geom = (Geometry)feature.getDefaultGeometry();
                Geometry circle = new MinimumBoundingCircle(geom).getCircle();
                Object value = exp.evaluate((Object)feature);
                Assert.assertTrue((boolean)(value instanceof Polygon));
                Assert.assertEquals((Object)circle, (Object)value);
            }
        }
        Assert.assertNull((Object)exp.evaluate(null));
    }
}

