/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTReader;

public class FilterFunction_setCRSTest {
    FilterFactory ff = CommonFactoryFinder.getFilterFactory();
    Geometry g;

    @Before
    public void setup() throws Exception {
        this.g = new WKTReader().read("POINT(0 0)");
    }

    @Test
    public void setCRSObject() {
        Function f = this.ff.function("setCRS", new Expression[]{this.ff.literal((Object)this.g), this.ff.literal((Object)DefaultGeographicCRS.WGS84)});
        Geometry sg = (Geometry)f.evaluate(null);
        Assert.assertEquals((Object)DefaultGeographicCRS.WGS84, (Object)sg.getUserData());
    }

    @Test
    public void setCRSCode() throws Exception {
        Function f = this.ff.function("setCRS", new Expression[]{this.ff.literal((Object)this.g), this.ff.literal((Object)"EPSG:4326")});
        Geometry sg = (Geometry)f.evaluate(null);
        Assert.assertEquals((Object)CRS.decode("EPSG:4326"), (Object)sg.getUserData());
    }

    @Test
    public void setCRSWkt() {
        Function f = this.ff.function("setCRS", new Expression[]{this.ff.literal((Object)this.g), this.ff.literal((Object)DefaultGeographicCRS.WGS84.toWKT())});
        Geometry sg = (Geometry)f.evaluate(null);
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata(DefaultGeographicCRS.WGS84, sg.getUserData()));
    }
}

