/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.factory.CommonFactoryFinder;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.io.WKTReader;

public class MidAngleFunctionTest {
    @Test
    public void testMidAngleSimple() throws Exception {
        LineString line = (LineString)new WKTReader().read("LINESTRING(0 0, 10 10)");
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        Function midAngleFunction = ff.function("midAngle", new Expression[]{ff.literal((Object)line)});
        Double midAngle = (Double)midAngleFunction.evaluate((Object)line);
        Assert.assertEquals((double)-45.0, (double)midAngle, (double)1.0E-6);
        Function startAngleFunction = ff.function("startAngle", new Expression[]{ff.literal((Object)line)});
        Double startAngle = (Double)startAngleFunction.evaluate((Object)line);
        Function endAngleFunction = ff.function("endAngle", new Expression[]{ff.literal((Object)line)});
        Double endAngle = (Double)endAngleFunction.evaluate((Object)line);
        Assert.assertEquals((double)midAngle, (double)startAngle, (double)1.0E-6);
        Assert.assertEquals((double)midAngle, (double)endAngle, (double)1.0E-6);
    }

    @Test
    public void testMidPointComplex() throws Exception {
        LineString line = (LineString)new WKTReader().read("LINESTRING(0 10, 5 0, 15 10)");
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        Function midAngleFunction = ff.function("midAngle", new Expression[]{ff.literal((Object)line)});
        Double midAngle = (Double)midAngleFunction.evaluate((Object)line);
        Assert.assertEquals((double)-45.0, (double)midAngle, (double)1.0E-6);
    }
}

